package strawberry.config;

import com.sun.faces.config.beans.*;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import java.util.logging.*;
/**
 * Created on 2006/12/26
 *
 * @author masa
 */
public class FacesConfigLoader extends DefaultHandler {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.application");
  

  public void log(String msg) {
    log.finest(msg);
  }

  /**
   *
   */
  public FacesConfigBean load(String path) {

    if (path == null) throw new NullPointerException();

    try {
      SAXParserFactory fac = SAXParserFactory.newInstance();
      
      SAXParser parser = fac.newSAXParser();
      parser.parse(path, this);
    } catch (Exception ex) {
      ex.printStackTrace();
    }
    if (log.isLoggable(Level.FINER)) {
      print();
    }
    return configBean;
  }


  public void print() {

    log("_______________________");
    ManagedBeanBean[] beanBean = configBean.getManagedBeans();
    for (int i = 0; i < beanBean.length; i++) {
      ManagedBeanBean mb = beanBean[i];
      
      log("" + i + ", getManagedBeanName: " + mb.getManagedBeanName());
      log("" + i + ", getManagedBeanClass: " + mb.getManagedBeanClass());
      log("" + i + ", getManagedBeanScope: " + mb.getManagedBeanScope());

      ManagedPropertyBean[] propArray = mb.getManagedProperties();
      for (int j = 0; j < propArray.length; j++) {
        ManagedPropertyBean pb = propArray[j];
        log("" + i + ", ManagedPropertyBean.Name: " + pb.getPropertyName() +
            ", Class: " + pb.getPropertyClass() +
            ", Value: " + pb.getValue());
      }
      MapEntriesBean mapEnt =  mb.getMapEntries();
      if (mapEnt != null) printMapEntries( mapEnt);
      
      ListEntriesBean listEnt = mb.getListEntries();
      if (listEnt != null) log.fine("" + i + ", listEnt = " + listEnt);
    }
    log("_______________________");
  }

  private void printMapEntries(MapEntriesBean mapEnt) {
    MapEntryBean[] beans = mapEnt.getMapEntries();
    for (int i = 0; i < beans.length; i++) {

      log("?, " + i + ", " + beans[i].getKey() + " = " + beans[i].getValue());
    }

  
  }
  
  private Stack stack = new Stack();

  FacesConfigBean       configBean  = new FacesConfigBean();
  ManagedBeanBean       mBean       = null;
  ManagedPropertyBean   propBean    = null;
  MapEntriesBean        mapEntries  = null;
  MapEntryBean          mapEntry    = null;
  ListEntriesBean       listEntries = null;
  
  public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {

    if ("managed-bean".equals(qName)) {
      mBean = new ManagedBeanBean();
      //log("startElement    new ManagedBeanBean = " + mBean );
    } else if ("managed-property".equals(qName)) {
      propBean = new ManagedPropertyBean();
      //log("startElement    new ManagedPropertyBean = " + propBean );
    } else if ("managed-property".equals(qName)) {
      propBean = new ManagedPropertyBean();
      //log("startElement    new ManagedPropertyBean = " + propBean );


    } else if ("map-entries".equals(qName)) {
      mapEntries = new MapEntriesBean();
      log("startElement    new MapEntriesBean = " + mapEntries );
    } else if ("map-entry".equals(qName)) {
      mapEntry = new MapEntryBean();
      log("startElement    new MapEntryBean = " + mapEntry );
    } else if ("list-entries".equals(qName)) {
      listEntries = new ListEntriesBean();  

      log("startElement    new ListEntriesBean = " + listEntries );
    }
    stack.push(qName);
  }

  public void endElement(String uri, String localName, String qName) throws SAXException {

    log("endElement = " + qName +","+ localName);
    String pop = (String)   stack.pop();

    if (! qName.equals(pop)) log.warning("error");
    if ("managed-bean".equals(qName)) {
      configBean.addManagedBean(mBean);
    } else if ("managed-property".equals(qName)) {
      mBean.addManagedProperty(propBean);

    } else if ("map-entries".equals(qName)) {
      mBean.setMapEntries( mapEntries );
    } else if ("map-entry".equals(qName)) {
      mapEntries.addMapEntry( mapEntry );
    } else if ("list-entries".equals(qName)) {
      mBean.setListEntries(listEntries );  
    }
  }

  public void endDocument() throws SAXException {

    log("stack.size = " + stack.size() );
  }

  public void characters(char[] ch, int start, int length) throws SAXException {
    super.characters(ch, start, length);

    String qName = (String) stack.peek();
    Object[] stackArray = stack.toArray();
    //  log.info("characters = " + stack.size() );
    log.finer("stack = " + stackToString(stackArray));

    String text = new String(ch, start, length);
    
    if ("managed-bean-name".equals(qName)) {
      mBean.setManagedBeanName(text);
    } else if ("managed-bean-class".equals(qName)) {
      mBean.setManagedBeanClass(text);
    } else if ("managed-bean-scope".equals(qName)) {
      mBean.setManagedBeanScope(text);
    } else if ("property-name".equals(qName)) {
      propBean.setPropertyName(text);
    } else if ("property-class".equals(qName)) {
      propBean.setPropertyClass(text);

    } else if ("key-class".equals(qName)) {
      this.mapEntries.setKeyClass(text);

    } else if ("value-class".equals(qName)) { //--- value-class ͏̃^OĂǂɃZbg邩f

      int n = stackArray.length;
      String pop2 = (String) stackArray[n -2];
      if ("map-entries".equals(pop2)) {      
        this.mapEntries.setValueClass(text);
      } else if ("list-entries".equals(pop2)) {
        this.listEntries.setValueClass(text);
      } else {
        log.warning("?????" + pop2);
      }
    } else if ("key".equals(qName)) {
      this.mapEntry.setKey(text);
    } else if ("value".equals(qName)) { //------- value͏̃^OĂǂɃZbg邩f

      int n = stackArray.length;
      String pop2 = (String) stackArray[n -2];
      if ("managed-property".equals(pop2)) {
        propBean.setValue(text);
      } else if ("map-entry".equals(pop2)) {
        this.mapEntry.setValue(text);

      } else if ("list-entries".equals(pop2)) {
        this.listEntries.setValueClass(text);
      
      } else {
        log.warning("?????" + pop2);
      }
    }
  }

  public String stackToString(Object[] arr) {
    StringBuffer sb = new StringBuffer();
    String sep = "";
    for (int i = 0; i < arr.length; i++) {
      sb.append(sep + arr[i]  );
      sep = ", ";
    }
    return sb.toString();
  }
  
}
