//   -*- Mode: java4; -*-
/*
 * "Portions Copyrighted [year] [name of copyright owner]"
 */

package strawberry.application;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.IOException;

import java.util.Locale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.MissingResourceException;
import javax.faces.FacesException;

import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.FacesException;
import java.text.MessageFormat;
import java.io.IOException;


import java.util.logging.*;
/**
 * 
 * <p>supported filters: <code>package</code> and
 * <code>protection</code>.</p>
 */

public class I18n {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.application");

    private I18n() {
    }

    
    public static String substituteParams(Locale locale, String msgtext, Object params[]) {
        String localizedStr = null;
        
        if (params == null || msgtext == null ) {
            return msgtext;
        }    
        StringBuffer b = new StringBuffer(100);
        MessageFormat mf = new MessageFormat(msgtext);
        if (locale != null) {
            mf.setLocale(locale);
            b.append(mf.format(params));
            localizedStr = b.toString();
        }    
        return localizedStr;
    }

    /**
    * This version of getMessage() is used in the RI for localizing RI
    * specific messages.
    */

    public static String getLogMessage(String messageId, Object params[]) {

        Locale locale = Locale.getDefault();
	return getLogMessage(locale, messageId, params);
    }

    public static String getLogMessage(Locale locale, String messageId, 
					   Object params[]) {

	String    summary = null;
//	String    detail = null;
	String    bundleName = "strawberry.LogMessages"; /////////// \[Xoh
	ResourceBundle bundle = null;

        if (log.isLoggable(Level.FINE)) log.fine("(145)locale = " + locale);

	// see if we have a user-provided bundle
	if (null != bundleName) {
	    if (null != 
		(bundle = 
		 ResourceBundle.getBundle(bundleName, locale,
					  getCurrentLoader(bundleName)))) {
		// see if we have a hit
		try {
		    summary = bundle.getString(messageId);
		} catch (MissingResourceException e) {
		}
	    }
	}
	
	return substituteParams(locale, summary, params);
    }


    //
    // Methods from MessageFactory
    // 
    public static String getLogMessage( String messageId) {
        return getLogMessage( messageId, null);
    }    
    /*
    }  */
    
    public static String getLogMessage( String messageId,
                                       Object param0) {
        return getLogMessage( messageId, new Object[]{param0});
    }                                       
    
    public static String getLogMessage( String messageId,
                                       Object param0, Object param1) {
         return getLogMessage( messageId, new Object[]{param0, param1});
    }                                       
/*
    public static String getMessage( String messageId,
                                       Object param0, Object param1,
                                       Object param2) {
         return getMessage(context, messageId, 
             new Object[]{param0, param1, param2});                                        
    }                                       

    public static String getMessage( String messageId,
                                       Object param0, Object param1,
                                       Object param2, Object param3) {
         return getMessage(context, messageId, 
                 new Object[]{param0, param1, param2, param3});                                        
    }                                       
*/
    /*
    protected static Application getApplication() {
	FacesContext context = FacesContext.getCurrentInstance();
	if (context != null) {
	    return (FacesContext.getCurrentInstance().getApplication());
	}
	//ApplicationFactory afactory = (ApplicationFactory)
	//    FactoryFinder.getFactory(FactoryFinder.APPLICATION_FACTORY);
	//return (afactory.getApplication());
      return null;
    }
*/
    protected static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader =
	    Thread.currentThread().getContextClassLoader();
	if (loader == null) {
	    loader = fallbackClass.getClass().getClassLoader();
	}
	return loader;
    }


} // end of class MessageFactory
