/* -*- Mode: java4; -*-
 * $Id: ApplicationImpl.java,v 1.52.28.3.2.1 2006/04/12 19:32:03 ofung Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * 
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package strawberry.application;


import com.sun.faces.util.Util;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.*;
/**
 * <p><strong>Application</strong> represents a per-web-application
 * singleton object where applications based on JavaServer Faces (or
 * implementations wishing to provide extended functionality) can
 * register application-wide singletons that provide functionality
 * required by JavaServer Faces.
 */
public class ApplicationImpl extends Application {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.app.impl");

    // Relationship Instance Variables

    //private ApplicationAssociate associate = null;
  
    private ActionListener actionListener = null;
    private NavigationHandler navigationHandler = null;
    private PropertyResolver propertyResolver = null;
    private VariableResolver variableResolver = null;
    private ViewHandler viewHandler = null;
    private StateManager stateManager = null;
    //
    // This map stores reference expression | value binding instance
    // mappings.
    //
    private Map valueBindingMap;
    //
    // These three maps store store "identifier" | "class name"
    // mappings.
    //
    private Map componentMap = null;
    private Map converterIdMap = null;
    private Map converterTypeMap = null;
    private Map validatorMap = null;
    private String messageBundle = null;

//
// Constructors and Initializers
//

    /**
     * Constructor
     */
    public ApplicationImpl() {
        super();
//	associate = new ApplicationAssociate(); // gĂH
        valueBindingMap = new HashMap();
        componentMap = new HashMap();
        converterIdMap = new HashMap();
        converterTypeMap = new HashMap();
        validatorMap = new HashMap();
      
        log.fine("Created Application instance: viewHandler = " + viewHandler);
    }


    public ActionListener getActionListener() {
        return actionListener;
    }


    public ViewHandler getViewHandler() {
        return viewHandler;
    }


    public void setViewHandler(ViewHandler handler) {
        if (handler == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" ViewHandler " + handler;
            throw new NullPointerException(message);
        }
        synchronized (this) {
            /*
            if (associate.isResponseRendered()) {
                // at least one response has been rendered.
                
                    log.severe(
                        "Response for this request has been rendered already ");
                
                throw new IllegalStateException(Util.getExceptionMessageString(
                    Util.ILLEGAL_ATTEMPT_SETTING_VIEWHANDLER_ID));
            }*/
            viewHandler = handler;
            if (log.isLoggable(Level.FINE)) {
                log.fine("set ViewHandler Instance to " + viewHandler);
            }
        }
    }


    public StateManager getStateManager() {
        return stateManager;
    }


    public void setStateManager(StateManager manager) {
        if (manager == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message + " StateManager " + manager;
            throw new NullPointerException(message);
        }
        synchronized (this) {
            /*
            if (associate.isResponseRendered()) {
                // at least one response has been rendered.
                
                    log.severe(
                        "Response for this request has been rendered already ");
                
                throw new IllegalStateException(Util.getExceptionMessageString(
                    Util.ILLEGAL_ATTEMPT_SETTING_STATEMANAGER_ID));
            }*/
            stateManager = manager;
            if (log.isLoggable(Level.FINE)) {
                log.fine("set StateManager Instance to " + stateManager);
            }
        }
    }


    public void setActionListener(ActionListener listener) {
        if (listener == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" ActionListener " + listener;
            throw new NullPointerException(message);
        }
        synchronized (this) {
            this.actionListener = listener;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("set ActionListener Instance to " + actionListener);
        }
    }




    /**
     * Return the <code>NavigationHandler</code> instance
     * installed present in this application instance.  If
     * an instance does not exist, it will be created.
     */
    public NavigationHandler getNavigationHandler() {
        return navigationHandler;
    }


    /**
     * Set a <code>NavigationHandler</code> instance for this
     * application instance.
     *
     * @param handler The <code>NavigationHandler</code> instance.
     */
    public void setNavigationHandler(NavigationHandler handler) {
        if (handler == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" NavigationHandler " + handler;
            throw new NullPointerException(message);
        }
        synchronized (this) {
            this.navigationHandler = handler;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("set NavigationHandler Instance to " + navigationHandler);
        }
    }

    public PropertyResolver getPropertyResolver() {
      throw new UnsupportedOperationException();
    }

    public void setPropertyResolver(PropertyResolver resolver) {
      throw new UnsupportedOperationException();
    }

    public MethodBinding createMethodBinding(String ref, Class params[]) {
      throw new UnsupportedOperationException();
    }

    public ValueBinding createValueBinding(String ref) throws ReferenceSyntaxException {
      throw new UnsupportedOperationException();
    }

    // 2007.6.10
    public VariableResolver getVariableResolver() {
        return variableResolver;
    }

    public void setVariableResolver(VariableResolver resolver) {
        variableResolver = resolver;
    }


    public void addComponent(String componentType, String componentClass) {
        if (componentType == null || componentClass == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" componentType " + componentType +
                " componentClass " + componentClass;
            throw new NullPointerException(message);
        }
        synchronized (this) {
            componentMap.put(componentType, componentClass);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("273 added component of type " + componentType +
                      " class " + componentClass);
        }
    }


    public UIComponent createComponent(String componentType)
        throws FacesException {
        if (componentType == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" componentType " + componentType;
            throw new NullPointerException(message);
        }
        UIComponent returnVal = (UIComponent) newThing(componentType,
                                                       componentMap);
        if (returnVal == null) {
            
            log.fine("293) componentMap:" + componentMap);

            log.severe(
                    "Could not instantiate component of type " + componentType);
            
            Object[] params = {componentType};
            throw new FacesException(componentType + "݂܂");
              //  Util.NAMED_OBJECT_NOT_FOUND_ERROR_MESSAGE_ID, params));
        }
        
        log.finest("Created component " + componentType);
        
        return returnVal;
    }


    public UIComponent createComponent(ValueBinding componentBinding,
                                       FacesContext context,
                                       String componentType)
        throws FacesException {
        if (null == componentBinding || null == context ||
            null == componentType) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" componentBinding " + componentBinding +
                " context " + context + " componentType " + componentType;
            throw new NullPointerException(message);
        }

        Object result = null;
        boolean createOne = false;

        if (null != (result = componentBinding.getValue(context))) {
            // if the result is not an instance of UIComponent
            createOne = (!(result instanceof UIComponent));
            // we have to create one.
        }
        if (null == result || createOne) {
            result = this.createComponent(componentType);
            componentBinding.setValue(context, result);
        }

        return (UIComponent) result;
    }


    public Iterator getComponentTypes() {
        Iterator result = Collections.EMPTY_LIST.iterator();
        synchronized (this) {
            result = componentMap.keySet().iterator();
        }

        return result;
    }


    public void addConverter(String converterId, String converterClass) {
        if (converterId == null || converterClass == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message + " converterId " + converterId +
                " converterClass " + converterClass;
            throw new NullPointerException(message);
        }
        synchronized (this) {
            converterIdMap.put(converterId, converterClass);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("357 added converter of type " + converterId +
                      " and class " + converterClass);
        }
    }


    public void addConverter(Class targetClass, String converterClass) {
        if (targetClass == null || converterClass == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" targetClass " + targetClass +
                " converterClass " + converterClass;
            throw new NullPointerException(message);
        }
        synchronized (this) {
            converterTypeMap.put(targetClass, converterClass);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("375 added converter of class type " + converterClass);
        }
    }


    public Converter createConverter(String converterId) {
        if (converterId == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" converterId " + converterId;
            throw new NullPointerException(message);
        }
        Converter returnVal = (Converter) newThing(converterId, converterIdMap);
        if (returnVal == null) {
            
                log.severe("888 Couldn't instantiate converter of the type " +
                          converterId);
            
            Object[] params = {converterId};
            throw new FacesException(Util.getExceptionMessageString(
                Util.NAMED_OBJECT_NOT_FOUND_ERROR_MESSAGE_ID, params));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("created converter of type " + converterId);
        }
        return returnVal;
    }


    public Converter createConverter(Class targetClass) {
        if (targetClass == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" targetClass " + targetClass;
            throw new NullPointerException(message);
        }
        Converter returnVal = (Converter) newThing(targetClass,
                                                   converterTypeMap);

        if (returnVal != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Created converter of type " +
                          returnVal.getClass().getName());
            }
            return returnVal;
        }

        //Search for converters registered to interfaces implemented by
        //targetClass
        Class[] interfaces = targetClass.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; i++) {
                returnVal = createConverterBasedOnClass(interfaces[i]);
                if (returnVal != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Created converter of type " +
                                  returnVal.getClass().getName());
                    }
                    return returnVal;
                }
            }
        }

        //Search for converters registered to superclasses of targetClass
        Class superclass = targetClass.getSuperclass();
        if (superclass != null) {
            returnVal = createConverterBasedOnClass(superclass);
            if (returnVal != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Created converter of type " +
                              returnVal.getClass().getName());
                }
                return returnVal;
            }
        }

        return returnVal;
    }

    protected Converter createConverterBasedOnClass(Class targetClass) {
                                                                                                                         
        Converter returnVal = (Converter) newThing(targetClass,
                                                   converterTypeMap);
        if (returnVal != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Created converter of type " +
                        returnVal.getClass().getName());
            }
            return returnVal;
        }
                                                                                                                         
        //Search for converters registered to interfaces implemented by
        //targetClass
        Class[] interfaces = targetClass.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; i++) {
                returnVal = createConverterBasedOnClass(interfaces[i]);
                if (returnVal != null) {
                   if (log.isLoggable(Level.FINEST)) {
                       log.finest("Created converter of type " +
                                  returnVal.getClass().getName());
                    }
                    return returnVal;
                }
            }
        }

        //Search for converters registered to superclasses of targetClass
        Class superclass = targetClass.getSuperclass();
        if (superclass != null) {
            returnVal = createConverterBasedOnClass(superclass);
            if (returnVal != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Created converter of type " +
                              returnVal.getClass().getName());
                }
                return returnVal;
            }
        }
        return returnVal;
    }



    public Iterator getConverterIds() {
        Iterator result = Collections.EMPTY_LIST.iterator();
        synchronized (this) {
            result = converterIdMap.keySet().iterator();
        }

        return result;
    }


    public Iterator getConverterTypes() {
        Iterator result = Collections.EMPTY_LIST.iterator();
        synchronized (this) {
            result = converterTypeMap.keySet().iterator();
        }
        return result;
    }


    ArrayList supportedLocales = null;


    public Iterator getSupportedLocales() {
        Iterator result = Collections.EMPTY_LIST.iterator();

        synchronized (this) {
            if (null != supportedLocales) {
                result = supportedLocales.iterator();
            }
        }
        return result;
    }


    public void setSupportedLocales(Collection newLocales) {
        if (null == newLocales) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" newLocales " + newLocales;
            throw new NullPointerException(message);
        }
        synchronized (this) {
            supportedLocales = new ArrayList(newLocales);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set Supported Locales");
        }
    }


    protected Locale defaultLocale = null;


    public Locale getDefaultLocale() {
        return defaultLocale;
    }


    public void setDefaultLocale(Locale locale) {

        if (locale == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message + " locale " + locale;
            throw new NullPointerException(message);
        }

        synchronized (this) {
            defaultLocale = locale;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set defaultLocale " + defaultLocale);
        }

    }


    protected String defaultRenderKitId = null;


    public String getDefaultRenderKitId() {
        return defaultRenderKitId;
    }


    public void setDefaultRenderKitId(String renderKitId) {
        defaultRenderKitId = renderKitId;
    }


    public void addValidator(String validatorId, String validatorClass) {
        if (validatorId == null || validatorClass == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message + " validatorId " + validatorId + 
                " validatorClass " + validatorClass;
            throw new NullPointerException(message);
        }
        synchronized (this) {
            validatorMap.put(validatorId, validatorClass);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("601 added validator of type " + validatorId +
                      " class " + validatorClass);
        }
    }


    public Validator createValidator(String validatorId) throws FacesException {
        if (validatorId == null) {
            String message = Util.getExceptionMessageString
                (Util.NULL_PARAMETERS_ERROR_MESSAGE_ID);
            message = message +" validatorId " + validatorId;
            throw new NullPointerException(message);
        }
        Validator returnVal = (Validator) newThing(validatorId, validatorMap);
        if (returnVal == null) {
            
                log.severe("Couldn't instantiate Validator of the type " +
                          validatorId);
            
            Object[] params = {validatorId};
            throw new FacesException(Util.getExceptionMessageString(
                Util.NAMED_OBJECT_NOT_FOUND_ERROR_MESSAGE_ID, params));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("created validator of type " + validatorId);
        }
        return returnVal;
    }


    public Iterator getValidatorIds() {
        Iterator result = Collections.EMPTY_LIST.iterator();
        synchronized (this) {
            result = validatorMap.keySet().iterator();
        }
        return result;
    }


    public void setMessageBundle(String messageBundle) {
        synchronized (this) {
            this.messageBundle = messageBundle;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set messageBundle " + messageBundle);
        }
    }


    synchronized public String getMessageBundle() {
        return messageBundle;
    }


    Object fallbackClass = null;

    public void setFallbackClass(Object obj) {
        fallbackClass = obj;
    }

    
    /**
     * <p>PRECONDITIONS: the values in the Map are either Strings
     * representing fully qualified java class names, or java.lang.Class
     * instances.</p>
     * <p>ALGORITHM: Look in the argument map for a value for the argument
     * key.  If found, if the value is instanceof String, assume the String
     * specifies a fully qualified java class name and obtain the
     * java.lang.Class instance for that String using Util.loadClass().
     * Replace the String instance in the argument map with the Class
     * instance.  If the value is instanceof Class, proceed.  Assert that the
     * value is either instanceof java.lang.Class or java.lang.String.</p>
     * <p>Now that you have a java.lang.class, call its newInstance and
     * return it as the result of this method.</p>
     *
     * @param key Used to look up the value in the <code>Map</code>.
     * @param map The <code>Map</code> that will be searched.
     * @return The new object instance.
     */
    protected Object newThing(Object key, Map map) {
        Util.doAssert(key != null);
        Util.doAssert(map != null);
        Util.doAssert(key instanceof String || key instanceof Class);

        Object result = null;
        Class clazz = null;
        Object value = null;

        synchronized (this) {
            value = map.get(key);

            if (value == null) {
                log.finer("return null !,  key = " + key);
                return null;
            }
            Util.doAssert(value instanceof String || value instanceof Class);
            if (value instanceof String) {
                try {
                    log.finer("fallbackClass = " + fallbackClass);
//                    Object fbClass = (fallbackClass != null) ? fallbackClass : value;
                    Object fbClass = fallbackClass;
                    clazz = Util.loadClass((String) value, fbClass);
                    Util.doAssert(clazz != null);
                    map.put(key, clazz);
                } catch (Throwable t) {
                    log.severe("999 catch Throwable " + value);
                    Object[] params = {t.getMessage()};
                    throw new FacesException(Util.getExceptionMessageString(
                        Util.CANT_LOAD_CLASS_ERROR_MESSAGE_ID, params));
                }
            } else {
                clazz = (Class) value;
            }
        }

        try {
            result = clazz.newInstance();
        } catch (Throwable t) {
            Object[] params = {clazz.getName()};
            throw new FacesException(Util.getExceptionMessageString(
                Util.CANT_INSTANTIATE_CLASS_ERROR_MESSAGE_ID, params));
        }
        return result;
    }

    // The testcase for this class is
    // com.sun.faces.application.TestApplicationImpl.java

    // The testcase for this class is
    // com.sun.faces.application.TestApplicationImpl_Config.java
}
