/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry;

import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import strawberry.init.FacesContextInitializer;
import strawberry.init.FacesContextInitializer1;

import strawberry.plugin.ScriptEngine;
import java.util.Map;
import java.util.logging.*;
import javax.faces.application.Application;
import javax.faces.el.VariableResolver;
import javax.servlet.ServletContext;
import strawberry.init.SimpleEC;
/**
 * Created on 2007/01/14,
 */
public class FaceletsBridgeVer8 implements FaceletsBridge {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.application");

  FacesContextInitializer facesSupport = new FacesContextInitializer1();

  private LifecycleFactory lifecycleFactory = null;
    /**
     * <p>Context initialization parameter name for the lifecycle identifier
     * of the {@link Lifecycle} instance to be utilized.</p>
     */
  public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";

  /** eXgR[h (FaceletsBridgeUtil) p */
  public Application getApplication() {
    return facesSupport.getApplication();
  }
  
  /**
   *  Application  RenderKitFactory 
   */
  public void initialize(ServletContext sc, ResourceConfig rc) throws FacesException {

    log.info("DEFAULT_SUFFIX = " + sc.getInitParameter("javax.faces.DEFAULT_SUFFIX"));
    
    SimpleEC ec = new SimpleEC(sc);
    facesSupport.processXmls(ec, rc);


    if (lifecycleFactory == null) {

      
      lifecycleFactory = facesSupport.createLifecycleFactory();
    }
  }
  
/*  @see FacesServlet

  public void init(ServletConfig servletConfig) {
            String lifecycleId =  servletConfig.getServletContext().getInitParameter
                (LIFECYCLE_ID_ATTR);
            if (lifecycleId == null) {
                lifecycleId = LifecycleFactory.DEFAULT_LIFECYCLE;
            }
            lifecycle = lifecycleFactory.getLifecycle(lifecycleId);

  */

  /** eXgR[h  p */
  public FacesContext createFacesContext(ExternalContext ec, ResourceConfig rc) throws FacesException {

    return facesSupport.createFacesContext(ec, rc);
  }


  /** CtTCNs */
  public void doLifecycle(ExternalContext ec, ResourceConfig rc) throws FacesException {


    createScriptEngine(ec);

    FacesContext context = facesSupport.createFacesContext(ec, rc);

    String lifecycleId =  ec.getInitParameter(LIFECYCLE_ID_ATTR);
    log.info("87) lifecycleId = " + lifecycleId);
    
    if (lifecycleId == null) {
      lifecycleId = LifecycleFactory.DEFAULT_LIFECYCLE;
    }
    Lifecycle currentLifecycle = lifecycleFactory.getLifecycle(lifecycleId);

    // LbVĂāA񓯂CX^XԂB

    if (log.isLoggable(Level.FINE)) {
      Application app = context.getApplication();
      VariableResolver vr = app.getVariableResolver();
      log.fine("vr = " + vr);
    }
    
    try {
      currentLifecycle.execute(context);
      currentLifecycle.render(context);
    } finally {
      releaseScriptEngine(ec);
      // Release the FacesContext instance for this request
      context.release();
    }
  }



  public void createScriptEngine(ExternalContext ec) {
    Map initParamMap = ec.getInitParameterMap();
    try {
      Object engine = null;
      if (isEnabled(initParamMap, "enable.JavaScript")) {
        engine = Class.forName("strawberry.script.FesiEngineImpl").newInstance();
      } else {
        engine = Class.forName("strawberry.plugin.DummyEngine").newInstance();
      }
      ec.getApplicationMap().put(FaceletsConstants.ENGINE_KEY, engine);
    } catch (Exception ex) {
      log.log(Level.WARNING, "262) catch Exception", ex);
    }
  }

  public boolean isEnabled(Map map, String key) {

    if (map == null) {
      return true;
    }
    Object wk = map.get(key);
    
    if (wk instanceof Boolean) {
      Boolean b = (Boolean) wk;
      log.fine("JavaScriptGW = " + b);

      return b.booleanValue();
    } else {
      return true;
    }
  }

  public void releaseScriptEngine(ExternalContext ec) {
    Object engine = ec.getApplicationMap().get(FaceletsConstants.ENGINE_KEY);
    if (engine != null && engine instanceof ScriptEngine) {
      ScriptEngine wk = (ScriptEngine) engine;
      wk.release();
    }
  }
}
