package jsfutil.convert;
/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * 
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
import java.math.BigDecimal;
import javax.faces.application.FacesMessage;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import java.util.logging.*;
/**
 *   getAsString ̌BigDecimalł
 * 
 */
public class IntegerConverterAllowsBigDecimal implements Converter {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.IntegerConverterAllowsBigDecimal");

  // ------------------------------------------------------ Manifest Constants


  /**
   * <p>The standard converter id for this converter.</p>
   */
  public static final String CONVERTER_ID = "jsfutil.IntegerAllowsBigDecimal";


  // ------------------------------------------------------- Converter Methods


  /**
   * @exception ConverterException {@inheritDoc}
   * @exception NullPointerException {@inheritDoc}
   */
  public Object getAsObject(FacesContext context, UIComponent component,
                            String value) {

    if (context == null || component == null) {
      throw new NullPointerException();
    }

    // If the specified value is null or zero-length, return null
    if (value == null) {
      return null;
    }
    value = value.trim();
    if (value.length() < 1) {
      return null;
    }

    try {
      return (Integer.valueOf(value));
    } catch (Exception e) {
      throw new ConverterException(new FacesMessage(""),
                                   e);
    }


  }

  /**
   * @exception ConverterException {@inheritDoc}
   * @exception NullPointerException {@inheritDoc}
   */
  public String getAsString(FacesContext context, UIComponent component,
                            Object value) {

    if (context == null || component == null) {
      throw new NullPointerException();
    }

    // If the specified value is null, return a zero-length String
    if (value == null) {
      return "";
    }

    // If the incoming value is still a string, play nice
    // and return the value unmodified
    if (value instanceof String) {
      return (String) value;
    }

    String ans = "";
    try {

      if (value instanceof Integer) {
        ans = (Integer.toString(((Integer) value).intValue()));
      } else if (value instanceof BigDecimal) {
        BigDecimal bd = (BigDecimal) value;
        int iVal = bd.intValue();
        ans = Integer.toString(iVal);
      } else {
        log.warning("value = " + value + " ------------------ ");
      }
    } catch (Exception e) {
      throw new ConverterException(e);
    }
    return ans;
  }
}
