/*  -*- Mode: java4; -*-
 * $Id: ActionListenerImpl.java,v 1.10.36.1 2006/04/12 19:32:02 ofung Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * 
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.faces.application;

import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import java.util.logging.*;

/**
 * This action listener implementation processes action events during the
 * <em>Apply Request Values</em> or <em>Invoke Application</em>
 * phase of the request processing lifecycle (depending upon the
 * <code>immediate</code> property of the {@link ActionSource} that
 * queued this event.  It invokes the specified application action method,
 * and uses the logical outcome value to invoke the default navigation handler
 * mechanism to determine which view should be displayed next.</p>
 */
public class ActionListenerImpl implements ActionListener {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.nav");
//    protected final static Logger log = Logger.getLogger("strawberry.evt");

    //
    // Constructors and Initializers
    //
    public ActionListenerImpl() {
    }

    //
    // Class Methods
    //

    //
    // General Methods
    //

    public void processAction(ActionEvent event) {

        if (log.isLoggable(Level.FINE)) {
            log.fine("ActionListenerImpl#processAction(" + event.getComponent().getId() + ")    -------- ");
        }
        
        UIComponent source = event.getComponent();
        ActionSource actionSource = (ActionSource) source;
        FacesContext context = FacesContext.getCurrentInstance();

        Application application = context.getApplication();

        String outcome = null;
        MethodBinding binding = null;

	binding = actionSource.getAction();
	if (binding != null) {
	    try {
		outcome = (String) binding.invoke(context, null);
	    } catch (MethodNotFoundException e) {
		throw new FacesException
                    (binding.getExpressionString() + ": " + e, e);
	    }
	    catch (EvaluationException e) {
		throw new FacesException
                    (binding.getExpressionString() + ": " + e, e);
	    }
	}
      
        if (log.isLoggable(Level.FINE)) {
            log.fine("processAction(" + event.getComponent().getId() + ")    -------- invoke");
            log.fine("(105) outcome = " + outcome);
        }

        NavigationHandler navHandler = application.getNavigationHandler();

        /* Invoke nav handling..
        String expStr = null;
        if (null != binding) {
          expStr = binding.getExpressionString();
          log.info ("ActionListenerImpl   (112) expStr = '" + expStr  + "' ---------- Jڐ viewID ");
        }*/

        String expStr = context.getViewRoot().getViewId();
      
        if (log.isLoggable(Level.INFO)) {
            String  className = navHandler.getClass().getName();

            String type = "JX^}CY";
            if (className.endsWith("NavigationHandlerImpl")) {
                type = "ʏ";
            }
            log.info("(120) navHandler  = " + className + "   < " + type  + " >");
        }
        
        if (log.isLoggable(Level.FINE)) {
            log.fine ("(121) expStr  = '" + expStr + "'" );
        }
        
        navHandler.handleNavigation(context, expStr,
                                    outcome);

        // Trigger a switch to Render Response if needed
        log.fine ("124) context.renderResponse()Ăт܂ "  );
        context.renderResponse();
    }
}
