/*  -*- Mode: java4; -*-
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *     Copyright 2007 MASAHITO HENMI
 */
package org.apache.el.lang;

import javax.el.ValueExpression;
import javax.el.VariableMapper;
import java.util.logging.*;

public class VariableMapperFactory extends VariableMapper {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.el.variable");

    private final VariableMapper target;
    private VariableMapper momento;

    public VariableMapperFactory(VariableMapper target) {
        if (target == null) {
            throw new NullPointerException("Target VariableMapper cannot be null");
        }
        this.target = target;
        log.fine("񂷂Ƃ炭 outer VariableMapper" + target);
    }

    public VariableMapper create() {
        log.fine("create  -> " + momento);
        return this.momento;
    }

    public ValueExpression resolveVariable(String variable) {
        log.fine("(46) " + target);
        ValueExpression expr = this.target.resolveVariable(variable);
        if (expr != null) {
            if (this.momento == null) {
                log.fine("炵VariableMapperImpl쐬");
                this.momento = new VariableMapperImpl();
            } else {
                log.fine("炵VariableMapperImpl쐬ȂI");
            }
            this.momento.setVariable(variable, expr);
        }
        log.fine("(57)        => " + expr);
        return expr;
    }

    public ValueExpression setVariable(String variable, ValueExpression expression) {
        throw new UnsupportedOperationException("Cannot Set Variables on Factory");
    }
}
