/*  -*- Mode: java4; -*-
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * 
 *     Copyright 2007 MASAHITO HENMI
 */

package org.apache.el.lang;

import java.io.StringReader;
import java.lang.reflect.Method;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.el.VariableMapper;

import org.apache.el.MethodExpressionImpl;
import org.apache.el.MethodExpressionLiteral;
import org.apache.el.ValueExpressionImpl;
import org.apache.el.parser.AstCompositeExpression;
import org.apache.el.parser.AstDeferredExpression;
import org.apache.el.parser.AstDynamicExpression;
import org.apache.el.parser.AstFunction;
import org.apache.el.parser.AstIdentifier;
import org.apache.el.parser.AstLiteralExpression;
import org.apache.el.parser.AstValue;
import org.apache.el.parser.ELParser;
import org.apache.el.parser.Node;
import org.apache.el.parser.NodeVisitor;
import org.apache.el.parser.ParseException;
import org.apache.el.util.ConcurrentCache;
import org.apache.el.util.MessageFactory;
import java.util.logging.*;
/**
 * @author Jacob Hookom [jacob@hookom.net]
 * @version $Change: 181177 $$DateTime: 2001/06/26 08:45:09 $$Author: markt $
 */
public final class ExpressionBuilder implements NodeVisitor {

    // jdk1.4 logging
    protected final static Logger funLog = Logger.getLogger("strawberry.el.function");

    private static final ConcurrentCache cache = new ConcurrentCache(5000);

    private FunctionMapper fnMapper;

    private VariableMapper varMapper;

    private String expression;

    /**
     *        at org.apache.el.lang.FunctionMapperFactory.<init>(FunctionMapperFactory.java:44)
        at org.apache.el.lang.ExpressionBuilder.<init>(ExpressionBuilder.java:82)
        at org.apache.el.ExpressionFactoryImpl.createValueExpression(ExpressionFactoryImpl.java:67)
        at com.sun.facelets.el.ELText$ELTextVariable.apply(ELText.java:161)
        at com.sun.facelets.el.ELText$ELTextComposite.apply(ELText.java:142)
        at com.sun.facelets.compiler.TextInstruction.apply(TextInstruction.java:56)
        at com.sun.facelets.compiler.UIInstructionHandler.apply(UIInstructionHandler.java:84)
        at com.sun.facelets.compiler.NamespaceHandler.apply(NamespaceHandler.java:67)

     */
    public ExpressionBuilder(String expression, ELContext ctx)
        throws ELException {
        this.expression = expression;

        funLog.fine("RXgN^" + Integer.toHexString(ctx.hashCode()));

        FunctionMapper ctxFn = ctx.getFunctionMapper();
        VariableMapper ctxVar = ctx.getVariableMapper();

        funLog.fine("(87) " + ctxVar);
        if (ctxFn != null) {
            // EEE֐̑gݍ
            this.fnMapper = new FunctionMapperFactory(ctxFn);
            //  .createValueExpression(Class expectedType)Ă΂
        }
        if (ctxVar != null) {
            this.varMapper = new VariableMapperFactory(ctxVar);
        }
    }

    public final static Node createNode(String expr) throws ELException {
        funLog.fine("99) createNode");
        Node n = createNodeInternal(expr);
        return n;
    }

    private final static Node createNodeInternal(String expr)
        throws ELException {
        
        funLog.fine("107) createNodeInternal");
        if (expr == null) {
            throw new ELException(MessageFactory.get("error.null"));
        }

        Node n = (Node) cache.get(expr);
        if (n == null) {
            try {
                n = (new ELParser(new StringReader(expr)))
                    .CompositeExpression();

                // validate composite expression
                if (n instanceof AstCompositeExpression) {
                    int numChildren = n.jjtGetNumChildren();
                    if (numChildren == 1) {
                        n = n.jjtGetChild(0);
                    } else {
                        Class type = null;
                        Node child = null;
                        for (int i = 0; i < numChildren; i++) {
                            child = n.jjtGetChild(i);
                            if (child instanceof AstLiteralExpression)
                                continue;
                            if (type == null)
                                type = child.getClass();
                            else {
                                if (!type.equals(child.getClass())) {
                                    throw new ELException(MessageFactory.get(
                                        "error.mixed", expr));
                                }
                            }
                        }
                    }
                }
                if (n instanceof AstDeferredExpression
                    || n instanceof AstDynamicExpression) {
                    n = n.jjtGetChild(0);
                }
                cache.put(expr, n);
            } catch (ParseException pe) {
                throw new ELException("Error Parsing: " + expr, pe);
            }
        }
        return n;
    }

    private void prepare(Node node) throws ELException {
        try {
            if (node == null) {
                funLog.fine("(156) node = " + node );
            } else {
                funLog.fine("(158) prepare, node = " + node.getClass().getName() );
            }
            node.accept(this);
        } catch (Exception e) {
            funLog.fine("************************");
            e.printStackTrace(); // add
            funLog.fine("************************");
            // throw (ELException) e;
            throw new ELException(e);
        }
        if (this.fnMapper instanceof FunctionMapperFactory) {
            this.fnMapper = ((FunctionMapperFactory) this.fnMapper).create();
        }
        if (this.varMapper instanceof VariableMapperFactory) {
            this.varMapper = ((VariableMapperFactory) this.varMapper).create();
        }
    }

    private Node build() throws ELException {
        Node n = createNodeInternal(this.expression);
        this.prepare(n);
        if (n instanceof AstDeferredExpression
            || n instanceof AstDynamicExpression) {
            n = n.jjtGetChild(0);
        }
        return n;
    }

    /*
     * (non-Javadoc)
     *
     * @see com.sun.el.parser.NodeVisitor#visit(com.sun.el.parser.Node)
     */
    public void visit(Node node) throws ELException {
        if (node instanceof AstFunction) {

            AstFunction funcNode = (AstFunction) node;

            if (this.fnMapper == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.null"));
            }
            funLog.fine("199) resolveFunction Ăт܂"); //--------------------------------
            Method m = fnMapper.resolveFunction(funcNode.getPrefix(), funcNode
                                                .getLocalName());
            if (m == null) {
                throw new ELException(MessageFactory.get(
                    "error.fnMapper.method", funcNode.getOutputName()));
            }
            int pcnt = m.getParameterTypes().length;
            if (node.jjtGetNumChildren() != pcnt) {
                throw new ELException(MessageFactory.get(
                    "error.fnMapper.paramcount", funcNode.getOutputName(),
                    "" + pcnt, "" + node.jjtGetNumChildren()));
            }
        } else if (node instanceof AstIdentifier && this.varMapper != null) {
            String variable = ((AstIdentifier) node).getImage();
            funLog.fine("(197) '" + variable + "'");
            funLog.fine("(198) varMapper = " + varMapper);
            // simply capture it
            this.varMapper.resolveVariable(variable);
        }
    }

    public ValueExpression createValueExpression(Class expectedType)
        throws ELException {
        
        Node n = this.build();

       // funLog.fine("226) apache.el.ValueExpressionImplnew܂<C>");
        
        return new ValueExpressionImpl(this.expression, n, this.fnMapper,
                                       this.varMapper, expectedType);
    }

    public MethodExpression createMethodExpression(Class expectedReturnType,
                                                   Class[] expectedParamTypes) throws ELException {
        Node n = this.build();
        if (n instanceof AstValue || n instanceof AstIdentifier) {
            return new MethodExpressionImpl(expression, n, this.fnMapper,
                                            this.varMapper, expectedReturnType, expectedParamTypes);
        } else if (n instanceof AstLiteralExpression) {
            return new MethodExpressionLiteral(expression, expectedReturnType,
                                               expectedParamTypes);
        } else {
            throw new ELException("Not a Valid Method Expression: "
                                  + expression);
        }
    }
}
