/* -*- Mode: java4; -*-
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 */

package org.apache.el;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

import org.apache.el.lang.ELSupport;
import org.apache.el.lang.ExpressionBuilder;
import org.apache.el.util.MessageFactory;
import java.util.logging.*;
/**
 * @see javax.el.ExpressionFactory
 * 
 * @author Jacob Hookom [jacob@hookom.net]
 * @version $Change: 181177 $$DateTime: 2001/06/26 08:45:09 $$Author: markt $
 */
public class ExpressionFactoryImpl extends ExpressionFactory {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.el.funmap");
    
    /**
     * 
     */
    public ExpressionFactoryImpl() {
        super();
    }

    public Object coerceToType(Object obj, Class type) {
        return ELSupport.coerceToType(obj, type);
    }

    public MethodExpression createMethodExpression(ELContext context,
            String expression, Class expectedReturnType,
            Class[] expectedParamTypes) {
        if (expectedParamTypes == null) {
            throw new NullPointerException(MessageFactory
                    .get("error.method.nullParms"));
        }
        ExpressionBuilder builder = new ExpressionBuilder(expression, context);
        return builder.createMethodExpression(expectedReturnType,
                expectedParamTypes);
    }

    /*
        at org.apache.el.ExpressionFactoryImpl.createValueExpression(ExpressionFactoryImpl.java:67)
        at com.sun.facelets.el.ELText$ELTextVariable.apply(ELText.java:161)
        at com.sun.facelets.el.ELText$ELTextComposite.apply(ELText.java:142)
        at com.sun.facelets.compiler.TextInstruction.apply(TextInstruction.java:56)
        at com.sun.facelets.compiler.UIInstructionHandler.apply(UIInstructionHandler.java:84)
        at com.sun.facelets.compiler.NamespaceHandler.apply(NamespaceHandler.java:67)
*/      
    public ValueExpression createValueExpression(ELContext context,
            String expression, Class expectedType) {
        if (expectedType == null) {
            throw new NullPointerException(MessageFactory
                    .get("error.value.expectedType"));
        }
        if (log.isLoggable(Level.FINE)) {
        //  log.fine("context = " + context); //com.sun.facelets.impl.DefaultFaceletContext
            log.fine("79) createValueExpression, expression = " + expression);
            log.fine("80) createValueExpression, expectedType = " + expectedType);
        }
        //                                                             
        ExpressionBuilder builder = new ExpressionBuilder(expression, context);
        ValueExpression ve = builder.createValueExpression(expectedType);
        if (log.isLoggable(Level.FINE)) {
            String msg = ve.getClass().getName() + "@";
            msg += Integer.toHexString(ve.hashCode());
            log.fine("86) createValueExpression ===> " + msg + " ------");
        }
        return ve;
    }

    public ValueExpression createValueExpression(Object instance,
            Class expectedType) {
        
        log.fine("93) createValueExpression");
        if (expectedType == null) {
            throw new NullPointerException(MessageFactory
                    .get("error.value.expectedType"));
        }
        return new ValueExpressionLiteral(instance, expectedType);
    }
}
