package com.sun.facelets.tools;

import java.lang.reflect.Method;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ClassLoadUtil {


  /*   ̃NX́Atomcat3̃NX[_̖
   *@@߂̃NXŁA
   *
   *   ExternalContext ̎NX loadClass \bh
   *   tNVŌĂяoɂāA
   *   NX[_̖Ă
   */
  public static Class loadClass(String className) {

    FacesContext faces = FacesContext.getCurrentInstance();
    Object target = "";
    if (faces != null) target = faces.getExternalContext();
    return loadClass(target, className);
  }

  
  public static Class loadClass(Object target, String className) {
    
    boolean flag = false;    
    Class[] args = new Class[]{ String.class };
    
    Method method = null;
    try {
      method = target.getClass().getMethod("loadClass",  args);
    } catch (NoSuchMethodException nse) {
      flag = true;
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
    
    Object clazz = null;
    if (flag) {
      try {   // eXgR[h
        clazz = Class.forName(className);
      } catch (Exception ex) {
        throw new RuntimeException(ex);
      }
    } else {
      try { // AvĂ΂鎞
        clazz = method.invoke(target, new Object[]{className});
      } catch (Exception ex) {
        throw new RuntimeException(ex);
      }
    }
    return (Class) clazz;
  }

}
