/**   -*- Mode: java4; -*-
 * Licensed under the Common Development and Distribution License,
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.sun.com/cddl/
 *   
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 */

package com.sun.facelets.tag.jsf.core;

import java.io.IOException;
import java.util.Iterator;

import javax.el.ELException;
import javax.faces.component.UIComponent;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TextHandler;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentHandler;

import java.util.logging.*;
/**
 * Handler for f:verbatim
 * 
 * @author Adam Winer
 * @version $Id: VerbatimHandler.java,v 1.2 2006/03/29 04:10:09 jhook Exp $
 */
public final class VerbatimHandler extends ComponentHandler {

    protected final static Logger log = Logger.getLogger("strawberry.fls.viewhandler");


    public VerbatimHandler(ComponentConfig config) {
        super(config);
    }

    protected void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        StringBuffer content = new StringBuffer();
        Iterator iter = findNextByType(TextHandler.class);
        while (iter.hasNext()) {
            TextHandler text = (TextHandler) iter.next();
            content.append(text.getText(ctx));
        }

        c.getAttributes().put("value", content.toString());
        c.getAttributes().put("escape", Boolean.FALSE);
        log.info("(54) " + c.getClass().getName() + ".setTransient(true)");
        c.setTransient(true);
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent c) {
    }
}
