/**    -*- Mode: java4; -*-
 * Licensed under the Common Development and Distribution License,
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.sun.com/cddl/
 *   
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 */

package com.sun.facelets.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletFactory;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.util.ParameterCheck;
import com.sun.facelets.util.Resource;

/**
 * Default FaceletFactory implementation.
 * 
 * @author Jacob Hookom
 * @version $Id: DefaultFaceletFactory.java,v 1.8 2006/05/03 04:30:13 jhook Exp $
 */
public final class DefaultFaceletFactory extends FaceletFactory {

    protected final static Logger log = Logger.getLogger("strawberry.fls.factory");

    private final Compiler compiler;

    private final Map facelets;

    private final Map relativeLocations;
    
    private final ResourceResolver resolver;
    
    private URL _baseUrl = null;

    public URL getBaseUrl() {

        if (_baseUrl == null) {
            _baseUrl = resolver.resolveUrl("/");
        }
        return _baseUrl;
    }

  
    private final long refreshPeriod;

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        ParameterCheck.notNull("compiler", compiler);
        ParameterCheck.notNull("resolver", resolver);
        this.compiler = compiler;
        this.facelets = new HashMap();
        this.relativeLocations = new HashMap();
        this.resolver = resolver;
//      this.baseUrl = resolver.resolveUrl("/");   // resolver ̎̒ŁAFacesContext.getCurrentInstance()
                                                   // ĂяoB̍ہAFacesContext炩ߍ쐬
                                                   // ȂƁAłB

        log.fine("Using ResourceResolver: " + resolver);
        this.refreshPeriod = (refreshPeriod > 0) ? refreshPeriod * 1000 : -1;
        log.fine("Using Refresh Period: " + this.refreshPeriod);
    }

    /* ̃\bh͈ȉĂяo
     *  at com.sun.facelets.FaceletViewHandler.buildView(FaceletViewHandler.java:494)
     * 
     * 
     * @see com.sun.facelets.FaceletFactory#getFacelet(java.lang.String)
     */
    public Facelet getFacelet(String uri) throws IOException, FaceletException, FacesException, ELException {

        log.info("96) " + uri);
        URL url = (URL) this.relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(getBaseUrl(), uri);
            if (url != null) {
                this.relativeLocations.put(uri, url);
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getFacelet(url);
    }

    /**
     * Resolves a path based on the passed URL. If the path starts with '/',
     * then resolve the path against
     * {@link javax.faces.context.ExternalContext#getResource(java.lang.String) javax.faces.context.ExternalContext#getResource(java.lang.String)}.
     * Otherwise create a new URL via
     * {@link URL#URL(java.net.URL, java.lang.String) URL(URL, String)}.
     * 
     * @param source
     *            base to resolve from
     * @param path
     *            relative path to the source
     * @return resolved URL
     * @throws IOException
     */
    public URL resolveURL(URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            log.info("125) " + source + ", path = " + path);
            URL url = this.resolver.resolveUrl(path);
            if (url == null) {
                log.info("128) " + resolver.getClass().getName());
                throw new FileNotFoundException("'" + path
                        + "' Not Found in ExternalContext as a Resource");
            }
            return url;
        } else {
            return new URL(source, path);
        }
    }

    /**
     * Create a Facelet from the passed URL. This method checks if the cached
     * Facelet needs to be refreshed before returning. If so, uses the passed
     * URL to build a new instance;
     * 
     * ̃\bh80sڕt߂̈łgetFaceletĂяo
     *
     * @throws FacesException
     * @throws ELException ----------???
     */
    public Facelet getFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {

        ParameterCheck.notNull("url", url);
        DefaultFacelet f = (DefaultFacelet) this.facelets.get(url);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = this.createFacelet(url); // 220sڂAASAXCompiler.doCompile()Ă΂
            this.facelets.put(url, f);
        }
        return f;
    }

    /**
     * Template method for determining if the Facelet needs to be refreshed.
     * 
     * @param facelet
     *            Facelet that could have expired
     * @return true if it needs to be refreshed
     */
    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this.refreshPeriod != -1) {
            long ttl = facelet.getCreateTime() + this.refreshPeriod;
            if (System.currentTimeMillis() > ttl) {
                try {
                    long atl = facelet.getSource().openConnection()
                            .getLastModified();
                    return atl > ttl;
                } catch (Exception e) {
                    throw new FaceletException(
                            "Error Checking Last Modified for "
                                    + facelet.getAlias(), e);
                }
            }
        }
        return false;
    }

    /**
     * Uses the internal Compiler reference to build a Facelet given the passed URL.
     * 
     *  ̃\bh͈ȉ̂悤ɌĂяo
     *  at com.sun.facelets.impl.DefaultFaceletFactory.createFacelet(DefaultFaceletFactory.java:195) *** 
     *  at com.sun.facelets.impl.DefaultFaceletFactory.getFacelet(DefaultFaceletFactory.java:141)
     *  at com.sun.facelets.impl.DefaultFaceletFactory.getFacelet(DefaultFaceletFactory.java:93)
     *  at com.sun.facelets.FaceletViewHandler.buildView(FaceletViewHandler.java:494)
     * 
     * 
     * @throws FacesException
     * @throws ELException  ------ H
     */
    private DefaultFacelet createFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
      
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + url);
            log.fine("url = " + url);
            log.fine("getFile() " + url.getFile());
            //log.fine("baseUrl " + baseUrl);
        }
      
        String alias = "/" + url.getFile().replaceFirst(getBaseUrl().getFile(), "");
        try {
            //                         ʃNX Compiler  compileĂԂ
            //                           ʃNX SAXCompiler  doCompileĂ΂
            FaceletHandler h = this.compiler.compile(url, alias); //  ----------  doCompile()Ăяo
            //             Ԃ h  EncodingHandlerł

            //log.fine("(200) h = " + h.getClass().getName());

          
            DefaultFacelet f = new DefaultFacelet(this,
                                                  this.compiler.createExpressionFactory(),
                                                  url,
                                                  alias,
                                                  h);
            return f;
        } catch (FileNotFoundException fnfe) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("224) " + alias + " not found at " + url.toExternalForm());
            }
            throw new FileNotFoundException("Facelet Not Found: " + url.toExternalForm());
        }
    }

    /**
     * Compiler this factory uses
     * 
     * @return final Compiler instance
     */
    public Compiler getCompiler() {
        return this.compiler;
    }

    public long getRefreshPeriod() {
        return refreshPeriod;
    }
}
