/**  -*- Mode: java4; -*-
 * Licensed under the Common Development and Distribution License,
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.sun.com/cddl/
 *   
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 */

package com.sun.facelets.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;

import com.sun.facelets.tag.TagAttribute;

import java.util.logging.Level;
import java.util.logging.Logger;
/**
 * 
 * 
 * @author Jacob Hookom
 * @version $Id: TagValueExpression.java,v 1.6 2005/08/24 04:38:57 jhook Exp $
 */
public final class TagValueExpression extends ValueExpression implements Externalizable {

    protected final static Logger log = Logger.getLogger("strawberry.el.funmap");
  
    protected final static Logger stateLog = Logger.getLogger("strawberry.state.save");
    protected final static Logger restoreLog = Logger.getLogger("strawberry.state.restore");
    
    private static final long serialVersionUID = 1L;

    private ValueExpression orig;

    private String attr;

    public TagValueExpression() {
        super();
    }

    public TagValueExpression(TagAttribute attr, ValueExpression orig) {
        
        String wk = "";
        if (attr != null) {
            // t@CA̒̈ʒu\
            wk = attr.toString(); // 񂪒̂ŁA
            int n = wk.lastIndexOf("/"); // Z
            if (n >= 0) {
                wk = wk.substring(n + 1);
            }
            int k = wk.indexOf("value");
            if (k >=0) {
                wk = wk.substring(0, k -1);
            }
        }
        this.attr = wk;
        
        this.orig = orig;
        //log.fine("56) " + orig);
    }

    public Class getExpectedType() {
        log.fine("60) getExpectedType");
        return this.orig.getExpectedType();
    }

    public Class getType(ELContext context) {
        log.fine("65) getType");
        try {
            return this.orig.getType(context);
        } catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": "
                    + pnfe.getMessage(), pnfe.getCause());
        } catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public Object getValue(ELContext context) {
        log.fine("77) getValue" );
        //log.config("77) getValue  " + orig.getClass().getName() );
        try {
            return this.orig.getValue(context);
        } catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": "
                    + pnfe.getMessage(), pnfe.getCause());
        } catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public boolean isReadOnly(ELContext context) {
        log.fine("89) isReadOnly");
        try {
            return this.orig.isReadOnly(context);
        } catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": "
                    + pnfe.getMessage(), pnfe.getCause());
        } catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public void setValue(ELContext context, Object value) {
        log.fine("101) setValue");
        try {
            this.orig.setValue(context, value);
        } catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": "
                    + pnfe.getMessage(), pnfe.getCause());
        } catch (PropertyNotWritableException pnwe) {
            throw new PropertyNotWritableException(this.attr + ": "
                    + pnwe.getMessage(), pnwe.getCause());
        } catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public boolean equals(Object obj) {
        log.fine("116) equals");
        return this.orig.equals(obj);
    }

    public String getExpressionString() {
        log.fine("121) getExpressionString");
        return this.orig.getExpressionString();
    }

    public int hashCode() {
        return this.orig.hashCode();
    }

    public boolean isLiteralText() {
        return this.orig.isLiteralText();
    }

    public void readExternal(ObjectInput in) throws IOException,
                                                    ClassNotFoundException {
        restoreLog.fine("readExternal");
        this.orig = (ValueExpression) in.readObject();
        this.attr = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        stateLog.fine("writeExternal");
        try {
            out.writeObject(this.orig);
        } catch (java.io.NotSerializableException nse1) {
            stateLog.log(Level.SEVERE, "orig = " + orig.getClass().getName());
            //                            org.apache.el.ValueExpressionImpl
            throw nse1;
        }
        try {
            out.writeUTF(this.attr); // attr  String
        } catch (java.io.NotSerializableException nse2) {
            stateLog.log(Level.SEVERE, "attr = " + attr.getClass().getName());
            throw nse2;
        }
    }

    public String toString() {
        return this.attr + ": " + this.orig;
    }
    
    // ǉ
    public String getDebugString() {
        return "el.TagValueExpression[" + attr + ", " + orig + "]";
    }

    // ǉ
    public ValueExpression getOrig() {
        return  orig;
    }

}
