/*   -*- Mode: java4; -*-
 * Licensed under the Common Development and Distribution License,
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.sun.com/cddl/
 *   
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 */

package com.sun.facelets.compiler;

import java.util.HashMap;
import java.util.Map;

import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.TagLibrary;

import java.util.logging.Level;
import java.util.logging.Logger;
/**
 * 
 * @author Jacob Hookom
 * @version $Id: NamespaceUnit.java,v 1.3 2005/08/24 04:38:54 jhook Exp $
 */
final class NamespaceUnit extends CompilationUnit {

    protected final static Logger log = Logger.getLogger("strawberry.fls.compiler");
  
    private final Map ns = new HashMap();
    private final TagLibrary library;

    /* Ăяo                        
        at com.sun.facelets.compiler.NamespaceUnit.<init>(NamespaceUnit.java:39)
        at com.sun.facelets.compiler.CompilationManager.pushNamespace(CompilationManager.java:267)
                                                   SAXCompiler ̓NX
        at com.sun.facelets.compiler.SAXCompiler$CompilationHandler.startPrefixMapping(SAXCompiler.java:217)
        at org.apache.crimson.parser.Parser2.processAttributeNS(Parser2.java:1774)
        at org.apache.crimson.parser.Parser2.maybeElement(Parser2.java:1620)
        at org.apache.crimson.parser.Parser2.parseInternal(Parser2.java:667)
        at org.apache.crimson.parser.Parser2.parse(Parser2.java:337)
        at org.apache.crimson.parser.XMLReaderImpl.parse(XMLReaderImpl.java:448)
        at javax.xml.parsers.SAXParser.parse(SAXParser.java:345)
        at javax.xml.parsers.SAXParser.parse(SAXParser.java:143)
        at com.sun.facelets.compiler.SAXCompiler.doCompile(SAXCompiler.java:261)
        at com.sun.facelets.compiler.Compiler.compile(Compiler.java:110)
        at com.sun.facelets.impl.DefaultFaceletFactory.createFacelet(DefaultFaceletFactory.java:196)

      */
    public NamespaceUnit(TagLibrary library) {
        this.library = library;
       //new UnsupportedOperationException("NamespaceUnit.java").printStackTrace();
    }

    /*  Ăяo
        at com.sun.facelets.compiler.NamespaceUnit.createFaceletHandler(NamespaceUnit.java:47) ===> 
        at com.sun.facelets.compiler.TextUnit.createFaceletHandler(TextUnit.java:76)
        at com.sun.facelets.compiler.CompilationUnit.getNextFaceletHandler(CompilationUnit.java:69)
        at com.sun.facelets.compiler.CompilationUnit.createFaceletHandler(CompilationUnit.java:60)
        at com.sun.facelets.compiler.CompilationManager.createFaceletHandler(CompilationManager.java:263)
        at com.sun.facelets.compiler.SAXCompiler.doCompile(SAXCompiler.java:252)
        at com.sun.facelets.compiler.Compiler.compile(Compiler.java:110)
        at com.sun.facelets.impl.DefaultFaceletFactory.createFacelet(DefaultFaceletFactory.java:195)
        at com.sun.facelets.impl.DefaultFaceletFactory.getFacelet(DefaultFaceletFactory.java:141)
        at com.sun.facelets.impl.DefaultFaceletFactory.getFacelet(DefaultFaceletFactory.java:93)
        at com.sun.facelets.FaceletViewHandler.buildView(FaceletViewHandler.java:494)
     */
    public FaceletHandler createFaceletHandler() {
        FaceletHandler next = this.getNextFaceletHandler();
        if (log.isLoggable(Level.FINE)) {
          log.fine("NamespaceHandler 쐬܂...  ");
          //  ns = {h=http://java.sun.com/jsf/html, c=http://java.sun.com/jstl/core,
          //         f=http://java.sun.com/jsf/core,  =http://www.w3.org/1999/xhtml}
          //  library = com.sun.facelets.tag.CompositeTagLibrary@16614e7
        }
        return new NamespaceHandler(next, this.library, this.ns);
    }
    /**
     *  ̃\bh SAXParser Ă΂
     */
    public void setNamespace(String prefix, String uri) {
      if (log.isLoggable(Level.FINE)) {
        log.fine("setNamespace,  prefix='" + prefix + "', uri=" + uri);
      }

      this.ns.put(prefix, uri);
    }

}
