/*   -*- Mode: java4; -*-
 * Licensed under the Common Development and Distribution License,
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.sun.com/cddl/
 *   
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 */
package com.sun.facelets.compiler;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.el.CompositeFunctionMapper;
import com.sun.facelets.tag.TagLibrary;
import java.util.logging.*;

import  javax.faces.component.html.HtmlOutputText;
/**
 *   xhtmlNamespacẽnh[B
 *   xhtml͂邽тɁÃCX^X܂
 */
public final class NamespaceHandler extends FunctionMapper implements FaceletHandler {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.el.funmap");
    
    private final TagLibrary library;

    /**  ȉ̂悤ȓo^Map
     *   h="http://java.sun.com/jsf/html"
     *   f="http://java.sun.com/jsf/core"
     */
    private final Map ns;

    private FaceletHandler next;

    // ǉ
    public FaceletHandler getNext() { return next; }
    /* Ăяo                               
        at com.sun.facelets.compiler.NamespaceHandler.<init>(NamespaceHandler.java:58)
        at com.sun.facelets.compiler.NamespaceUnit.createFaceletHandler(NamespaceUnit.java:64)
        at com.sun.facelets.compiler.TextUnit.createFaceletHandler(TextUnit.java:76)
        at com.sun.facelets.compiler.CompilationUnit.getNextFaceletHandler(CompilationUnit.java:69)
        at com.sun.facelets.compiler.CompilationUnit.createFaceletHandler(CompilationUnit.java:60)
        at com.sun.facelets.compiler.CompilationManager.createFaceletHandler(CompilationManager.java:274)
        at com.sun.facelets.compiler.SAXCompiler.doCompile(SAXCompiler.java:286)
      */
    public NamespaceHandler(FaceletHandler next, TagLibrary library, Map ns) {
        
        this.library = library;  // com.sun.facelets.tag.CompositeTagLibrary
        this.ns = ns;
        this.next = next;
    }
    /*                                                   
        at com.sun.facelets.compiler.NamespaceHandler.apply(NamespaceHandler.java:47)
        at com.sun.facelets.tag.CompositeFaceletHandler.apply(CompositeFaceletHandler.java:47)
        at com.sun.facelets.compiler.EncodingHandler.apply(EncodingHandler.java:25)
        at com.sun.facelets.impl.DefaultFacelet.apply(DefaultFacelet.java:95)
        at com.sun.facelets.FaceletViewHandler.buildView(FaceletViewHandler.java:506)
      */
    public void apply(FaceletContext ctx, UIComponent parent)
            throws IOException, FacesException, FaceletException, ELException {
        
        FunctionMapper orig = ctx.getFunctionMapper();
        CompositeFunctionMapper cfm = new CompositeFunctionMapper(this, orig);
        ctx.setFunctionMapper(cfm);
        try {
            if (log.isLoggable(Level.FINE)) {
              log.fine("63) CompositeFunctionMapper = " + cfm);
              log.fine("64) CompositeFunctionMapper  ֐ǉ܂ ---------- ");
              log.fine("65) ctx = " + ctx);
              log.fine("66) next.apply() ************************ Jn ");
            }
            next.apply(ctx, parent);
        } finally {
            log.fine("70) next.apply() ************************ I ");
            ctx.setFunctionMapper(orig);
        }

        /* ǉ
        HtmlOutputText fnMapUic = new HtmlOutputText();
        fnMapUic.setValue("CompositeFunctionMapper  ֐ǉ܂");
        parent.getChildren().add(fnMapUic);
          */
        if (log.isLoggable(Level.FINE)) 
            log.fine("79) ns = " + ns);
        //parent.getAttributes().put("FunctionMapper", "CompositeFunctionMapper  ֐ǉ܂");
        parent.getAttributes().put("FunctionMapper", ns);
    }

    /**
     *    javax.el.FunctionMapper ̎
     *
     *     jf="http://java.sun.com/jsp/jstl/functions" Œ`
     *     jf:length("abc") Ǝgꍇ
     *
     *     prefix = "jf", localName="length" ŌĂ΂
     */
    public Method resolveFunction(String prefix, String localName) {
        if (log.isLoggable(Level.FINE))
            log.fine("68) resolveFunction  -----------------" + prefix + ":" + localName);

        // ns (Map)  prefix (̗ł jf) Ō
        String uri = (String) this.ns.get(prefix);

        // uri = "http://java.sun.com/jsp/jstl/functions"  ƕϊ
        
        if (uri != null) {
            //   TagLibrary  createFunctionĂԂ
            //   java.lang.reflect.Method ɕϊ
            return this.library.createFunction(uri, localName);
        }
        return null;
    }
}
