//   -*- Mode: java4; -*-
/**
 * Licensed under the Common Development and Distribution License,
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.sun.com/cddl/
 *   
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 */
package com.sun.facelets.compiler;

import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletHandler;
import java.util.logging.*;

public class EncodingHandler implements FaceletHandler {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.facelet");
  
    private final FaceletHandler next;
    private final String encoding;
    
    public EncodingHandler(FaceletHandler next, String encoding) {
        this.next = next;
        this.encoding = encoding;
    }

    public FaceletHandler getNext() { return next; }


    
    /*                                               
        at com.sun.facelets.compiler.EncodingHandler.apply(EncodingHandler.java:25)
        at com.sun.facelets.impl.DefaultFacelet.apply(DefaultFacelet.java:95)
        at com.sun.facelets.FaceletViewHandler.buildView(FaceletViewHandler.java:506)
    */
    public void apply(FaceletContext ctx, UIComponent parent)
            throws IOException, FacesException, FaceletException, ELException {

        if (log.isLoggable(Level.FINE))
            log.fine("35) next = " + next.getClass().getName());
        //     com.sun.facelets.tag.CompositeFaceletHandler
        this.next.apply(ctx, parent);

        if (log.isLoggable(Level.FINE))
            log.fine("40) encoding = '" + encoding + "'");
        ctx.getFacesContext().getExternalContext().getRequestMap().put("facelets.Encoding", this.encoding);
    }
}
