package com.sun.facelets;

import java.io.IOException;
import java.util.List;
import java.util.logging.*;
import javax.faces.component.UIComponent;
/**
 *  ؂̕\ȂǂNX
 * @author masa
 */
public class DebugWriter {

  // jdk1.4 logging
  protected final static Logger log1 = Logger.getLogger("strawberry.tree");

  public void printTreeToEncode(UIComponent component) {
    if (log1.isLoggable(Level.FINE)) {
      debugPrintTree("ToEncode", " ", component);
    }
  }
  public void printTreeToSave(UIComponent component) {
    if (log1.isLoggable(Level.FINE)) {
      debugPrintTree("ToSave", " ", component);
    }
  }

  public void debugPrintTree(String msg, String space, UIComponent component) {

    String clsName = component.getClass().getName();

    String wk = msg + space + simplifyClassName(clsName);
    
    boolean tran = component.isTransient();
    if (! tran) {
      wk += ", *transient = false*";
    }
    log1.fine(wk);

    List childs = component.getChildren();
    for (int i = 0; i < childs.size(); i++) {
      UIComponent kid = (UIComponent) childs.get(i);
      debugPrintTree(msg, "  " + space, kid);
    }
  }

  public String simplifyClassName(String className) {

    if (className.startsWith("com.sun.")) {
      className = className.substring(8); // com.sun.
    }
    return className;
  }


  
}
