/* i386-linux.kernel.vmlinuz.h
   created from i386-linux.kernel.vmlinuz.bin, 29484 (0x732c) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2013 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2013 Laszlo Molnar
   Copyright (C) 2000-2013 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_I386_LINUX_KERNEL_VMLINUZ_SIZE    29484
#define STUB_I386_LINUX_KERNEL_VMLINUZ_ADLER32 0x1f442013
#define STUB_I386_LINUX_KERNEL_VMLINUZ_CRC32   0x6bd83028

unsigned char stub_i386_linux_kernel_vmlinuz[29484] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 216, 31,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */ 170,  0,167,  0,252,140,200,131,192,  8,142,216,142,192,142,208,
/* 0x0040 */ 141,166,  0,  0,  0,  0,137,245,102,129,190,  6,  2,  0,  0,  2,
/* 0x0050 */   2,115, 18,137,238,102,129,125, 32, 63,163,117, 18, 15,183,117,
/* 0x0060 */  34,  1,238,235, 10,139,182, 40,  2,  0,  0,133,246,116,228, 41,
/* 0x0070 */ 201,172, 65, 60,  0,117,250,137,250,191,176,151,  9,  0,141, 71,
/* 0x0080 */  79, 57,254,115, 42, 79, 78,253,243,164,252, 71,137,189, 40,  2,
/* 0x0090 */   0,  0, 41,248,137,133, 56,  2,  0,  0,137,248, 41,232,102,137,
/* 0x00a0 */  69, 34,131,231,252,137,127,248,140, 95,252, 15,178,103,248,137,
/* 0x00b0 */ 215,137,238,106,  0,157, 87,191,  0,  0,  9,  0, 87,185,148,  0,
/* 0x00c0 */   0,  0,243,165, 94, 95,188,  0,  0,  9,  0,184,  0,  0,  0,  0,
/* 0x00d0 */  14, 80, 87, 86,131,205,255,232,  0,  0,  0,  0, 93,232, 22,  0,
/* 0x00e0 */   0,  0,247,217, 57,247,118,  9,141,116, 14,252,141,124, 15,252,
/* 0x00f0 */ 253,193,233,  2,243,165,252,195,137,242, 94,139, 78,252,247,217,
/* 0x0100 */ 131,225,252,  1,204,137,231,255,214,137,239,247,223,129,231,  0,
/* 0x0110 */   0,  0,  0,247,223,191,  0,  0,  0,  0,137,224, 82,141,151,  0,
/* 0x0120 */   0,  0,  0,137,238, 82,129,194,  0,  0,  0,  0, 87,129,199,  0,
/* 0x0130 */   0,  0,  0, 87,185,  0,  0,  0,  0, 82,255,224, 94, 95, 87, 87,
/* 0x0140 */ 106,  0,104,  0,  0,  0,  0, 93, 94,137,235,129,235,  0,  0,  0,
/* 0x0150 */   0,116, 17,253,173,235,  7,  1,156,  3,  0,  0,  0,  0,173,133,
/* 0x0160 */ 192,117,244,252, 94, 49,219,255,229, 80, 80,106,  0,104,  0,  0,
/* 0x0170 */   0,  0,190,  0,  0,  0,  0,191,  0,  0,  0,  0,185,  0,  0,  0,
/* 0x0180 */   0,253,243,165,252,190,  0,  0,  0,  0,151,233,252,255,255,255,
/* 0x0190 */  71,137,125,  1, 57, 56,116,248,252,190,  0,  0,  0,  0,151,235,
/* 0x01a0 */   3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,
/* 0x01b0 */ 131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,255,184,  1,
/* 0x01c0 */   0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,
/* 0x01d0 */   1,219,117,  7,139, 30,131,238,252, 17,219,115,255,  1,219,115,
/* 0x01e0 */ 255,117,  9,139, 30,131,238,252, 17,219,115,255, 49,201,131,232,
/* 0x01f0 */   3,114, 13,193,224,  8,138,  6, 70,131,240,255,116,255,137,197,
/* 0x0200 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,
/* 0x0210 */   7,139, 30,131,238,252, 17,219, 17,201,117,255, 65,  1,219,117,
/* 0x0220 */   7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,
/* 0x0230 */ 131,238,252, 17,219,115, 48,  1,219,115, 48,117,  9,139, 30,131,
/* 0x0240 */ 238,252, 17,219,115, 48, 65, 65,131,193,  2,129,253,  0,243,255,
/* 0x0250 */ 255,131,209,  1, 86,141, 52, 47,243,164, 94,233,252,255,255,255,
/* 0x0260 */ 141, 20, 47,131,253,252,138,  4, 15,118,255,138,  2, 66,136,  7,
/* 0x0270 */  71, 73,117,247,233,252,255,255,255,139,  2,131,194,  4,137,  7,
/* 0x0280 */ 131,199,  4,131,233,  4,119,241,  1,207,233,252,255,255,255,235,
/* 0x0290 */   3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,
/* 0x02a0 */ 131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,255,184,  1,
/* 0x02b0 */   0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,
/* 0x02c0 */   1,219,117,  7,139, 30,131,238,252, 17,219,114, 15,  1,219,115,
/* 0x02d0 */  11,117, 15,139, 30,131,238,252, 17,219,114, 15, 72,  1,219,117,
/* 0x02e0 */   7,139, 30,131,238,252, 17,219, 17,192,235,255, 49,201,131,232,
/* 0x02f0 */   3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,255,209,248,
/* 0x0300 */ 137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x0310 */ 201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,255,
/* 0x0320 */  65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,
/* 0x0330 */ 117,  7,139, 30,131,238,252, 17,219,115, 68,  1,219,115, 68,117,
/* 0x0340 */   9,139, 30,131,238,252, 17,219,115, 68, 65, 65,131,193,  2,129,
/* 0x0350 */ 253,  0,251,255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,
/* 0x0360 */ 252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,118,255,138,
/* 0x0370 */   2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,131,
/* 0x0380 */ 194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,252,
/* 0x0390 */ 255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,
/* 0x03a0 */ 117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,138,  7,
/* 0x03b0 */ 114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252,
/* 0x03c0 */  17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,114,
/* 0x03d0 */  30,  1,219,115, 11,117, 30,139, 30,131,238,252, 17,219,114, 30,
/* 0x03e0 */  72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,255,
/* 0x03f0 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,235,255, 49,
/* 0x0400 */ 201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,
/* 0x0410 */ 255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252,
/* 0x0420 */  17,219,114,204, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0430 */ 114,190,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,
/* 0x0440 */ 219,117,  7,139, 30,131,238,252, 17,219,115, 81,  1,219,115, 81,
/* 0x0450 */ 117,  9,139, 30,131,238,252, 17,219,115, 81, 65, 65,131,193,  2,
/* 0x0460 */ 129,253,  0,251,255,255,131,209,  2, 86,141, 52, 47,243,164, 94,
/* 0x0470 */ 233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,118,255,
/* 0x0480 */ 138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,
/* 0x0490 */ 131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,
/* 0x04a0 */ 252,255,255,255,137,229,141,156, 36,  0,  0,  0,  0, 49,192, 80,
/* 0x04b0 */  57,220,117,251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,195,  4,
/* 0x04c0 */  83,104,  0,  0,  0,  0, 86,131,195,  4, 83, 80,199,  3,  0,  0,
/* 0x04d0 */   0,  0,137,229,139, 85,  0,172, 74,136,193, 36,  7,192,233,  3,
/* 0x04e0 */ 187,  0,253,255,255,211,227,141,164, 92,144,241,255,255,131,228,
/* 0x04f0 */ 224,106,  0,106,  0,137,227, 83,131,195,  4,139, 77,  0,255, 49,
/* 0x0500 */  87, 83,131,195,  4,136, 67,  2,172, 74,136,193, 36, 15,136,  3,
/* 0x0510 */ 192,233,  4,136, 75,  1, 82, 86, 83, 80, 85, 87, 86, 83,131,236,
/* 0x0520 */ 124,139,148, 36,144,  0,  0,  0,199, 68, 36,116,  0,  0,  0,  0,
/* 0x0530 */ 198, 68, 36,115,  0,139,172, 36,156,  0,  0,  0,141, 66,  4,137,
/* 0x0540 */  68, 36,120,184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,
/* 0x0550 */ 137,217, 73,137, 76, 36,108, 15,182, 74,  1,211,224, 72,137, 68,
/* 0x0560 */  36,104,139,132, 36,168,  0,  0,  0, 15,182, 50,199, 69,  0,  0,
/* 0x0570 */   0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,  0,  0,
/* 0x0580 */   0,184,  0,  3,  0,  0,137,116, 36,100,199, 68, 36, 92,  1,  0,
/* 0x0590 */   0,  0,199, 68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,  1,  0,
/* 0x05a0 */   0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,  1,241,
/* 0x05b0 */ 211,224,141,136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,139, 68,
/* 0x05c0 */  36,120,102,199,  0,  0,  4,131,192,  2,226,246,139,156, 36,148,
/* 0x05d0 */   0,  0,  0, 49,255,199, 68, 36, 72,255,255,255,255,137,218,  3,
/* 0x05e0 */ 148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,210, 59, 92, 36, 76,
/* 0x05f0 */  15,132,124,  9,  0,  0, 15,182,  3,193,231,  8, 66, 67,  9,199,
/* 0x0600 */ 131,250,  4,126,231,139,140, 36,164,  0,  0,  0, 57, 76, 36,116,
/* 0x0610 */  15,131,100,  9,  0,  0,139,116, 36,116, 35,116, 36,108,139, 68,
/* 0x0620 */  36, 96,139, 84, 36,120,193,224,  4,137,116, 36, 68,  1,240,129,
/* 0x0630 */ 124, 36, 72,255,255,255,  0,141, 44, 66,119, 24, 59, 92, 36, 76,
/* 0x0640 */  15,132, 44,  9,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,
/* 0x0650 */   8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,
/* 0x0660 */ 183,202, 15,175,193, 57,199, 15,131,221,  1,  0,  0,137, 68, 36,
/* 0x0670 */  72,184,  0,  8,  0,  0, 41,200,138, 76, 36,100,193,248,  5,190,
/* 0x0680 */   1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,115,102,137, 69,  0,
/* 0x0690 */ 139, 68, 36,116, 35, 68, 36,104,139,108, 36,120,211,224,185,  8,
/* 0x06a0 */   0,  0,  0, 43, 76, 36,100,211,250,  1,208,105,192,  0,  6,  0,
/* 0x06b0 */   0,131,124, 36, 96,  6,141,132,  5,108, 14,  0,  0,137, 68, 36,
/* 0x06c0 */  20, 15,142,202,  0,  0,  0,139, 68, 36,116, 43, 68, 36, 92,139,
/* 0x06d0 */ 148, 36,160,  0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,209,100,
/* 0x06e0 */  36, 64,139, 76, 36, 64,141, 20, 54,139,108, 36, 20,129,225,  0,
/* 0x06f0 */   1,  0,  0,129,124, 36, 72,255,255,255,  0,141, 68, 77,  0,137,
/* 0x0700 */  76, 36, 60,141, 44, 16,119, 24, 59, 92, 36, 76, 15,132, 96,  8,
/* 0x0710 */   0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,
/* 0x0720 */ 139, 68, 36, 72,102,139,141,  0,  2,  0,  0,193,232, 11, 15,183,
/* 0x0730 */ 241, 15,175,198, 57,199,115, 35,137, 68, 36, 72,184,  0,  8,  0,
/* 0x0740 */   0, 41,240,137,214,193,248,  5,131,124, 36, 60,  0,141,  4,  1,
/* 0x0750 */ 102,137,133,  0,  2,  0,  0,116, 34,235, 46, 41, 68, 36, 72, 41,
/* 0x0760 */ 199,137,200,141,114,  1,102,193,232,  5,102, 41,193,131,124, 36,
/* 0x0770 */  60,  0,102,137,141,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,
/* 0x0780 */   0, 15,142, 87,255,255,255,235,121,129,254,255,  0,  0,  0,127,
/* 0x0790 */ 113,141, 20, 54,139,108, 36, 20,  1,213,129,124, 36, 72,255,255,
/* 0x07a0 */ 255,  0,119, 24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,193,100,
/* 0x07b0 */  36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,
/* 0x07c0 */ 102,139, 77,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115,
/* 0x07d0 */  25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,
/* 0x07e0 */   5,141,  4,  1,102,137, 69,  0,235,159, 41, 68, 36, 72, 41,199,
/* 0x07f0 */ 137,200,141,114,  1,102,193,232,  5,102, 41,193,102,137, 77,  0,
/* 0x0800 */ 235,135,139, 84, 36,116,137,240,139,140, 36,160,  0,  0,  0,136,
/* 0x0810 */  68, 36,115,136,  4, 10, 66,131,124, 36, 96,  3,137, 84, 36,116,
/* 0x0820 */ 127, 13,199, 68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,  0,131,
/* 0x0830 */ 124, 36, 96,  9,127, 10,131,108, 36, 96,  3,233, 10,  7,  0,  0,
/* 0x0840 */ 131,108, 36, 96,  6,233,  0,  7,  0,  0,139, 76, 36, 72, 41,199,
/* 0x0850 */ 139,116, 36, 96, 41,193,137,208,102,193,232,  5,102, 41,194,129,
/* 0x0860 */ 249,255,255,255,  0,102,137, 85,  0,139,108, 36,120,141,116,117,
/* 0x0870 */   0,137,116, 36, 56,119, 22, 59, 92, 36, 76, 15,132,241,  6,  0,
/* 0x0880 */   0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,139,108, 36,
/* 0x0890 */  56,137,200,193,232, 11,102,139,149,128,  1,  0,  0, 15,183,234,
/* 0x08a0 */  15,175,197, 57,199,115, 82,137,198,184,  0,  8,  0,  0, 41,232,
/* 0x08b0 */ 139,108, 36, 88,193,248,  5,139, 76, 36, 84,141,  4,  2,139, 84,
/* 0x08c0 */  36, 56,137, 76, 36, 80,139, 76, 36,120,102,137,130,128,  1,  0,
/* 0x08d0 */   0,139, 68, 36, 92,137,108, 36, 84,137, 68, 36, 88, 49,192,131,
/* 0x08e0 */ 124, 36, 96,  6, 15,159,192,129,193,100,  6,  0,  0,141,  4, 64,
/* 0x08f0 */ 137, 68, 36, 96,233,116,  2,  0,  0,137,206, 41,199, 41,198,137,
/* 0x0900 */ 208,102,193,232,  5,139, 76, 36, 56,102, 41,194,129,254,255,255,
/* 0x0910 */ 255,  0,102,137,145,128,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,
/* 0x0920 */ 132, 77,  6,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,
/* 0x0930 */ 199,139,108, 36, 56,137,242,193,234, 11,102,139,141,152,  1,  0,
/* 0x0940 */   0, 15,183,193, 15,175,208, 57,215, 15,131,227,  0,  0,  0,189,
/* 0x0950 */   0,  8,  0,  0,137,214, 41,197,199, 68, 36, 52,  0,  8,  0,  0,
/* 0x0960 */ 137,232,193,248,  5,141,  4,  1,139, 76, 36, 56,102,137,129,152,
/* 0x0970 */   1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,193,224,  5,  3, 68,
/* 0x0980 */  36,120,129,250,255,255,255,  0,141, 44, 72,119, 22, 59, 92, 36,
/* 0x0990 */  76, 15,132,219,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8,
/* 0x09a0 */  67,  9,199,102,139,149,224,  1,  0,  0,137,240,193,232, 11, 15,
/* 0x09b0 */ 183,202, 15,175,193, 57,199,115, 96, 41, 76, 36, 52,193,124, 36,
/* 0x09c0 */  52,  5,139,116, 36, 52,137, 68, 36, 72,131,124, 36,116,  0,141,
/* 0x09d0 */   4, 50,102,137,133,224,  1,  0,  0, 15,132,147,  5,  0,  0, 49,
/* 0x09e0 */ 192,131,124, 36, 96,  6,139,172, 36,160,  0,  0,  0,139, 84, 36,
/* 0x09f0 */ 116, 15,159,192,141, 68,  0,  9,137, 68, 36, 96,139, 68, 36,116,
/* 0x0a00 */  43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,115,136,  4, 42, 66,
/* 0x0a10 */ 137, 84, 36,116,233, 49,  5,  0,  0, 41,198, 41,199,137,208,102,
/* 0x0a20 */ 193,232,  5,102, 41,194,102,137,149,224,  1,  0,  0,233, 31,  1,
/* 0x0a30 */   0,  0,137,200, 41,214,102,193,232,  5,139,108, 36, 56,102, 41,
/* 0x0a40 */ 193, 41,215,129,254,255,255,255,  0,102,137,141,152,  1,  0,  0,
/* 0x0a50 */ 119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,  3,193,
/* 0x0a60 */ 231,  8,193,230,  8, 67,  9,199,139, 76, 36, 56,137,240,193,232,
/* 0x0a70 */  11,102,139,145,176,  1,  0,  0, 15,183,202, 15,175,193, 57,199,
/* 0x0a80 */ 115, 35,137,198,184,  0,  8,  0,  0, 41,200,139,108, 36, 56,193,
/* 0x0a90 */ 248,  5,141,  4,  2,102,137,133,176,  1,  0,  0,139, 68, 36, 88,
/* 0x0aa0 */ 233,160,  0,  0,  0,137,241, 41,199, 41,193,137,208,102,193,232,
/* 0x0ab0 */   5,102, 41,194,139, 68, 36, 56,129,249,255,255,255,  0,102,137,
/* 0x0ac0 */ 144,176,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,161,  4,  0,
/* 0x0ad0 */   0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,139,116, 36,
/* 0x0ae0 */  56,137,200,193,232, 11,102,139,150,200,  1,  0,  0, 15,183,234,
/* 0x0af0 */  15,175,197, 57,199,115, 32,137,198,184,  0,  8,  0,  0, 41,232,
/* 0x0b00 */ 139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,200,  1,  0,
/* 0x0b10 */   0,139, 68, 36, 84,235, 38,137,206, 41,199, 41,198,137,208,102,
/* 0x0b20 */ 193,232,  5,102, 41,194,139, 68, 36, 56,102,137,144,200,  1,  0,
/* 0x0b30 */   0,139, 84, 36, 84,139, 68, 36, 80,137, 84, 36, 80,139, 76, 36,
/* 0x0b40 */  88,137, 76, 36, 84,139,108, 36, 92,137, 68, 36, 92,137,108, 36,
/* 0x0b50 */  88, 49,192,131,124, 36, 96,  6,139, 76, 36,120, 15,159,192,129,
/* 0x0b60 */ 193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 96,129,254,255,
/* 0x0b70 */ 255,255,  0,119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,  0, 15,
/* 0x0b80 */ 182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 17,137,240,
/* 0x0b90 */ 193,232, 11, 15,183,234, 15,175,197, 57,199,115, 47,137, 68, 36,
/* 0x0ba0 */  72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,
/* 0x0bb0 */ 199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,102,137,  1,139, 68,
/* 0x0bc0 */  36, 68,141, 76,  1,  4,137, 76, 36, 16,235,114, 41,198, 41,199,
/* 0x0bd0 */ 137,208,102,193,232,  5,102, 41,194,129,254,255,255,255,  0,102,
/* 0x0be0 */ 137, 17,119, 22, 59, 92, 36, 76, 15,132,132,  3,  0,  0, 15,182,
/* 0x0bf0 */   3,193,231,  8,193,230,  8, 67,  9,199,102,139, 81,  2,137,240,
/* 0x0c00 */ 193,232, 11, 15,183,234, 15,175,197, 57,199,115, 59,137, 68, 36,
/* 0x0c10 */  72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,
/* 0x0c20 */ 199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,139, 84, 36, 68,102,
/* 0x0c30 */ 137, 65,  2,141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,199, 68,
/* 0x0c40 */  36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,199,137,208,137,116,
/* 0x0c50 */  36, 72,102,193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,102, 41,
/* 0x0c60 */ 194,199, 68, 36, 48,  8,  0,  0,  0,102,137, 81,  2,129,193,  4,
/* 0x0c70 */   2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,  0,  0,
/* 0x0c80 */ 137, 76, 36, 40,141, 44, 18,139,116, 36, 16,  1,238,129,124, 36,
/* 0x0c90 */  72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,209,  2,  0,
/* 0x0ca0 */   0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139,
/* 0x0cb0 */  68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x0cc0 */ 199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x0cd0 */   5,141,  4,  2,137,234,102,137,  6,235, 21, 41, 68, 36, 72, 41,
/* 0x0ce0 */ 199,137,208,102,193,232,  5,102, 41,194,102,137, 22,141, 85,  1,
/* 0x0cf0 */ 139,116, 36, 40, 78,137,116, 36, 40,117,137,138, 76, 36, 48,184,
/* 0x0d00 */   1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 44,131,124, 36, 96,
/* 0x0d10 */   3,137, 84, 36, 12, 15,143,231,  1,  0,  0,131, 68, 36, 96,  7,
/* 0x0d20 */ 131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139,116, 36,120,
/* 0x0d30 */ 193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,141,132,  6, 96,  3,
/* 0x0d40 */   0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,139,116,
/* 0x0d50 */  36,  8,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92,
/* 0x0d60 */  36, 76, 15,132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,
/* 0x0d70 */ 193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11,
/* 0x0d80 */  15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,
/* 0x0d90 */   8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,  6,137,232,
/* 0x0da0 */ 235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,
/* 0x0db0 */ 194,141, 69,  1,102,137, 22,139,108, 36, 36, 77,137,108, 36, 36,
/* 0x0dc0 */ 117,137,141, 80,192,131,250,  3,137, 20, 36, 15,142, 39,  1,  0,
/* 0x0dd0 */   0,137,208,137,214,209,248,131,230,  1,141, 72,255,131,206,  2,
/* 0x0de0 */ 131,250, 13,137, 76, 36, 32,127, 28,139,108, 36,120,211,230,  1,
/* 0x0df0 */ 210,137, 52, 36,141, 68,117,  0, 41,208,  5, 94,  5,  0,  0,137,
/* 0x0e00 */  68, 36,  4,235, 86,141, 80,251,129,124, 36, 72,255,255,255,  0,
/* 0x0e10 */ 119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,  0,193,100, 36, 72,
/* 0x0e20 */   8, 15,182,  3,193,231,  8, 67,  9,199,209,108, 36, 72,  1,246,
/* 0x0e30 */  59,124, 36, 72,114,  7, 43,124, 36, 72,131,206,  1, 74,117,200,
/* 0x0e40 */ 139, 68, 36,120,193,230,  4,137, 52, 36,  5, 68,  6,  0,  0,199,
/* 0x0e50 */  68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,199, 68, 36, 28,  1,
/* 0x0e60 */   0,  0,  0,184,  1,  0,  0,  0,139,108, 36,  4,  1,192,137, 68,
/* 0x0e70 */  36, 24,  1,197,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92,
/* 0x0e80 */  36, 76, 15,132,234,  0,  0,  0,193,100, 36, 72,  8, 15,182,  3,
/* 0x0e90 */ 193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232,
/* 0x0ea0 */  11, 15,183,242, 15,175,198, 57,199,115, 27,137, 68, 36, 72,184,
/* 0x0eb0 */   0,  8,  0,  0, 41,240,193,248,  5,141,  4,  2,102,137, 69,  0,
/* 0x0ec0 */ 139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,199,137,208,102,193,
/* 0x0ed0 */ 232,  5,102, 41,194,139, 68, 36, 24,102,137, 85,  0,139, 84, 36,
/* 0x0ee0 */  28, 64,  9, 20, 36,139, 76, 36, 32,209,100, 36, 28, 73,137, 76,
/* 0x0ef0 */  36, 32, 15,133,112,255,255,255,139, 52, 36, 70,137,116, 36, 92,
/* 0x0f00 */ 116, 89,139, 76, 36, 12,139,108, 36,116,131,193,  2, 57,108, 36,
/* 0x0f10 */  92,119, 95,139,132, 36,160,  0,  0,  0,137,234, 43, 68, 36, 92,
/* 0x0f20 */   3,148, 36,160,  0,  0,  0,141, 52, 40,138,  6, 70,136, 68, 36,
/* 0x0f30 */ 115,136,  2, 66,255, 68, 36,116, 73,116, 15,139,172, 36,164,  0,
/* 0x0f40 */   0,  0, 57,108, 36,116,114,226,235, 17,139,132, 36,164,  0,  0,
/* 0x0f50 */   0, 57, 68, 36,116, 15,130,187,246,255,255,129,124, 36, 72,255,
/* 0x0f60 */ 255,255,  0,119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,116, 41,
/* 0x0f70 */ 235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,156, 36,148,  0,  0,
/* 0x0f80 */   0, 49,192,139,148, 36,156,  0,  0,  0,139, 76, 36,116,137, 26,
/* 0x0f90 */ 139,156, 36,168,  0,  0,  0,137, 11,131,196,124, 91, 94, 95, 93,
/* 0x0fa0 */  85, 87, 86, 83,131,236,124,139,148, 36,144,  0,  0,  0,199, 68,
/* 0x0fb0 */  36,116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,  0,
/* 0x0fc0 */   0,  0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,182,
/* 0x0fd0 */  74,  2,137,195,211,227,137,217, 73,137, 76, 36,108, 15,182, 74,
/* 0x0fe0 */   1,211,224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,  0, 15,
/* 0x0ff0 */ 182, 50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,
/* 0x1000 */   0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,100,
/* 0x1010 */ 199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,
/* 0x1020 */ 199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0,
/* 0x1030 */  15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57, 76,
/* 0x1040 */  36,116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,192,  2,
/* 0x1050 */ 226,246,139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,255,
/* 0x1060 */ 255,255,255,137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36, 76,
/* 0x1070 */  49,210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,193,
/* 0x1080 */ 231,  8, 66, 67,  9,199,131,250,  4,126,231,139,140, 36,164,  0,
/* 0x1090 */   0,  0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,116,
/* 0x10a0 */  35,116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,137,
/* 0x10b0 */ 116, 36, 68,  1,240,129,124, 36, 72,255,255,255,  0,141, 44, 66,
/* 0x10c0 */ 119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36, 72,
/* 0x10d0 */   8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,
/* 0x10e0 */  85,  0,193,232, 11, 15,183,202, 15,175,193, 57,199, 15,131,221,
/* 0x10f0 */   1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138, 76,
/* 0x1100 */  36,100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182, 84,
/* 0x1110 */  36,115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,108,
/* 0x1120 */  36,120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,  1,
/* 0x1130 */ 208,105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,108,
/* 0x1140 */  14,  0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68, 36,
/* 0x1150 */ 116, 43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,  2,
/* 0x1160 */ 137, 68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,139,
/* 0x1170 */ 108, 36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,255,
/* 0x1180 */   0,141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59, 92,
/* 0x1190 */  36, 76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,  3,
/* 0x11a0 */ 193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,  0,
/* 0x11b0 */   0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 35,137, 68,
/* 0x11c0 */  36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,131,124,
/* 0x11d0 */  36, 60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,235,
/* 0x11e0 */  46, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,
/* 0x11f0 */ 102, 41,193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,116,
/* 0x1200 */  14,129,254,255,  0,  0,  0, 15,142, 87,255,255,255,235,121,129,
/* 0x1210 */ 254,255,  0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,213,
/* 0x1220 */ 129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,
/* 0x1230 */ 196,  7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,
/* 0x1240 */   9,199,139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,241,
/* 0x1250 */  15,175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,  0,
/* 0x1260 */  41,240,137,214,193,248,  5,141,  4,  1,102,137, 69,  0,235,159,
/* 0x1270 */  41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,102,
/* 0x1280 */  41,193,102,137, 77,  0,235,135,139, 84, 36,116,137,240,139,140,
/* 0x1290 */  36,160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,124, 36,
/* 0x12a0 */  96,  3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,
/* 0x12b0 */ 233, 27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,108, 36, 96,
/* 0x12c0 */   3,233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,  0,
/* 0x12d0 */ 139, 76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,208,102,193,
/* 0x12e0 */ 232,  5,102, 41,194,129,249,255,255,255,  0,102,137, 85,  0,139,
/* 0x12f0 */ 108, 36,120,141,116,117,  0,137,116, 36, 56,119, 22, 59, 92, 36,
/* 0x1300 */  76, 15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,  8,
/* 0x1310 */  67,  9,199,139,108, 36, 56,137,200,193,232, 11,102,139,149,128,
/* 0x1320 */   1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 82,137,198,184,
/* 0x1330 */   0,  8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,139, 76, 36,
/* 0x1340 */  84,141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,120,
/* 0x1350 */ 102,137,130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,137,
/* 0x1360 */  68, 36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,129,193,100,
/* 0x1370 */   6,  0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,137,
/* 0x1380 */ 206, 41,199, 41,198,137,208,102,193,232,  5,139, 76, 36, 56,102,
/* 0x1390 */  41,194,129,254,255,255,255,  0,102,137,145,128,  1,  0,  0,119,
/* 0x13a0 */  22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,231,
/* 0x13b0 */   8,193,230,  8, 67,  9,199,139,108, 36, 56,137,242,193,234, 11,
/* 0x13c0 */ 102,139,141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,215, 15,
/* 0x13d0 */ 131,227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,199, 68,
/* 0x13e0 */  36, 52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,139, 76,
/* 0x13f0 */  36, 56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76, 36,
/* 0x1400 */  68,193,224,  5,  3, 68, 36,120,129,250,255,255,255,  0,141, 44,
/* 0x1410 */  72,119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,  3,
/* 0x1420 */ 193,231,  8,193,230,  8, 67,  9,199,102,139,149,224,  1,  0,  0,
/* 0x1430 */ 137,240,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 96, 41,
/* 0x1440 */  76, 36, 52,193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36, 72,
/* 0x1450 */ 131,124, 36,116,  0,141,  4, 50,102,137,133,224,  1,  0,  0, 15,
/* 0x1460 */ 132,147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,160,
/* 0x1470 */   0,  0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,137, 68,
/* 0x1480 */  36, 96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136, 68,
/* 0x1490 */  36,115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0, 41,
/* 0x14a0 */ 198, 41,199,137,208,102,193,232,  5,102, 41,194,102,137,149,224,
/* 0x14b0 */   1,  0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,193,232,  5,
/* 0x14c0 */ 139,108, 36, 56,102, 41,193, 41,215,129,254,255,255,255,  0,102,
/* 0x14d0 */ 137,141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,
/* 0x14e0 */   0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139, 76,
/* 0x14f0 */  36, 56,137,240,193,232, 11,102,139,145,176,  1,  0,  0, 15,183,
/* 0x1500 */ 202, 15,175,193, 57,199,115, 35,137,198,184,  0,  8,  0,  0, 41,
/* 0x1510 */ 200,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,176,  1,
/* 0x1520 */   0,  0,139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,199, 41,
/* 0x1530 */ 193,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,129,249,
/* 0x1540 */ 255,255,255,  0,102,137,144,176,  1,  0,  0,119, 22, 59, 92, 36,
/* 0x1550 */  76, 15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,  8,
/* 0x1560 */  67,  9,199,139,116, 36, 56,137,200,193,232, 11,102,139,150,200,
/* 0x1570 */   1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 32,137,198,184,
/* 0x1580 */   0,  8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,141,  4,  2,
/* 0x1590 */ 102,137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206, 41,
/* 0x15a0 */ 199, 41,198,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,
/* 0x15b0 */ 102,137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,137,
/* 0x15c0 */  84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,137,
/* 0x15d0 */  68, 36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,139, 76,
/* 0x15e0 */  36,120, 15,159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,137,
/* 0x15f0 */  68, 36, 96,129,254,255,255,255,  0,119, 22, 59, 92, 36, 76, 15,
/* 0x1600 */ 132,243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,
/* 0x1610 */ 199,102,139, 17,137,240,193,232, 11, 15,183,234, 15,175,197, 57,
/* 0x1620 */ 199,115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100,
/* 0x1630 */  36, 68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,
/* 0x1640 */   2,102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,
/* 0x1650 */ 235,114, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,129,
/* 0x1660 */ 254,255,255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,132,
/* 0x1670 */ 132,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,
/* 0x1680 */ 102,139, 81,  2,137,240,193,232, 11, 15,183,234, 15,175,197, 57,
/* 0x1690 */ 199,115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100,
/* 0x16a0 */  36, 68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,
/* 0x16b0 */   2,139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,  0,
/* 0x16c0 */ 137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,198,
/* 0x16d0 */  41,199,137,208,137,116, 36, 72,102,193,232,  5,199, 68, 36, 44,
/* 0x16e0 */  16,  0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,102,
/* 0x16f0 */ 137, 81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76, 36,
/* 0x1700 */  48,186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116, 36,
/* 0x1710 */  16,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36,
/* 0x1720 */  76, 15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,
/* 0x1730 */ 231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,
/* 0x1740 */ 183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,
/* 0x1750 */   0,  0, 41,200,193,248,  5,141,  4,  2,137,234,102,137,  6,235,
/* 0x1760 */  21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,
/* 0x1770 */ 102,137, 22,141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,117,
/* 0x1780 */ 137,138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3, 84,
/* 0x1790 */  36, 44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,  0,
/* 0x17a0 */   0,131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,184,  3,  0,
/* 0x17b0 */   0,  0,139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,  0,
/* 0x17c0 */   0,141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,
/* 0x17d0 */   0,141, 44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,255,255,
/* 0x17e0 */ 255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,100,
/* 0x17f0 */  36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,
/* 0x1800 */ 102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,
/* 0x1810 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x1820 */   2,102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,208,
/* 0x1830 */ 102,193,232,  5,102, 41,194,141, 69,  1,102,137, 22,139,108, 36,
/* 0x1840 */  36, 77,137,108, 36, 36,117,137,141, 80,192,131,250,  3,137, 20,
/* 0x1850 */  36, 15,142, 39,  1,  0,  0,137,208,137,214,209,248,131,230,  1,
/* 0x1860 */ 141, 72,255,131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,139,
/* 0x1870 */ 108, 36,120,211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,208,
/* 0x1880 */   5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,124,
/* 0x1890 */  36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,
/* 0x18a0 */   0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,
/* 0x18b0 */ 209,108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36, 72,
/* 0x18c0 */ 131,206,  1, 74,117,200,139, 68, 36,120,193,230,  4,137, 52, 36,
/* 0x18d0 */   5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,
/* 0x18e0 */   4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,108,
/* 0x18f0 */  36,  4,  1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,255,
/* 0x1900 */ 255,  0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,100,
/* 0x1910 */  36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,
/* 0x1920 */ 102,139, 85,  0,193,232, 11, 15,183,242, 15,175,198, 57,199,115,
/* 0x1930 */  27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,141,
/* 0x1940 */   4,  2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36, 72,
/* 0x1950 */  41,199,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 24,102,
/* 0x1960 */ 137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,
/* 0x1970 */ 100, 36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,255,139, 52,
/* 0x1980 */  36, 70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,116,
/* 0x1990 */ 131,193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,  0,
/* 0x19a0 */ 137,234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52, 40,
/* 0x19b0 */ 138,  6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,116,
/* 0x19c0 */  15,139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,235, 17,
/* 0x19d0 */ 139,132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,255,
/* 0x19e0 */ 255,129,124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,184,
/* 0x19f0 */   1,  0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32, 67,
/* 0x1a00 */  43,156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,  0,
/* 0x1a10 */ 139, 76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,131,
/* 0x1a20 */ 196,124, 91, 94, 95, 93,  3,115,252,  3,123,248, 49,192,141,140,
/* 0x1a30 */  36,  0,255,255,255,137,236, 80, 57,204,117,251,137,236, 49,201,
/* 0x1a40 */  89, 90, 95,137,254,235, 29,138,  7,131,199,  1, 60,128,114, 10,
/* 0x1a50 */  60,143,119,  6,128,127,254, 15,116,  5, 44,232, 60,  1,119,255,
/* 0x1a60 */  56, 23,117,255,139,  7,102,193,232,  8,193,192, 16,134,196, 41,
/* 0x1a70 */ 248,  1,240,137,  7,131,199,  4,131,233,  4,138,  7,131,199,  1,
/* 0x1a80 */ 226, 13,131,233,  1,127,  3, 95,185,  0,  0,  0,  0,138,  7, 71,
/* 0x1a90 */  44,232, 60,  1,119,247,128, 63,  0,117,  4,139,  7,138, 95,  4,
/* 0x1aa0 */ 102,193,232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,
/* 0x1ab0 */ 137,  7,131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,176,232,
/* 0x1ac0 */ 176,233,242,174,117,  4,128, 63,  0,117,255,139,  7,102,193,232,
/* 0x1ad0 */   8,134,196,193,192, 16,134,196, 41,248,171,235,  4, 94, 95, 49,
/* 0x1ae0 */ 219,203, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,
/* 0x1af0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1b00 */   0, 45,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,
/* 0x1b10 */ 102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,
/* 0x1b20 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x1b30 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x1b40 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,
/* 0x1b50 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x1b60 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 76, 73,
/* 0x1b70 */  78, 85, 90, 86, 71, 65, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1b80 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1b90 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1ba0 */  51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1bb0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49,
/* 0x1bc0 */  32, 76, 73, 78, 85, 90, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1bd0 */  48, 48, 48, 48, 48, 57, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1be0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1bf0 */  48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1c00 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x1c10 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 76, 73, 78, 85, 90,
/* 0x1c20 */  48, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c30 */  53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1c40 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 99, 54, 32,
/* 0x1c50 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1c60 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 76, 73,
/* 0x1c70 */  78, 85, 90, 48, 48, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1c80 */  48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1c90 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1ca0 */  99, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1cb0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x1cc0 */  78, 76, 89, 10, 32, 32, 52, 32, 76, 73, 78, 85, 90, 48, 49, 48,
/* 0x1cd0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32,
/* 0x1ce0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1cf0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 52, 32, 32, 50, 42,
/* 0x1d00 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1d10 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 76, 73, 78, 85, 90,
/* 0x1d20 */  49, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d30 */  53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1d40 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 55, 32,
/* 0x1d50 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1d60 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1d70 */  10, 32, 32, 54, 32, 76, 73, 78, 85, 90, 49, 49, 48, 32, 32, 32,
/* 0x1d80 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 50,100, 32, 32, 48, 48, 48,
/* 0x1d90 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1da0 */  32, 48, 48, 48, 48, 48, 48,100, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x1db0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x1dc0 */  78, 76, 89, 10, 32, 32, 55, 32, 76, 73, 78, 85, 90, 49, 50, 48,
/* 0x1dd0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32,
/* 0x1de0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1df0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 48, 57, 32, 32, 50, 42,
/* 0x1e00 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1e10 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1e20 */  56, 32, 76, 73, 78, 85, 90, 49, 51, 48, 32, 32, 32, 32, 32, 32,
/* 0x1e30 */  48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1e40 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1e50 */  48, 48, 48, 49, 49, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1e60 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1e70 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 76, 73, 78, 85,
/* 0x1e80 */  90, 49, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1e90 */  50, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1ea0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 49, 97,
/* 0x1eb0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1ec0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1ed0 */  89, 10, 32, 49, 48, 32, 76, 73, 78, 85, 90, 49, 52, 49, 32, 32,
/* 0x1ee0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48,
/* 0x1ef0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f00 */  32, 32, 48, 48, 48, 48, 48, 49, 51, 99, 32, 32, 50, 42, 42, 48,
/* 0x1f10 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x1f20 */  79, 78, 76, 89, 10, 32, 49, 49, 32, 76, 73, 78, 85, 90, 49, 52,
/* 0x1f30 */  53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32,
/* 0x1f40 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1f50 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51,102, 32, 32, 50,
/* 0x1f60 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1f70 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1f80 */  49, 50, 32, 76, 73, 78, 85, 90, 49, 53, 48, 32, 32, 32, 32, 32,
/* 0x1f90 */  32, 48, 48, 48, 48, 48, 48, 50, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x1fa0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1fb0 */  48, 48, 48, 48, 49, 52, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1fc0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x1fd0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 76, 90, 67,
/* 0x1fe0 */  65, 76, 76, 84, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1ff0 */  48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2000 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 54,
/* 0x2010 */  57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2020 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32,
/* 0x2030 */  76, 90, 67, 75, 76, 76, 84, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2040 */  48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2050 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2060 */  48, 49, 54, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2070 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x2080 */  68, 79, 78, 76, 89, 10, 32, 49, 53, 32, 76, 66, 90, 73, 77, 65,
/* 0x2090 */  71, 69, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,101,
/* 0x20a0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x20b0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55, 50, 32, 32,
/* 0x20c0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x20d0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x20e0 */  32, 49, 54, 32, 76, 90, 73, 77, 65, 71, 69, 48, 32, 32, 32, 32,
/* 0x20f0 */  32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48,
/* 0x2100 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2110 */  48, 48, 48, 48, 48, 49, 57, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2120 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x2130 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 55, 32, 76, 90,
/* 0x2140 */  67, 85, 84, 80, 79, 73, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2150 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2160 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x2170 */  57,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2180 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 56,
/* 0x2190 */  32, 78, 50, 66, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x21a0 */  48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x21b0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x21c0 */  48, 48, 49, 57,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x21d0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x21e0 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 57, 32, 78, 50, 66, 70, 65,
/* 0x21f0 */  83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2200 */  50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2210 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 97, 50, 32,
/* 0x2220 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2230 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2240 */  10, 32, 50, 48, 32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 32, 32,
/* 0x2250 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48,
/* 0x2260 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2270 */  32, 48, 48, 48, 48, 48, 49, 97, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x2280 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x2290 */  78, 76, 89, 10, 32, 50, 49, 32, 78, 50, 66, 68, 69, 67, 49, 48,
/* 0x22a0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32,
/* 0x22b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x22c0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 97, 97, 32, 32, 50, 42,
/* 0x22d0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x22e0 */  65, 68, 79, 78, 76, 89, 10, 32, 50, 50, 32, 78, 50, 66, 83, 77,
/* 0x22f0 */  65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2300 */  53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2310 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 98, 53, 32,
/* 0x2320 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2330 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2340 */  10, 32, 50, 51, 32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 32, 32,
/* 0x2350 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48,
/* 0x2360 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2370 */  32, 48, 48, 48, 48, 48, 49, 98, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x2380 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x2390 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 52, 32, 78,
/* 0x23a0 */  50, 66, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x23b0 */  48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x23c0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x23d0 */  49, 99, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x23e0 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,
/* 0x23f0 */  53, 32, 78, 50, 66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32,
/* 0x2400 */  48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2410 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2420 */  48, 48, 48, 49,100, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2430 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2440 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 54, 32, 78, 50, 66, 70,
/* 0x2450 */  65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2460 */  48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2470 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,100,100,
/* 0x2480 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2490 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x24a0 */  89, 10, 32, 50, 55, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 32,
/* 0x24b0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51,101, 32, 32, 48, 48,
/* 0x24c0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24d0 */  32, 32, 48, 48, 48, 48, 48, 49,101, 99, 32, 32, 50, 42, 42, 48,
/* 0x24e0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x24f0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 56, 32,
/* 0x2500 */  78, 50, 66, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2510 */  48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2520 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2530 */  48, 50, 50, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2540 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x2550 */  68, 79, 78, 76, 89, 10, 32, 50, 57, 32, 78, 50, 66, 70, 65, 83,
/* 0x2560 */  52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102,
/* 0x2570 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2580 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 51, 55, 32, 32,
/* 0x2590 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x25a0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x25b0 */  32, 51, 48, 32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 32, 32, 32,
/* 0x25c0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,
/* 0x25d0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x25e0 */  48, 48, 48, 48, 48, 50, 52, 54, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x25f0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2600 */  76, 89, 10, 32, 51, 49, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32,
/* 0x2610 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48,
/* 0x2620 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2630 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 52, 56, 32, 32, 50, 42, 42,
/* 0x2640 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x2650 */  68, 79, 78, 76, 89, 10, 32, 51, 50, 32, 78, 50, 66, 68, 69, 67,
/* 0x2660 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57,
/* 0x2670 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2680 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 52, 98, 32, 32,
/* 0x2690 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x26a0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 51, 32, 78, 50, 66,
/* 0x26b0 */  83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x26c0 */  48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x26d0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 53,
/* 0x26e0 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x26f0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2700 */  76, 89, 10, 32, 51, 52, 32, 78, 50, 66, 70, 65, 83, 54, 48, 32,
/* 0x2710 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 57, 32, 32, 48,
/* 0x2720 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2730 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 54, 48, 32, 32, 50, 42, 42,
/* 0x2740 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x2750 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 53,
/* 0x2760 */  32, 78, 50, 66, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x2770 */  48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2780 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2790 */  48, 48, 50, 55, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x27a0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x27b0 */  65, 68, 79, 78, 76, 89, 10, 32, 51, 54, 32, 78, 50, 66, 68, 69,
/* 0x27c0 */  67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x27d0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x27e0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 56,102, 32,
/* 0x27f0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2800 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 55, 32, 78, 50,
/* 0x2810 */  68, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2820 */  48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2830 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,
/* 0x2840 */  56,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2850 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2860 */  78, 76, 89, 10, 32, 51, 56, 32, 78, 50, 68, 70, 65, 83, 49, 48,
/* 0x2870 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x2880 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2890 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 57, 50, 32, 32, 50, 42,
/* 0x28a0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x28b0 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,
/* 0x28c0 */  57, 32, 78, 50, 68, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32,
/* 0x28d0 */  48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x28e0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x28f0 */  48, 48, 48, 50, 57, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2900 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2910 */  10, 32, 52, 48, 32, 78, 50, 68, 68, 69, 67, 49, 48, 32, 32, 32,
/* 0x2920 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48,
/* 0x2930 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2940 */  32, 48, 48, 48, 48, 48, 50, 57, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x2950 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x2960 */  78, 76, 89, 10, 32, 52, 49, 32, 78, 50, 68, 83, 77, 65, 50, 48,
/* 0x2970 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32,
/* 0x2980 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2990 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 97, 53, 32, 32, 50, 42,
/* 0x29a0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x29b0 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52,
/* 0x29c0 */  50, 32, 78, 50, 68, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32,
/* 0x29d0 */  48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x29e0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x29f0 */  48, 48, 48, 50, 97, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2a00 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2a10 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 51, 32, 78, 50, 68, 68,
/* 0x2a20 */  69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2a30 */  48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2a40 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 98, 51,
/* 0x2a50 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2a60 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 52, 32, 78,
/* 0x2a70 */  50, 68, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2a80 */  48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2a90 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2aa0 */  50, 99, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2ab0 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2ac0 */  79, 78, 76, 89, 10, 32, 52, 53, 32, 78, 50, 68, 70, 65, 83, 51,
/* 0x2ad0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32,
/* 0x2ae0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2af0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 99,100, 32, 32, 50,
/* 0x2b00 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2b10 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2b20 */  52, 54, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32,
/* 0x2b30 */  32, 48, 48, 48, 48, 48, 48, 53, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x2b40 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2b50 */  48, 48, 48, 48, 50,100, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2b60 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2b70 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 55, 32, 78, 50, 68,
/* 0x2b80 */  83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2b90 */  48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2ba0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 50,
/* 0x2bb0 */ 101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2bc0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2bd0 */  76, 89, 10, 32, 52, 56, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32,
/* 0x2be0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48,
/* 0x2bf0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c00 */  48, 32, 32, 48, 48, 48, 48, 48, 51, 51, 98, 32, 32, 50, 42, 42,
/* 0x2c10 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x2c20 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 57,
/* 0x2c30 */  32, 78, 50, 68, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2c40 */  48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c50 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2c60 */  48, 48, 51, 52, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2c70 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2c80 */  32, 53, 48, 32, 78, 50, 68, 70, 65, 83, 53, 48, 32, 32, 32, 32,
/* 0x2c90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48,
/* 0x2ca0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2cb0 */  48, 48, 48, 48, 48, 51, 52, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2cc0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2cd0 */  76, 89, 10, 32, 53, 49, 32, 78, 50, 68, 68, 69, 67, 53, 48, 32,
/* 0x2ce0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48,
/* 0x2cf0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d00 */  48, 32, 32, 48, 48, 48, 48, 48, 51, 52,102, 32, 32, 50, 42, 42,
/* 0x2d10 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x2d20 */  68, 79, 78, 76, 89, 10, 32, 53, 50, 32, 78, 50, 68, 83, 77, 65,
/* 0x2d30 */  54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x2d40 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2d50 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 53, 56, 32, 32,
/* 0x2d60 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2d70 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2d80 */  32, 53, 51, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32, 32, 32, 32,
/* 0x2d90 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48, 48,
/* 0x2da0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2db0 */  48, 48, 48, 48, 48, 51, 54, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2dc0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x2dd0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 52, 32, 78, 50,
/* 0x2de0 */  68, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2df0 */  48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2e00 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,
/* 0x2e10 */  55,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2e20 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2e30 */  78, 76, 89, 10, 32, 53, 53, 32, 78, 50, 68, 68, 69, 67, 54, 48,
/* 0x2e40 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2e50 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2e60 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 57, 51, 32, 32, 50, 42,
/* 0x2e70 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2e80 */  65, 68, 79, 78, 76, 89, 10, 32, 53, 54, 32, 78, 50, 69, 83, 77,
/* 0x2e90 */  65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ea0 */  51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2eb0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 57, 51, 32,
/* 0x2ec0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2ed0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2ee0 */  10, 32, 53, 55, 32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 32, 32,
/* 0x2ef0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,
/* 0x2f00 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2f10 */  32, 48, 48, 48, 48, 48, 51, 57, 54, 32, 32, 50, 42, 42, 48, 32,
/* 0x2f20 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x2f30 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 56, 32, 78,
/* 0x2f40 */  50, 69, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2f50 */  48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2f60 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2f70 */  51, 57, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2f80 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53,
/* 0x2f90 */  57, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32,
/* 0x2fa0 */  48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2fb0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2fc0 */  48, 48, 48, 51, 57,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2fd0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2fe0 */  10, 32, 54, 48, 32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 32, 32,
/* 0x2ff0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48,
/* 0x3000 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3010 */  32, 48, 48, 48, 48, 48, 51, 97, 57, 32, 32, 50, 42, 42, 48, 32,
/* 0x3020 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x3030 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 49, 32, 78,
/* 0x3040 */  50, 69, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x3050 */  48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3060 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x3070 */  51, 97,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3080 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x3090 */  79, 78, 76, 89, 10, 32, 54, 50, 32, 78, 50, 69, 68, 69, 67, 50,
/* 0x30a0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32,
/* 0x30b0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x30c0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 98, 55, 32, 32, 50,
/* 0x30d0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x30e0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 51, 32, 78, 50, 69, 83,
/* 0x30f0 */  77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3100 */  48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3110 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 99, 52,
/* 0x3120 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3130 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x3140 */  89, 10, 32, 54, 52, 32, 78, 50, 69, 70, 65, 83, 51, 48, 32, 32,
/* 0x3150 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48,
/* 0x3160 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3170 */  32, 32, 48, 48, 48, 48, 48, 51,100, 49, 32, 32, 50, 42, 42, 48,
/* 0x3180 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x3190 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 53, 32,
/* 0x31a0 */  78, 50, 69, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x31b0 */  48, 48, 48, 48, 53,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x31c0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x31d0 */  48, 51,101, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x31e0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x31f0 */  68, 79, 78, 76, 89, 10, 32, 54, 54, 32, 78, 50, 69, 83, 77, 65,
/* 0x3200 */  52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100,
/* 0x3210 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3220 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 51,102, 32, 32,
/* 0x3230 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3240 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3250 */  32, 54, 55, 32, 78, 50, 69, 70, 65, 83, 52, 48, 32, 32, 32, 32,
/* 0x3260 */  32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48,
/* 0x3270 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3280 */  48, 48, 48, 48, 48, 52, 52, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3290 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x32a0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 56, 32, 78, 50,
/* 0x32b0 */  69, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x32c0 */  48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x32d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52,
/* 0x32e0 */  53, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x32f0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 57,
/* 0x3300 */  32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x3310 */  48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3320 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3330 */  48, 48, 52, 53,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3340 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3350 */  32, 55, 48, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 32, 32, 32,
/* 0x3360 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48,
/* 0x3370 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3380 */  48, 48, 48, 48, 48, 52, 54, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3390 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x33a0 */  76, 89, 10, 32, 55, 49, 32, 78, 50, 69, 83, 77, 65, 54, 48, 32,
/* 0x33b0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32, 48,
/* 0x33c0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x33d0 */  48, 32, 32, 48, 48, 48, 48, 48, 52, 54, 57, 32, 32, 50, 42, 42,
/* 0x33e0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x33f0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 50,
/* 0x3400 */  32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x3410 */  48, 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3420 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3430 */  48, 48, 52, 55, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3440 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x3450 */  65, 68, 79, 78, 76, 89, 10, 32, 55, 51, 32, 78, 50, 69, 70, 65,
/* 0x3460 */  83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,
/* 0x3470 */  54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3480 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 56,101, 32,
/* 0x3490 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x34a0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x34b0 */  10, 32, 55, 52, 32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 32, 32,
/* 0x34c0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x34d0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x34e0 */  32, 48, 48, 48, 48, 48, 52, 97, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x34f0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x3500 */  78, 76, 89, 10, 32, 55, 53, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3510 */  48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,101, 32, 32,
/* 0x3520 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3530 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 97, 52, 32, 32, 50, 42,
/* 0x3540 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x3550 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55,
/* 0x3560 */  54, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32,
/* 0x3570 */  48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3580 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3590 */  48, 48, 48, 52,100, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x35a0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x35b0 */  10, 32, 55, 55, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32,
/* 0x35c0 */  32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32, 48, 48, 48,
/* 0x35d0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x35e0 */  32, 48, 48, 48, 48, 48, 53, 49, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x35f0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x3600 */  78, 76, 89, 10, 32, 55, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3610 */  50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32,
/* 0x3620 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3630 */  48, 48, 32, 32, 48, 48, 48, 48, 48,102, 97, 48, 32, 32, 50, 42,
/* 0x3640 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x3650 */  65, 68, 79, 78, 76, 89, 10, 32, 55, 57, 32, 76, 90, 77, 65, 95,
/* 0x3660 */  68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,
/* 0x3670 */  97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3680 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 50, 54, 32,
/* 0x3690 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x36a0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 48, 32, 76, 90,
/* 0x36b0 */  67, 75, 76, 76, 84, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x36c0 */  48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x36d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,
/* 0x36e0 */  52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x36f0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 49,
/* 0x3700 */  32, 99,116,111,107, 51, 50, 46, 48, 48, 32, 32, 32, 32, 32, 48,
/* 0x3710 */  48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3720 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3730 */  48, 49, 97, 52, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3740 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x3750 */  65, 68, 79, 78, 76, 89, 10, 32, 56, 50, 32, 99,116,111,107, 51,
/* 0x3760 */  50, 46, 49, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3770 */ 101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3780 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 52, 99, 32,
/* 0x3790 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x37a0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x37b0 */  10, 32, 56, 51, 32, 99,116,111,107, 51, 50, 46, 50, 48, 32, 32,
/* 0x37c0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 49, 32, 32, 48, 48, 48,
/* 0x37d0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x37e0 */  32, 48, 48, 48, 48, 49, 97, 53, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x37f0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x3800 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 52, 32, 99,
/* 0x3810 */ 116,111,107, 51, 50, 46, 51, 48, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x3820 */  48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3830 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x3840 */  97, 55, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3850 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x3860 */  79, 78, 76, 89, 10, 32, 56, 53, 32, 99,116,111,107, 51, 50, 46,
/* 0x3870 */  52, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x3880 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x3890 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 56, 50, 32, 32, 50,
/* 0x38a0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x38b0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x38c0 */  56, 54, 32, 76, 90, 67, 65, 76, 76, 84, 57, 32, 32, 32, 32, 32,
/* 0x38d0 */  32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48,
/* 0x38e0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x38f0 */  48, 48, 48, 49, 97, 56, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3900 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x3910 */  89, 10, 32, 56, 55, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 32,
/* 0x3920 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48,
/* 0x3930 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3940 */  32, 32, 48, 48, 48, 48, 49, 97, 56, 56, 32, 32, 50, 42, 42, 48,
/* 0x3950 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x3960 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 56, 32,
/* 0x3970 */  67, 84, 67, 76, 69, 86, 69, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3980 */  48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3990 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x39a0 */  49, 97, 57, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x39b0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x39c0 */  68, 79, 78, 76, 89, 10, 32, 56, 57, 32, 67, 65, 76, 76, 84, 82,
/* 0x39d0 */  48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x39e0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x39f0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 57, 98, 32, 32,
/* 0x3a00 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3a10 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 48, 32, 67, 84, 66,
/* 0x3a20 */  83, 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3a30 */  48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3a40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 97,
/* 0x3a50 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3a60 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 49, 32,
/* 0x3a70 */  67, 84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3a80 */  48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3aa0 */  49, 97, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3ab0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x3ac0 */  57, 50, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32, 32,
/* 0x3ad0 */  32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48,
/* 0x3ae0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3af0 */  48, 48, 48, 49, 97, 97, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3b00 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x3b10 */  89, 10, 32, 57, 51, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32,
/* 0x3b20 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48,
/* 0x3b30 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b40 */  32, 32, 48, 48, 48, 48, 49, 97, 97, 98, 32, 32, 50, 42, 42, 48,
/* 0x3b50 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x3b60 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 52, 32,
/* 0x3b70 */  67, 65, 76, 76, 84, 82, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3b80 */  48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3ba0 */  49, 97, 98, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3bb0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x3bc0 */  68, 79, 78, 76, 89, 10, 32, 57, 53, 32, 67, 65, 76, 76, 84, 82,
/* 0x3bd0 */  69, 56, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x3be0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3bf0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 98,101, 32, 32,
/* 0x3c00 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3c10 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 54, 32, 67, 65, 76,
/* 0x3c20 */  76, 84, 82, 69, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3c30 */  48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3c40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 99,
/* 0x3c50 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3c60 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 55, 32,
/* 0x3c70 */  67, 65, 76, 76, 84, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3c80 */  48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3ca0 */  49, 97, 99, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3cb0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x3cc0 */  68, 79, 78, 76, 89, 10, 32, 57, 56, 32, 67, 84, 67, 76, 69, 86,
/* 0x3cd0 */  69, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x3ce0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3cf0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 99, 54, 32, 32,
/* 0x3d00 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3d10 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3d20 */  32, 57, 57, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32,
/* 0x3d30 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,
/* 0x3d40 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3d50 */  48, 48, 48, 48, 49, 97, 99, 98, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3d60 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3d70 */  76, 89, 10, 49, 48, 48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32,
/* 0x3d80 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48,
/* 0x3d90 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3da0 */  48, 32, 32, 48, 48, 48, 48, 49, 97, 99,100, 32, 32, 50, 42, 42,
/* 0x3db0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3dc0 */  68, 79, 78, 76, 89, 10, 49, 48, 49, 32, 67, 84, 66, 82, 79, 82,
/* 0x3dd0 */  49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x3de0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3df0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,100, 49, 32, 32,
/* 0x3e00 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3e10 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 50, 32, 67, 84, 66,
/* 0x3e20 */  83, 87, 65, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3e30 */  48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3e40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,100,
/* 0x3e50 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3e60 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 51, 32,
/* 0x3e70 */  67, 65, 76, 76, 84, 82, 49, 51, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3e80 */  48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3ea0 */  49, 97,100, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3eb0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x3ec0 */  68, 79, 78, 76, 89, 10, 49, 48, 52, 32, 76, 73, 78, 85, 90, 57,
/* 0x3ed0 */  57, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x3ee0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3ef0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,100,100, 32, 32,
/* 0x3f00 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3f10 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 53, 32, 85, 80, 88,
/* 0x3f20 */  49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3f30 */  48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3f40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,101,
/* 0x3f50 */  50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3f60 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66,
/* 0x3f70 */  79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48,
/* 0x3f80 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77,
/* 0x3f90 */  65, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,
/* 0x3fa0 */  83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3fb0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49,  9,
/* 0x3fc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 49,
/* 0x3fd0 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3fe0 */ 100, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48,
/* 0x3ff0 */  48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x4000 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4010 */  50, 66, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4020 */  32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4030 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69,
/* 0x4040 */  67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,
/* 0x4050 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4060 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48,  9,
/* 0x4070 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 53,
/* 0x4080 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4090 */ 100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48,
/* 0x40a0 */  48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x40b0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x40c0 */  50, 66, 68, 69, 67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40d0 */  32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x40e0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77,
/* 0x40f0 */  65, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,
/* 0x4100 */  83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4110 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49,  9,
/* 0x4120 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 49,
/* 0x4130 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4140 */ 100, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48,
/* 0x4150 */  48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x4160 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4170 */  50, 68, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4180 */  32, 78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4190 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69,
/* 0x41a0 */  67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,
/* 0x41b0 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x41c0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48,  9,
/* 0x41d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 53,
/* 0x41e0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x41f0 */ 100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48,
/* 0x4200 */  48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x4210 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4220 */  50, 68, 68, 69, 67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4230 */  32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4240 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77,
/* 0x4250 */  65, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,
/* 0x4260 */  83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4270 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49,  9,
/* 0x4280 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49,
/* 0x4290 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x42a0 */ 100, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48,
/* 0x42b0 */  48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x42c0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x42d0 */  50, 69, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x42e0 */  32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x42f0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69,
/* 0x4300 */  67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,
/* 0x4310 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4320 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48,  9,
/* 0x4330 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 53,
/* 0x4340 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4350 */ 100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48,
/* 0x4360 */  48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x4370 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4380 */  50, 69, 68, 69, 67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4390 */  32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x43a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51,
/* 0x43b0 */  50, 46, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,
/* 0x43c0 */ 111,107, 51, 50, 46, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43d0 */  32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46,
/* 0x43e0 */  49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107,
/* 0x43f0 */  51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4400 */  32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48,
/* 0x4410 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50,
/* 0x4420 */  46, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4430 */  32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48,  9, 48,
/* 0x4440 */  48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 52,
/* 0x4450 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4460 */ 100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48,  9, 48, 48, 48, 48,
/* 0x4470 */  48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 48, 48,
/* 0x4480 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x4490 */  65, 76, 76, 84, 82, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44a0 */  32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x44b0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x44c0 */  82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76,
/* 0x44d0 */  76, 84, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x44e0 */  32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 51,  9,
/* 0x44f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x4500 */  51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4510 */ 100, 32, 32, 76, 73, 78, 85, 90, 86, 71, 65,  9, 48, 48, 48, 48,
/* 0x4520 */  48, 48, 48, 48, 32, 76, 73, 78, 85, 90, 86, 71, 65, 10, 48, 48,
/* 0x4530 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x4540 */  73, 78, 85, 90, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4550 */  32, 76, 73, 78, 85, 90, 48, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4560 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90,
/* 0x4570 */  48, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78,
/* 0x4580 */  85, 90, 48, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4590 */  32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90, 48, 48, 53,  9,
/* 0x45a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 90, 48, 48,
/* 0x45b0 */  53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x45c0 */ 100, 32, 32, 76, 73, 78, 85, 90, 48, 49, 48,  9, 48, 48, 48, 48,
/* 0x45d0 */  48, 48, 48, 48, 32, 76, 73, 78, 85, 90, 48, 49, 48, 10, 48, 48,
/* 0x45e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x45f0 */  73, 78, 85, 90, 49, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4600 */  32, 76, 73, 78, 85, 90, 49, 48, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x4610 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90,
/* 0x4620 */  49, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78,
/* 0x4630 */  85, 90, 49, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4640 */  32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90, 49, 50, 48,  9,
/* 0x4650 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 90, 49, 50,
/* 0x4660 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4670 */ 100, 32, 32, 76, 73, 78, 85, 90, 49, 51, 48,  9, 48, 48, 48, 48,
/* 0x4680 */  48, 48, 48, 48, 32, 76, 73, 78, 85, 90, 49, 51, 48, 10, 48, 48,
/* 0x4690 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x46a0 */  73, 78, 85, 90, 49, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x46b0 */  32, 76, 73, 78, 85, 90, 49, 52, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x46c0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90,
/* 0x46d0 */  49, 52, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78,
/* 0x46e0 */  85, 90, 49, 52, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x46f0 */  32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90, 49, 52, 53,  9,
/* 0x4700 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 90, 49, 52,
/* 0x4710 */  53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4720 */ 100, 32, 32, 76, 73, 78, 85, 90, 49, 53, 48,  9, 48, 48, 48, 48,
/* 0x4730 */  48, 48, 48, 48, 32, 76, 73, 78, 85, 90, 49, 53, 48, 10, 48, 48,
/* 0x4740 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x4750 */  90, 67, 65, 76, 76, 84, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4760 */  32, 76, 90, 67, 65, 76, 76, 84, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x4770 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 67, 75, 76,
/* 0x4780 */  76, 84, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 67,
/* 0x4790 */  75, 76, 76, 84, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x47a0 */  32, 32, 32, 32,100, 32, 32, 76, 66, 90, 73, 77, 65, 71, 69,  9,
/* 0x47b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 66, 90, 73, 77, 65, 71,
/* 0x47c0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x47d0 */ 100, 32, 32, 76, 90, 73, 77, 65, 71, 69, 48,  9, 48, 48, 48, 48,
/* 0x47e0 */  48, 48, 48, 48, 32, 76, 90, 73, 77, 65, 71, 69, 48, 10, 48, 48,
/* 0x47f0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x4800 */  90, 67, 85, 84, 80, 79, 73,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4810 */  32, 76, 90, 67, 85, 84, 80, 79, 73, 10, 48, 48, 48, 48, 48, 48,
/* 0x4820 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,
/* 0x4830 */  83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,
/* 0x4840 */  70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4850 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 50, 48,  9,
/* 0x4860 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 50,
/* 0x4870 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4880 */ 100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48,  9, 48, 48, 48, 48,
/* 0x4890 */  48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 10, 48, 48,
/* 0x48a0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x48b0 */  50, 66, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x48c0 */  32, 78, 50, 66, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x48d0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,
/* 0x48e0 */  83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,
/* 0x48f0 */  70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4900 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 52, 48,  9,
/* 0x4910 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 52,
/* 0x4920 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4930 */ 100, 32, 32, 78, 50, 66, 70, 65, 83, 52, 48,  9, 48, 48, 48, 48,
/* 0x4940 */  48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48, 10, 48, 48,
/* 0x4950 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4960 */  50, 66, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4970 */  32, 78, 50, 66, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4980 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,
/* 0x4990 */  83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,
/* 0x49a0 */  70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x49b0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 54, 48,  9,
/* 0x49c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 54,
/* 0x49d0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x49e0 */ 100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 48,  9, 48, 48, 48, 48,
/* 0x49f0 */  48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 54, 48, 10, 48, 48,
/* 0x4a00 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4a10 */  50, 68, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a20 */  32, 78, 50, 68, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4a30 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77,
/* 0x4a40 */  65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,
/* 0x4a50 */  83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4a60 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 50, 48,  9,
/* 0x4a70 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 50,
/* 0x4a80 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4a90 */ 100, 32, 32, 78, 50, 68, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48,
/* 0x4aa0 */  48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 51, 48, 10, 48, 48,
/* 0x4ab0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4ac0 */  50, 68, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ad0 */  32, 78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4ae0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77,
/* 0x4af0 */  65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,
/* 0x4b00 */  83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4b10 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 52, 48,  9,
/* 0x4b20 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 52,
/* 0x4b30 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4b40 */ 100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48,
/* 0x4b50 */  48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 53, 48, 10, 48, 48,
/* 0x4b60 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4b70 */  50, 68, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b80 */  32, 78, 50, 68, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4b90 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77,
/* 0x4ba0 */  65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,
/* 0x4bb0 */  83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4bc0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 48,  9,
/* 0x4bd0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 54,
/* 0x4be0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4bf0 */ 100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48,
/* 0x4c00 */  48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48, 10, 48, 48,
/* 0x4c10 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4c20 */  50, 69, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c30 */  32, 78, 50, 69, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4c40 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65,
/* 0x4c50 */  83, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,
/* 0x4c60 */  70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4c70 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 51, 48,  9,
/* 0x4c80 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 51,
/* 0x4c90 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4ca0 */ 100, 32, 32, 78, 50, 69, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48,
/* 0x4cb0 */  48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 51, 48, 10, 48, 48,
/* 0x4cc0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4cd0 */  50, 69, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ce0 */  32, 78, 50, 69, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4cf0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65,
/* 0x4d00 */  83, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,
/* 0x4d10 */  70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4d20 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 53, 48,  9,
/* 0x4d30 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 53,
/* 0x4d40 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4d50 */ 100, 32, 32, 78, 50, 69, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48,
/* 0x4d60 */  48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 53, 48, 10, 48, 48,
/* 0x4d70 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4d80 */  50, 69, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d90 */  32, 78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4da0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65,
/* 0x4db0 */  83, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,
/* 0x4dc0 */  70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4dd0 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48,
/* 0x4de0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,
/* 0x4df0 */  68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4e00 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x4e10 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,
/* 0x4e20 */  69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4e30 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x4e40 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,
/* 0x4e50 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4e60 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x4e70 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,
/* 0x4e80 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4e90 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x4ea0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,
/* 0x4eb0 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4ec0 */  32, 32, 32, 32,100, 32, 32, 76, 90, 67, 75, 76, 76, 84, 57,  9,
/* 0x4ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 67, 75, 76, 76, 84,
/* 0x4ee0 */  57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4ef0 */ 100, 32, 32, 99,116,111,107, 51, 50, 46, 51, 48,  9, 48, 48, 48,
/* 0x4f00 */  48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 51, 48, 10,
/* 0x4f10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4f20 */  32, 76, 90, 67, 65, 76, 76, 84, 57,  9, 48, 48, 48, 48, 48, 48,
/* 0x4f30 */  48, 48, 32, 76, 90, 67, 65, 76, 76, 84, 57, 10, 48, 48, 48, 48,
/* 0x4f40 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67,
/* 0x4f50 */  76, 69, 86, 69, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,
/* 0x4f60 */  84, 67, 76, 69, 86, 69, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f70 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48,
/* 0x4f80 */  49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84,
/* 0x4f90 */  82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4fa0 */  32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 48, 49,  9, 48, 48,
/* 0x4fb0 */  48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 72, 82, 48, 49, 10,
/* 0x4fc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4fd0 */  32, 67, 84, 66, 82, 79, 82, 48, 49,  9, 48, 48, 48, 48, 48, 48,
/* 0x4fe0 */  48, 48, 32, 67, 84, 66, 82, 79, 82, 48, 49, 10, 48, 48, 48, 48,
/* 0x4ff0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66,
/* 0x5000 */  83, 87, 65, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,
/* 0x5010 */  84, 66, 83, 87, 65, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5020 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48,
/* 0x5030 */  50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84,
/* 0x5040 */  82, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5050 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69, 56,  9, 48, 48,
/* 0x5060 */  48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 69, 56, 10,
/* 0x5070 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5080 */  32, 67, 65, 76, 76, 84, 82, 69, 57,  9, 48, 48, 48, 48, 48, 48,
/* 0x5090 */  48, 48, 32, 67, 65, 76, 76, 84, 82, 69, 57, 10, 48, 48, 48, 48,
/* 0x50a0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67,
/* 0x50b0 */  76, 69, 86, 69, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,
/* 0x50c0 */  84, 67, 76, 69, 86, 69, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x50d0 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x50e0 */  50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84,
/* 0x50f0 */  82, 49, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5100 */  32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 49, 49,  9, 48, 48,
/* 0x5110 */  48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 10,
/* 0x5120 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5130 */  32, 67, 84, 66, 82, 79, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48,
/* 0x5140 */  48, 48, 32, 67, 84, 66, 82, 79, 82, 49, 49, 10, 48, 48, 48, 48,
/* 0x5150 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66,
/* 0x5160 */  83, 87, 65, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,
/* 0x5170 */  84, 66, 83, 87, 65, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5180 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90, 57, 57,
/* 0x5190 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 90,
/* 0x51a0 */  57, 57, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x51b0 */  32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48,
/* 0x51c0 */  48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10,
/* 0x51d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x51e0 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x51f0 */ 115,116, 97, 99,107, 95,111,102,102,115,101,116, 10, 48, 48, 48,
/* 0x5200 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x5210 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,
/* 0x5220 */ 103,105,110, 97,108, 95,101,110,116,114,121, 10, 48, 48, 48, 48,
/* 0x5230 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x5240 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,109,112,
/* 0x5250 */ 114,101,115,115,101,100, 95,108,101,110,103,116,104, 10, 48, 48,
/* 0x5260 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x5270 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,101,
/* 0x5280 */ 103, 95, 99,111,110,102,105,103, 95,112,104,121,115,105, 99, 97,
/* 0x5290 */ 108, 95, 97,108,105,103,110, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x52a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x52b0 */  48, 48, 48, 48, 48, 48, 48, 32,108,111, 97,100, 95,112,104,121,
/* 0x52c0 */ 115,105, 99, 97,108, 95, 97,100,100,114,101,115,115, 10, 48, 48,
/* 0x52d0 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x52e0 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,117,110,
/* 0x52f0 */  99, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5300 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x5310 */  48, 48, 48, 48, 48, 48, 48, 48, 32,100,101, 99, 95,111,102,102,
/* 0x5320 */ 115,101,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x5330 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x5340 */  48, 48, 48, 32,117,110, 99, 95,111,102,102,115,101,116, 10, 48,
/* 0x5350 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5360 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,
/* 0x5370 */ 101,103, 95,108,101,110,103,116,104, 95,109,111,118, 10, 48, 48,
/* 0x5380 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x5390 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,
/* 0x53a0 */ 108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x53b0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x53c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,101,114, 95,
/* 0x53d0 */ 108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x53e0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x53f0 */  48, 48, 48, 48, 48, 48, 32,110,101,103, 95,112, 97,103,101, 95,
/* 0x5400 */ 111,102,102,115,101,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5410 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x5420 */  48, 48, 48, 48, 48, 48, 32, 99,111,112,121, 95,115,111,117,114,
/* 0x5430 */  99,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x5440 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x5450 */  48, 48, 32, 99,111,112,121, 95,100,101,115,116, 10, 48, 48, 48,
/* 0x5460 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x5470 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,119,111,114,
/* 0x5480 */ 100,115, 95,116,111, 95, 99,111,112,121, 10, 48, 48, 48, 48, 48,
/* 0x5490 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x54a0 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,114, 99, 95,102,
/* 0x54b0 */ 111,114, 95,100,101, 99,111,109,112,114,101,115,115,111,114, 10,
/* 0x54c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x54d0 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x54e0 */ 100,101, 99,111,109,112,114,101,115,115,111,114, 10, 48, 48, 48,
/* 0x54f0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x5500 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109,
/* 0x5510 */  97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,116, 10, 48,
/* 0x5520 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5530 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x5540 */ 122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x5550 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x5560 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95, 99,
/* 0x5570 */  95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x5580 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x5590 */  48, 48, 48, 48, 32,108,122,109, 97, 95,112,114,111,112,101,114,
/* 0x55a0 */ 116,105,101,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x55b0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73,
/* 0x55c0 */  78, 85, 90, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x55d0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x55e0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x55f0 */  48,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x5600 */  32, 32, 32, 32, 32,115,116, 97, 99,107, 95,111,102,102,115,101,
/* 0x5610 */ 116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5620 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 90,
/* 0x5630 */  48, 48, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x5640 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5650 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x5660 */  82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5670 */  32, 32,111,114,105,103,105,110, 97,108, 95,101,110,116,114,121,
/* 0x5680 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5690 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 90, 49,
/* 0x56a0 */  48, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x56b0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x56c0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x56d0 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x56e0 */  32, 99,111,109,112,114,101,115,115,101,100, 95,108,101,110,103,
/* 0x56f0 */ 116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5700 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85,
/* 0x5710 */  90, 49, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5720 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5730 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x5740 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x5750 */  32, 32, 32,110,101,103, 95, 99,111,110,102,105,103, 95,112,104,
/* 0x5760 */ 121,115,105, 99, 97,108, 95, 97,108,105,103,110, 10, 10, 82, 69,
/* 0x5770 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5780 */  32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 90, 49, 51, 48, 93, 58,
/* 0x5790 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x57a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x57b0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x57c0 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,111, 97,
/* 0x57d0 */ 100, 95,112,104,121,115,105, 99, 97,108, 95, 97,100,100,114,101,
/* 0x57e0 */ 115,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x57f0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85,
/* 0x5800 */  90, 49, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5810 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5820 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x5830 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x5840 */  32, 32, 32,117,110, 99, 95,108,101,110,103,116,104, 10, 48, 48,
/* 0x5850 */  48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x5860 */  32, 32, 32, 32, 32, 32, 32, 32, 32,100,101, 99, 95,111,102,102,
/* 0x5870 */ 115,101,116, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51,
/* 0x5880 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,117,
/* 0x5890 */ 110, 99, 95,111,102,102,115,101,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x58a0 */  49, 98, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x58b0 */  32, 32, 32, 32, 32,110,101,103, 95,108,101,110,103,116,104, 95,
/* 0x58c0 */ 109,111,118, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x58d0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78,
/* 0x58e0 */  85, 90, 49, 52, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x58f0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5900 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5910 */  50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5920 */  32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48,
/* 0x5930 */  48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x5940 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114,
/* 0x5950 */  95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5960 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5970 */  91, 76, 73, 78, 85, 90, 49, 53, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5980 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5990 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x59a0 */  48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,
/* 0x59b0 */  32, 32, 32, 32, 32, 32, 32, 32,108,111, 97,100, 95,112,104,121,
/* 0x59c0 */ 115,105, 99, 97,108, 95, 97,100,100,114,101,115,115, 10, 48, 48,
/* 0x59d0 */  48, 48, 48, 48, 49, 51, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x59e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,110,101,103, 95,112, 97,103,
/* 0x59f0 */ 101, 95,111,102,102,115,101,116, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x5a00 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x5a10 */  32, 91, 76, 90, 67, 75, 76, 76, 84, 49, 93, 58, 10, 79, 70, 70,
/* 0x5a20 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x5a30 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x5a40 */  48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32,
/* 0x5a50 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x5a60 */  99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51,
/* 0x5a70 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x5a80 */ 105,108,116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69,
/* 0x5a90 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5aa0 */  32, 70, 79, 82, 32, 91, 76, 66, 90, 73, 77, 65, 71, 69, 93, 58,
/* 0x5ab0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5ac0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5ad0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x5ae0 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,
/* 0x5af0 */ 121, 95,115,111,117,114, 99,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5b00 */  54, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5b10 */  32, 32, 32, 32, 99,111,112,121, 95,100,101,115,116, 10, 48, 48,
/* 0x5b20 */  48, 48, 48, 48, 48, 98, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x5b30 */  32, 32, 32, 32, 32, 32, 32, 32, 32,119,111,114,100,115, 95,116,
/* 0x5b40 */ 111, 95, 99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32,
/* 0x5b50 */  82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5b60 */  32, 32,115,114, 99, 95,102,111,114, 95,100,101, 99,111,109,112,
/* 0x5b70 */ 114,101,115,115,111,114, 10, 48, 48, 48, 48, 48, 48, 49, 97, 32,
/* 0x5b80 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5b90 */  32, 32,100,101, 99,111,109,112,114,101,115,115,111,114, 10, 10,
/* 0x5ba0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5bb0 */  68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 73, 77, 65, 71, 69, 48,
/* 0x5bc0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5bd0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5be0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51,
/* 0x5bf0 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,
/* 0x5c00 */ 114, 99, 95,102,111,114, 95,100,101, 99,111,109,112,114,101,115,
/* 0x5c10 */ 115,111,114, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5c20 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,
/* 0x5c30 */  83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5c40 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c50 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5c60 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5c70 */  32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x5c80 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5c90 */  32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 49, 48, 93, 58,
/* 0x5ca0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5cb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5cc0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x5cd0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,
/* 0x5ce0 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5cf0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5d00 */  50, 66, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5d10 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d20 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5d30 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5d40 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 10,
/* 0x5d50 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5d60 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 50, 48,
/* 0x5d70 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5d80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5d90 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x5da0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5db0 */  50, 66, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5dc0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5dd0 */  91, 78, 50, 66, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5de0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5df0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5e00 */  48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5e10 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48,
/* 0x5e20 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5e30 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83,
/* 0x5e40 */  51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5e50 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e60 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x5e70 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e80 */  32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x5e90 */  48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5ea0 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82,
/* 0x5eb0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5ec0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 68, 69, 67, 51, 48, 93,
/* 0x5ed0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x5ee0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x5ef0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 51, 56,
/* 0x5f00 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5f10 */  66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 50,102, 32,
/* 0x5f20 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5f30 */  32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79,
/* 0x5f40 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5f50 */  79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 52, 48, 93, 58, 10, 79,
/* 0x5f60 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5f70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5f80 */  48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5f90 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,
/* 0x5fa0 */  67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5fb0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,
/* 0x5fc0 */  70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5fd0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5fe0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5ff0 */  51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6000 */  32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x6010 */  48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6020 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,
/* 0x6030 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6040 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65,
/* 0x6050 */  54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6060 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6070 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82,
/* 0x6080 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x6090 */  32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x60a0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x60b0 */  82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70,
/* 0x60c0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x60d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x60e0 */  48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x60f0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x6100 */  54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56,
/* 0x6110 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x6120 */  66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6130 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6140 */  78, 50, 66, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6150 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6160 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6170 */  48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x6180 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10,
/* 0x6190 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x61a0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 49,
/* 0x61b0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x61c0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x61d0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x61e0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x61f0 */  78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6200 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6210 */  32, 91, 78, 50, 68, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70,
/* 0x6220 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6230 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6240 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x6250 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49,
/* 0x6260 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6270 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77,
/* 0x6280 */  65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6290 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x62a0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x62b0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x62c0 */  32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x62d0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x62e0 */  79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 50, 48, 93, 58, 10, 79,
/* 0x62f0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6300 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6310 */  48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6320 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65,
/* 0x6330 */  83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x6340 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x6350 */  83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6360 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6370 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6380 */  99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6390 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69,
/* 0x63a0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x63b0 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 51, 48, 93, 58,
/* 0x63c0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x63d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x63e0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54,
/* 0x63f0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x6400 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82,
/* 0x6410 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6420 */  32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x6430 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6440 */  82, 32, 91, 78, 50, 68, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70,
/* 0x6450 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6460 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6470 */  48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6480 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x6490 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95, 51, 56,
/* 0x64a0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x64b0 */  68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 52, 51, 32,
/* 0x64c0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x64d0 */  32, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79,
/* 0x64e0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x64f0 */  79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 52, 48, 93, 58, 10, 79,
/* 0x6500 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6510 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6520 */  48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6530 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x6540 */  67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x6550 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x6560 */  70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6570 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6580 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6590 */  51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x65a0 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x65b0 */  48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x65c0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x65d0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x65e0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65,
/* 0x65f0 */  54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6600 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6610 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82,
/* 0x6620 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x6630 */  32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x6640 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6650 */  82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70,
/* 0x6660 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6670 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6680 */  48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6690 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83,
/* 0x66a0 */  54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56,
/* 0x66b0 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x66c0 */  68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x66d0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x66e0 */  78, 50, 68, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x66f0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6700 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6710 */  48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x6720 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10,
/* 0x6730 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6740 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 49,
/* 0x6750 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6760 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6770 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x6780 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6790 */  78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x67a0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x67b0 */  32, 91, 78, 50, 69, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70,
/* 0x67c0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x67d0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x67e0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x67f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49,
/* 0x6800 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6810 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77,
/* 0x6820 */  65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6830 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6840 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x6850 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6860 */  32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x6870 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6880 */  79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 50, 48, 93, 58, 10, 79,
/* 0x6890 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x68a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x68b0 */  48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x68c0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65,
/* 0x68d0 */  83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x68e0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x68f0 */  83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6900 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6910 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6920 */  99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6930 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69,
/* 0x6940 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6950 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 51, 48, 93, 58,
/* 0x6960 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6970 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6980 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54,
/* 0x6990 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x69a0 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82,
/* 0x69b0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x69c0 */  32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x69d0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x69e0 */  82, 32, 91, 78, 50, 69, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70,
/* 0x69f0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6a00 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6a10 */  48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6a20 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,
/* 0x6a30 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56,
/* 0x6a40 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x6a50 */  69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32,
/* 0x6a60 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6a70 */  32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 10, 82, 69, 76, 79,
/* 0x6a80 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6a90 */  79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 52, 48, 93, 58, 10, 79,
/* 0x6aa0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6ab0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6ac0 */  48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6ad0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x6ae0 */  67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x6af0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x6b00 */  70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6b10 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6b20 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6b30 */  51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6b40 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x6b50 */  48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6b60 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,
/* 0x6b70 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6b80 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65,
/* 0x6b90 */  54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6ba0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6bb0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82,
/* 0x6bc0 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x6bd0 */  32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x6be0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6bf0 */  82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70,
/* 0x6c00 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6c10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6c20 */  48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6c30 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x6c40 */  54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56,
/* 0x6c50 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x6c60 */  69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6c70 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6c80 */  78, 50, 69, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6c90 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6ca0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6cb0 */  48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x6cc0 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10,
/* 0x6cd0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6ce0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69,
/* 0x6cf0 */  67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6d00 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6d10 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x6d20 */  82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6d30 */  32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,
/* 0x6d40 */ 117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 51,
/* 0x6d50 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,
/* 0x6d60 */ 122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x6d70 */  49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x6d80 */  32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10,
/* 0x6d90 */  48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x6da0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,
/* 0x6db0 */ 112,114,111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76, 79,
/* 0x6dc0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6dd0 */  79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 48, 48, 93, 58, 10,
/* 0x6de0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6df0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6e00 */  10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,
/* 0x6e10 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107,
/* 0x6e20 */  51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6e30 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,
/* 0x6e40 */ 116,111,107, 51, 50, 46, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6e50 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6e60 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6e70 */  48, 48, 48,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x6e80 */  32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48,
/* 0x6e90 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6ea0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,
/* 0x6eb0 */  46, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6ec0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6ed0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x6ee0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6ef0 */  32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48,
/* 0x6f00 */  48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x6f10 */  32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48,
/* 0x6f20 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6f30 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,
/* 0x6f40 */  46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6f50 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6f60 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32,
/* 0x6f70 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6f80 */  32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 10, 82, 69, 76,
/* 0x6f90 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6fa0 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 52, 48, 93, 58,
/* 0x6fb0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6fc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6fd0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54,
/* 0x6fe0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x6ff0 */ 107, 51, 50, 46, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x7000 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x7010 */  67, 65, 76, 76, 84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7020 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7030 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x7040 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x7050 */  32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,
/* 0x7060 */ 110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x7070 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84,
/* 0x7080 */  67, 76, 69, 86, 69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x7090 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x70a0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x70b0 */  48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32,
/* 0x70c0 */  32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10,
/* 0x70d0 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x70e0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,
/* 0x70f0 */  82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x7100 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76,
/* 0x7110 */  76, 84, 82, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x7120 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7130 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x7140 */ 100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x7150 */  32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69,
/* 0x7160 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x7170 */  32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93, 58,
/* 0x7180 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x7190 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x71a0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x71b0 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,
/* 0x71c0 */ 116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79,
/* 0x71d0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x71e0 */  79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10, 79,
/* 0x71f0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x7200 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x7210 */  48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x7220 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,
/* 0x7230 */  82, 49, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x7240 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67,
/* 0x7250 */  76, 69, 86, 69, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x7260 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7270 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x7280 */  50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x7290 */  32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48,
/* 0x72a0 */  48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x72b0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x72c0 */  49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x72d0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x72e0 */  84, 82, 49, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x72f0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7300 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x7310 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x7320 */  32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10
};
