unit Mouse;
interface
    procedure InitMouse;

    procedure ShowMouse;
    procedure HideMouse;

    function GetMouseX:word;
    function GetMouseY:word;
    function GetMouseRelX:word;
    function GetMouseRelY:word;

    function ReturnPressedButton:word;
    function ButtonDown:boolean;
    function ButtonUp:boolean;
    function LButtonDown:boolean;
    function RButtonDown:boolean;

    procedure SetMouseSensitivity(x,y:word);

implementation

    procedure InitMouse;
    var
    	Temp:word;
    begin
    	asm
       	    mov ax,00h
            int 33h
            mov [Temp],bx
        end; {asm}
    end; {InitMouse}

    procedure ShowMouse;
    begin
    	asm
            mov ax,01h
            int 33h
        end; {asm}
    end; {ShowMouse}

    procedure HideMouse;
    begin
    	asm
            mov ax,02h
            int 33h
        end; {asm}
    end; {HideMouse}

    function GetMouseX:word;
    var
    	Temp:word;
    begin
    	asm
            mov ax,03h
            int 33h
            mov [Temp],cx
        end; {asm}
	GetMouseX:=trunc(Temp/2);
    end; {GetMouseX}

    function GetMouseY:word;
    var
    	Temp:word;
    begin
    	asm
            mov ax,03h
            int 33h
            mov [Temp],dx
        end; {asm}
        GetMouseY:=Temp;
    end; {GetMouseY}

    function GetMouseRelX:word;
    var
    	Temp:word;
    begin
    	asm
            mov ax,0Bh
            int 33h
            mov [Temp],cx
        end; {asm}
        GetMouseRelX:=Temp;
    end; {GetMouseRelX}

    function GetMouseRelY:word;
    var
    	Temp:word;
    begin
    	asm
            mov ax,0Bh
	    int 33h
            mov [Temp],dx
       end; {asm}
       GetMouseRelY:=Temp;
    end; {GetMouseRelY}

	function ReturnPressedButton:word;
	var
          Temp:word;
	begin
	  asm
            mov ax,03h
	    int 33h
	    mov [Temp],bx
          end; {asm}
        ReturnPressedButton:=Temp;
    end; {ReturnPressedButton}

    function ButtonDown:boolean;
    begin
       ButtonDown:=ReturnPressedButton<>0;
    end; {ButtonDown}

    function RButtonDown:boolean;
    begin
       RButtonDown:=ReturnPressedButton=2;
    end; {ButtonDown}

    function LButtonDown:boolean;
    begin
       LButtonDown:=ReturnPressedButton=1;
    end; {ButtonDown}

    function ButtonUp:boolean;
    begin
       ButtonUp:=ReturnPressedButton=0;
    end; {ButtonUp}

    procedure SetMouseSensitivity(x,y:word);
    begin
        asm
            mov ax,1ah
            mov bx,[x]
            mov cx,[y]
            mov dx,1
            int 33h
        end; {asm}
    end; {SetMouseSensitivity}
end. {Mouse}