-- sle.e - Single-line edit for prompts - HIP 2.0
-- Copyright (C) 2000  Davi Tassinari de Figueiredo
--
-- This program is distributed under the terms of the GNU General
-- Public License. Please read the documentation for more information.
--
-- This file contains a single-line edit routine. It was created for
-- use with HIP, but it is easy to use it in other programs (simply
-- remove the calls to add_random_data).


include get.e
include graphics.e
include truerand.e

sequence LEFT, RIGHT, HOME, END, ENTER, ESC, BACKSPACE, DELETE, INSERT

constant back_char = ' ', space_char = ' '

if platform() = LINUX then
		LEFT        = {260}
		RIGHT       = {261}
		HOME        = {262}
		END         = {360}
		ENTER       = {'\n'}
		ESC         = {27}
		BACKSPACE   = {263}
		DELETE      = {330}
		INSERT      = {331}

else
		LEFT        = {331}
		RIGHT       = {333}
		HOME        = {327}
		END         = {335}
		ENTER       = {'\r'}
		ESC         = {27}
		BACKSPACE   = {8}
		DELETE      = {339}
		INSERT      = {338}

end if


function fill_line(sequence text, atom len, atom space_char)
    -- Fills a sequence with space_char characters, so that it is
    -- at least len bytes long.
    if length(text) < len then
	text = text &
	 repeat(space_char, len - length(text))
    end if

    return text
end function

function format_line(sequence line, atom left_pos, atom len, atom fill_char, atom display_char)
    -- Returns part of the line that should be displayed.
    -- If display_char is -1, show text; otherwish show
    -- the character specified by it.

    if length(line)<left_pos then
	return repeat(fill_char, len)
    else

	if display_char != -1 then
	    line = repeat (display_char, length(line))
	end if

	line = line [left_pos..length(line)]

	if length(line)<len then
	    line = line & repeat(fill_char, len-length(line))
	else
	    line = line[1..len]
	end if
	return line
    end if
end function


global function ask(atom line,      -- Screen line to show the prompt
		    atom st_pos,    -- Row of the beginning of the prompt
		    atom end_pos,   -- Row of the end of the prompt
		    sequence text,  -- Text initially in the prompt ("" = none)
		    atom display_char)  -- Char to be displayed instead
					-- of the text itself (-1 = display text)

    -- Single-line edit

    atom pos, key, left_pos, insert
    sequence formatted_line

    insert = 1
    if insert then cursor (UNDERLINE_CURSOR)
    else cursor (BLOCK_CURSOR) end if


    left_pos = 1
    pos= length(text) + 1

    while 1 do


	-- Compute first position shown
	if pos<left_pos then
	    left_pos = pos
	elsif pos>left_pos + end_pos - st_pos then
	    left_pos = pos - end_pos + st_pos
	end if


	-- Show line
	    formatted_line = format_line(text,
			left_pos,end_pos-st_pos+1, back_char, display_char)

	position(line,st_pos)
	puts(1,formatted_line)

	-- Show cursor
	position(line,pos - left_pos + st_pos)


	key = wait_key()
	add_random_data ( int_to_bytes(key) )

	if find(key, LEFT) then
	    if pos>1 then pos=pos-1 end if

	elsif find(key, RIGHT) then
	    pos=pos+1

	elsif find(key, HOME) then
	    pos = 1

	elsif find(key, END) then
	    pos = length(text) + 1

	elsif find(key, ENTER) then
	    return text

	elsif find(key, DELETE) then
	    if pos<=length(text) then
		text=text[1..pos-1]&text[pos+1..length(text)]
	    end if


	elsif find(key, BACKSPACE) then

	    if pos>1 then
		text=text[1..pos-2]&text[pos..length(text)]
		pos=pos-1
	    end if

	elsif find(key, ESC) then
	    return -1

	elsif find(key, INSERT) then
	    insert = not insert

	    if insert then cursor (UNDERLINE_CURSOR)
	    else cursor (BLOCK_CURSOR) end if

	elsif key >=32 and key<= 255 then

	    if insert then
		text = fill_line(text, pos-1, space_char)
		text=text[1..pos-1]&key&text[pos..length(text)]
		pos=pos+1
	    else
		text = fill_line(text, pos, space_char)
		text[pos] = key
		pos=pos+1
	    end if

	end if


    end while

end function

