-- crc32.e - CRC-32 for Euphoria - version 1.32
-- Copyright (C) 2002  Davi Tassinari de Figueiredo
--
-- If you wish to contact me, send an e-mail to davitf@eml.cc .
--
-- You can get the latest version of this program from my Euphoria page:
-- http://www16.brinkster.com/davitf/
--
--
-- License terms and disclaimer:
--
-- Permission is granted to anyone to use this software for any purpose,
-- including commercial applications, and to alter it and redistribute it
-- freely, subject to the following restrictions:
--
-- 1. The origin of this software must not be misrepresented; you must not
--    claim that you wrote the original software or remove the original
--    authors' names.
-- 2. Altered source versions must be plainly marked as such, and must not
--    be misrepresented as being the original software.
-- 3. All source distributions, with or without modifications, must be
--    distributed under this license. You may also opt to distribute the
--    software under the GNU General Public License, version 2 or (at your
--    option) any later version, in which case you should replace this
--    notice with an appropriate one. If this software's source code is
--    distributed as part of a larger product, this item does not apply to
--    the rest of the product.
-- 4. If you use this software in a product, an acknowledgment in the
--    product documentation is required. If the source code for the product
--    is not freely distributed, you must include information on how to
--    freely obtain the original software's source code.
--
-- This software is provided 'as-is', without any express or implied
-- warranty.  In no event will the authors be held liable for any damages
-- arising from the use of this software.
--
-- If you want to distribute this software in a way not allowed by this
-- license, or distribute the source under different license terms, contact
-- the authors for permission.


include machine.e
constant at_once=512    -- This is the number of chars that will be
			-- processed in each call to the machine code
			-- routine. That is the value that works best
			-- for me. You might try other values to see
			-- if you find a faster one.

constant polynomial=#EDB88320   -- Change this if you need another polynomial

global constant table_address=allocate(1024)
constant crc32_code = allocate(59)
constant char_address=allocate(at_once),crc_address=crc32_code+55

-- Compute the table



-- These are Assembly routines compiled with Pete Eberlein's ASM to
-- Euphoria converter and transformed into strings to save space.
-- If you want to see their source, read the .asm files in the CRC-32
-- package.

poke(crc32_code, and_bits(#FF,
  "GJHIϬwwl,wi߀:zxiQPRO"+9))

poke4(crc32_code + 5, table_address)
poke4(crc32_code + 31, polynomial)

call(crc32_code)    -- Call code and compute the table

poke(crc32_code, and_bits(#FF,
  "ADBzr#\nr$2rcДJLI"+15))

poke4(crc32_code + 4, crc_address)  -- CRC address
poke4(crc32_code + 9, char_address)
poke4(crc32_code + 28, table_address)
poke4(crc32_code + 47, crc_address) -- CRC address

procedure process_chars(sequence chars)
    -- Get a group of characters (at most at_once bytes) and update the CRC
    poke4(crc32_code + 40, char_address+length(chars))
    poke(char_address,chars)
    call(crc32_code)
end procedure

global procedure init_crc()
    -- Set initial CRC
    poke4(crc_address,#FFFFFFFF)
end procedure

global procedure update_crc(sequence buf)
    -- Update CRC

    for n=1 to length(buf) by at_once do
	if n+at_once-1>length(buf) then
	    process_chars(buf[n..length(buf)])
	else
	    process_chars(buf[n..n+at_once-1])
	end if
    end for

    mem_set(char_address, 0, at_once)
end procedure

global function get_crc()
    -- Retrieve CRC
    return xor_bits( peek({crc_address, 4}), #FF)
end function

global function crc32(sequence buf)
    -- Calculate the CRC for a string
    -- Does not interfere with the CRC for the routines above.

    atom old_crc
    sequence crc

    old_crc= peek4u(crc_address)    -- Store old CRC

    poke4(crc_address,#FFFFFFFF)

    for n=1 to length(buf) by at_once do
	-- Process chars, one block at a time
	if n+at_once-1>length(buf) then
	    process_chars(buf[n..length(buf)])
	else
	    process_chars(buf[n..n+at_once-1])
	end if
    end for

    crc= xor_bits( peek({crc_address, 4}), #FF)       -- Get CRC

    poke4(crc_address, old_crc)
    return crc
end function

