char nr_channels;
unsigned short freq_tab[36] =
              {856,808,762,720,678,640,604,570,538,508,480,453, //C-1 to B-1
	            428,404,381,360,339,320,302,285,269,254,240,226, //C-2 to B-2
	            214,202,190,180,170,160,151,143,135,127,120,113};//C-3 to B-3
             // C   C#  D   D#  E   F   F#  G   G#  A   B   H
char *volume_tab;

// Playing defines
char sb_init(char number_of_channels);
char sb_deinit(void);
void sb_play_buffer(unsigned short length);
char sb_alloc_buffer (void);
char sb_reset(char baseport);
void sb_set_frequency(unsigned long frequency);
void sb_dsp_write(unsigned char c);
unsigned char sb_dsp_read(void);
void sb_speaker_on(void);
void sb_speaker_off(void);
void sb_halt_dma(void);
void sb_dma_continue(void);
void sb_get_interrupt(void);
void dma_interrupt(void);
//void play_sample(char *address, long length, char channel_nr);

void sb_mix_buffer(unsigned short bytes2mix);
void track(void);
char load_mod(char *filename);

unsigned short sbport_reset, sbport_read, sbport_write, sbport_status, sbport_data;
_go32_dpmi_seginfo sb_dos_memory;
unsigned int sb_buffer;
const sb_buffer_size = 512;
char sb_buffer_playing = 0;
_go32_dpmi_seginfo old_irq_handler;

char sb_irq/* = 0x5*/;
char sb_base/* = 2*/;

struct {
  unsigned long length;
  unsigned long position;
  unsigned long add;
  unsigned long loop_start;
  unsigned long loop_length;
  unsigned long loop_end;
  char volume;
  char *address;
  char playing;
} channel[8];
char channel_nr = 0;

// MOD defines
char *pattern_data;

struct {
  char _signature[4];
  char name[20];
  unsigned char channels;
  unsigned char speed;
  unsigned char bpm;
  struct {
    char name[22];
    unsigned short length;
    char fine_tune;
    unsigned char volume;
    unsigned short loop_start;
    unsigned short loop_length;
    char *address;
  } smp[31];
  unsigned char song_length;
  unsigned char number_of_patterns;
  unsigned char order[128];
  char master_volume;
} mod;

unsigned char current_order, current_pattern;
char *song_pos;
unsigned char song_row;
char timer_ticks;
unsigned short nr_of_bytes2mix;
unsigned short bytes_left2mix;
unsigned short sb_buffer_pos = 0;


//--------------------------------[ MAIN ]------------------------------------

/*void main(void)
{
  unsigned short c;
  char key;

  __djgpp_nearptr_enable();

  load_mod("test2.mod");

  sb_init();

  while(!kbhit()) {
  }
  getch();

  sb_deinit();
  free(pattern_data);
  for (c = 0; c < 31; c++) free(mod.smp[c].address);
  free(volume_tab);
}*/


//--------------------------[ TRACKING FUNCTIONS ]----------------------------

void track(void)
{
  unsigned short c;
  unsigned char sample, effect, effect_parameter;
  unsigned short temp;
  long note;

  if (bytes_left2mix > 0) {
    sb_mix_buffer(bytes_left2mix);
    sb_buffer_pos += bytes_left2mix;
    bytes_left2mix = 0;
  }

  sb_mod_track_some_more:

  timer_ticks++;

  if (timer_ticks >= mod.speed) {
    song_pos = pattern_data + mod.channels * 4 * 64 * current_pattern + mod.channels * 4 * song_row;
    for (c = 0; c < mod.channels; c++) {
      sample = song_pos[0];
      note = 7159090.5 / (freq_tab[song_pos[1]] * 2);
      effect = song_pos[2];
      effect_parameter = song_pos[3];
      if (sample > 0) {
        sample--; // Uh..
        channel[c].playing = 1;
        channel[c].address = mod.smp[sample].address;
        channel[c].length = mod.smp[sample].length << 16;
        channel[c].add = (65536L / 2) * note / 10000L; // hmm.. what value should I put here?
        channel[c].loop_start = mod.smp[sample].loop_start << 16;
        channel[c].loop_length = mod.smp[sample].loop_length << 16;
        channel[c].loop_end = channel[c].loop_start + channel[c].loop_length;
        channel[c].volume = 64;
        channel[c].position = 0;
      }
      if (effect == 0xC) {
        channel[c].volume = ((effect_parameter >> 4) * 16) + (effect_parameter & 0xF);
      }
      if (effect == 0xF) {
        temp = ((effect_parameter >> 4) * 16) + (effect_parameter & 0xF);
        if (temp < 0x20) {
          mod.speed = temp;
        }
        else {
          mod.bpm = temp;
          nr_of_bytes2mix = 22000 / ((mod.bpm * 2) / 5);
        }
      }
      channel[c].volume = channel[c].volume * mod.master_volume / 64;

      song_pos += 4;
    }
    timer_ticks = 0;
    song_row++;
    if (song_row > 63) {
      song_row = 0;
      current_order++;
      if (current_order >= mod.song_length) {
        current_order = 0;
      }
      current_pattern = mod.order[current_order];
    }
  }

  if (sb_buffer_pos < (sb_buffer_size - nr_of_bytes2mix)) { // mix a whole tick
    sb_mix_buffer(nr_of_bytes2mix);
    sb_buffer_pos += nr_of_bytes2mix;
    goto sb_mod_track_some_more;
  }
  if (sb_buffer_pos < sb_buffer_size) { // mix the leftovers
    sb_mix_buffer(sb_buffer_size - sb_buffer_pos);
    bytes_left2mix = nr_of_bytes2mix - (sb_buffer_size - sb_buffer_pos);
  }
  sb_buffer_pos = 0;
}

//---------------------------[ PLAYING FUNCTIONS ]----------------------------

void sb_mix_buffer(unsigned short bytes2mix)
{
  unsigned short c, c2;
  char *buffer = (char *)sb_buffer + sb_buffer_playing * sb_buffer_size
                 + sb_buffer_pos + __djgpp_conventional_base;
  //asm ("cli; pusha");

  for (c = 0; c < bytes2mix; c++) {
    buffer[c] = 128;
    for (c2 = 0; c2 < nr_channels; c2++) {
      if (channel[c2].playing == 1) {
        buffer[c] += volume_tab[channel[c2].address[channel[c2].position >> 16] + (channel[c2].volume << 8) + 128];
        channel[c2].position += channel[c2].add;
        if (channel[c2].loop_length == 0) {
          if (channel[c2].position > channel[c2].length) channel[c2].playing = 0;
        }
        else {
          if (channel[c2].position > channel[c2].loop_end) channel[c2].position = channel[c2].loop_start;
        }
      }
    }
  }
  //asm ("popa; sti");
}

char sb_init(char number_of_channels)
{
  unsigned short c, c2;
  char *blaster;

  nr_channels = number_of_channels;

  // Allocate memory for volume lookup table
  volume_tab = (char *)malloc(16640);

  // Calculate volume table
  for (c = 0; c < 65; c++) {
    for (c2 = 0; c2 < 256; c2++) {
      volume_tab[(c << 8) + c2] = ((c * (c2 - 128)) / 64) / nr_channels;
    }
  }

  for (c = 0; c < nr_channels; c++) {
    channel[c].playing = 0;
  }

  if ((blaster = getenv("BLASTER")) != NULL) {
    c = 0;
    while(blaster[c] != 'I') c++;
    sb_irq = blaster[c + 1] - '0';
    c = 0;
    while(blaster[c] != 'A') c++;
    sb_base = blaster[c + 2] - '0';

  /*else {
    printf("Error, no BLASTER variable found. Why don't you have a BLASTER variable??");
    exit(1);
  }*/

    if (!(sb_alloc_buffer())) {
      printf("Memory allocation error :'(");
      exit(1);
    }
    memset((char *)sb_buffer + __djgpp_conventional_base, 128, sb_buffer_size * 2);
    if (!(sb_reset(sb_base * 0x10))) {
      printf("Error initializing soundblaster card at baseport 220 :'(\n");
      exit(1);
    }
    sb_get_interrupt();
    sb_set_frequency(22000);
    sb_speaker_on();
    sb_play_buffer(sb_buffer_size);

    return(TRUE);
  }
  else {
    return(FALSE);
  }
}

char sb_deinit(void)
{
  sb_halt_dma();
  sb_speaker_off();
  _go32_dpmi_free_dos_memory(&sb_dos_memory);
  _go32_dpmi_set_protected_mode_interrupt_vector(8 + sb_irq, &old_irq_handler);
  free(volume_tab);
}

void sb_get_interrupt(void)
{
  _go32_dpmi_seginfo handler;

  handler.pm_offset = (int) dma_interrupt;
  handler.pm_selector = _go32_my_cs();
 
  _go32_dpmi_get_protected_mode_interrupt_vector(8 + sb_irq, &old_irq_handler);
  _go32_dpmi_chain_protected_mode_interrupt_vector(8 + sb_irq, &handler);

  // Turn on the DMA interrupt!!!
  outportb(0x21, (inportb(0x21) & (!(0x01 << sb_irq))));
}

void dma_interrupt(void)
{
  //asm ("cli; pusha");

  inportb(sbport_data);
  sb_play_buffer(sb_buffer_size);

  if (sb_buffer_playing == 1) sb_buffer_playing = 0;
  else sb_buffer_playing = 1;
  sb_mix_buffer(sb_buffer_size);
  //track();

  outportb(0x20, 0x20);
  //asm ("popa; sti");
}

void sb_play_buffer(unsigned short length)
{
  long address = sb_buffer + sb_buffer_playing * sb_buffer_size;
  //asm ("cli; pusha");
  length--;
  outportb(0x0A, 0x05);
  outportb(0x0C, 0x00);
  outportb(0x0B, 0x49);
  outportb(0x02, address); // bit 0-7 of address
  outportb(0x02, address >> 8); // bit 8-15 of address
  outportb(0x83, address >> 16); // bit 16-19 of address (page)
  outportb(0x03, length);
  outportb(0x03, length >> 8);
  outportb(0x0A, 0x01);
  sb_dsp_write(0x14);
  sb_dsp_write(length);
  sb_dsp_write(length >> 8);
  //asm ("popa; sti");
}

char sb_alloc_buffer(void)
{
  // Allocate dos memory for the DMA buffer
  unsigned int addr, page;

  sb_dos_memory.size = (sb_buffer_size * 2 * 2) / 16;
  if (_go32_dpmi_allocate_dos_memory(&sb_dos_memory)) return(FALSE);

  addr = sb_dos_memory.rm_segment << 4;
  if ((addr >> 16) != ((addr + sb_buffer_size) >> 16)) addr += 2048;
  sb_buffer = addr;

  return(TRUE);
}

char sb_reset(char baseport)
{
  sbport_reset = baseport + 0x206;
  sbport_read =	baseport + 0x20A;
  sbport_write = baseport + 0x20C;
  sbport_status = baseport + 0x20C;
  sbport_data = baseport + 0x20E;

  outportb(sbport_reset, 1);
  delay(10); // 3 micro seconds
  outportb(sbport_reset, 0);
  delay(10); // 100 micro seconds
  if (((inportb(sbport_data) & 0x80) == 0x80) && (inportb(sbport_read) == 0xAA))
    return(TRUE);
  else
    return(FALSE);
}

void sb_set_frequency(unsigned long frequency)
{
  unsigned short time_constant;
  time_constant = 256 - 1000000 / frequency;
  sb_dsp_write(0x40);
  sb_dsp_write(time_constant);
}

void sb_dsp_write(unsigned char c)
{
  while((inportb(sbport_status) & 0x80) != 0);
  outportb(sbport_write, c);
}

unsigned char sb_dsp_read(void)
{
  while((inportb(sbport_data) & 0x80) == 0);
  return(inportb(sbport_read));
}

void sb_speaker_on(void)
{
  sb_dsp_write(0xD1);
}

void sb_speaker_off(void)
{
  sb_dsp_write(0xD3);
}

void sb_halt_dma(void)
{
  sb_dsp_write(0xD0);
}

void sb_dma_continue(void)
{
  sb_dsp_write(0xD4);
}

char load_mod(char *filename) {
  unsigned short c, c2, c3; // Loop variables
  unsigned char b1, b2, b3, b4; // Temp byte variables
  short s;
  long pos;
  FILE *infile;

  // Allocate memory for volume lookup table
  //volume_tab = (char *)malloc(16640);

  infile = fopen(filename, "rb");

  // Check if it really is a MOD file
  fseek(infile, 1080, SEEK_SET); // signature
  fread(mod._signature, 1, 4, infile);
  if (strcmp(mod._signature, "M.K.") != 0) {
    printf("Unknown MOD format (or not a MOD at all!).\n");
    exit(1);
  }
  else mod.channels = 4;
  mod.speed = 6; // Not stated anywhere in the MOD!!
  mod.bpm = 125; // Neither is this!
  // Note: If bpm is too small, the sb_buffer_size will not be able to hold one tick mix

  // Load MOD name
  fseek(infile, 0, SEEK_SET); // MOD name
  fread(mod.name, 1, 20, infile);
  mod.name[19] = 0; // NULL terminated string.

  // Load sample information
  for (c = 0; c < 31; c++) {
    fread(mod.smp[c].name, 1, 22, infile);
    mod.smp[c].length = ((fgetc(infile) << 8) + fgetc(infile)) << 1;
    mod.smp[c].fine_tune = fgetc(infile);
    if (mod.smp[c].fine_tune > 7) mod.smp[c].fine_tune -= 16; // make signed
    mod.smp[c].volume = fgetc(infile);
    mod.smp[c].loop_start = ((fgetc(infile) << 8) + fgetc(infile)) << 1;
    mod.smp[c].loop_length = ((fgetc(infile) << 8) + fgetc(infile)) << 1;
  }

  // Load order information
  mod.song_length = fgetc(infile);
  fgetc(infile); // unused
  mod.number_of_patterns = 0;
  for (c = 0; c < 128; c++) {
    mod.order[c] = fgetc(infile);
    if (mod.order[c] > mod.number_of_patterns) mod.number_of_patterns = mod.order[c];
  }
  for (c = 0; c < 4; c++) fgetc(infile); // "M.K."

  // Load pattern data
  pos = 0;
  pattern_data = (char *)malloc(mod.channels * 4 * 64 * (mod.number_of_patterns + 1));
  for (c = 0; c < (mod.number_of_patterns + 1); c++) {
    for (c2 = 0; c2 < (mod.channels * 64); c2++) {
      b1 = fgetc(infile);
      b2 = fgetc(infile);
      b3 = fgetc(infile);
      b4 = fgetc(infile);
      pattern_data[pos + 0] = (b1 & 0xF0) + (b3 >> 4); // sample
      s = ((b1 & 0x0F) << 8) + b2; // note
      pattern_data[pos + 1] = 255; // no note value
      for (c3 = 0; c3 < 36; c3++) {
        if ((s > (freq_tab[c3] - 2)) && (s < (freq_tab[c3] + 2))) {
          pattern_data[pos + 1] = c3;
          break;
        }
      }
      pattern_data[pos + 2] = b3 & 0x0F; // effect
      pattern_data[pos + 3] = b4; // effect parameter
      pos += 4;
    }
  }

  // Load sample data
  for (c = 0; c < 31; c++) {
    mod.smp[c].address = (char *)malloc(mod.smp[c].length);
    fread(mod.smp[c].address, 1, mod.smp[c].length, infile);
  }

  fclose(infile);

  // Calculate volume table
  /*for (c = 0; c < 65; c++) {
    for (c2 = 0; c2 < 256; c2++) {
      volume_tab[(c << 8) + c2] = ((c * (c2 - 128)) / 64) / 8;
    }
  }*/

  // -----[ PLAY THE MOD ]-----

  mod.master_volume = 32;
  nr_of_bytes2mix = 22000 / ((mod.bpm * 2) / 5);
  bytes_left2mix = 0;
  current_order = 0;
  current_pattern = mod.order[current_order];
  song_row = 0;
}
