/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.ranfa.lib.database.Scraping;
import com.ranfa.lib.database.Song;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class WebFetchingTest {
    private String wrongValueString = "Invaild Value";
    private List<Song> emptyList = new ArrayList<Song>();
    private List<Song> correctList = Scraping.getWholeData();
    private String emptyMessageString = "ArrayList must not empty.";

    @Test
    public void getSpecificAttributeSongsTest() {
        Assert.assertThrows((String)this.emptyMessageString, IllegalArgumentException.class, () -> {
            List<Song> list = Scraping.getSpecificAttributeSongs(this.emptyList, "\u5168\u30bf\u30a4\u30d7");
        });
        Assert.assertThrows((String)String.format("Illegal attribute value: %s", this.wrongValueString), IllegalArgumentException.class, () -> {
            List<Song> list = Scraping.getSpecificAttributeSongs(this.correctList, this.wrongValueString);
        });
    }

    @Test
    public void getSpecificDifficultySongsTest() {
        Assert.assertThrows((String)this.emptyMessageString, IllegalArgumentException.class, () -> {
            List<Song> list = Scraping.getSpecificDifficultySongs(this.emptyList, "DEBUT");
        });
        Assert.assertThrows((String)String.format("Illegal difficulty value: %s", this.wrongValueString), IllegalArgumentException.class, () -> {
            List<Song> list = Scraping.getSpecificDifficultySongs(this.correctList, this.wrongValueString);
        });
    }

    @Test
    public void getSpecifiLevelSongsTest() {
        Assert.assertThrows((String)this.emptyMessageString, IllegalArgumentException.class, () -> {
            List<Song> list = Scraping.getSpecificLevelSongs(this.emptyList, 18, true, false);
        });
        Assert.assertThrows((String)"Level must not negative.", IllegalArgumentException.class, () -> {
            List<Song> list = Scraping.getSpecificLevelSongs(this.correctList, -1, true, false);
        });
        Assert.assertThrows((String)"Illegal boolean value.", IllegalArgumentException.class, () -> {
            List<Song> list = Scraping.getSpecificLevelSongs(this.correctList, 18, false, false);
        });
    }

    @Test
    public void getSpecificAlbumTypeSongsTest() {
        Assert.assertThrows((String)this.emptyMessageString, IllegalArgumentException.class, () -> {
            List<Song> list = Scraping.getSpecificAlbumTypeSongs(this.emptyList, "ALBUM A");
        });
        Assert.assertThrows((String)"type must not null.", IllegalArgumentException.class, () -> {
            List<Song> list = Scraping.getSpecificAlbumTypeSongs(this.correctList, null);
        });
    }
}

