/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib;

import com.ranfa.lib.concurrent.CountedThreadFactory;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterIntegration {
    private static final String TOKENPATH = "generated/twitterToken.json";
    private static Logger logger = LoggerFactory.getLogger(TwitterIntegration.class);
    private static final Executor CONCURRENT_SERVICE = Executors.newSingleThreadExecutor(new CountedThreadFactory(() -> "DRS", "Twitter4J Migration Thread"));

    public static boolean PostTwitter(String status) {
        CompletableFuture.runAsync(() -> {
            logger.info("Searching old token file...");
            if (Files.exists(Paths.get(TOKENPATH, new String[0]), new LinkOption[0])) {
                logger.info("Old token file has been located. this will NOT be used in the future.");
                try {
                    Files.delete(Paths.get(TOKENPATH, new String[0]));
                }
                catch (IOException e) {
                    logger.error("There was an error while deleting old token file.", (Throwable)e);
                }
            } else {
                logger.info("There is no old file. Ending up cleaning up.");
            }
        }, CONCURRENT_SERVICE).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                logger.warn("There was a problem while processing concurrent process.", ex);
            }
        }, CONCURRENT_SERVICE);
        boolean res = false;
        String link = "https://twitter.com/intent/tweet?text={STATUS_TEXT}&hashtags=DelesteRandomSelector,%E3%83%87%E3%83%AC%E3%82%B9%E3%83%86&via=hizumiaoba";
        String encodedStatus = URLEncoder.encode(status, Charset.forName("UTF-8"));
        link = link.replace("{STATUS_TEXT}", encodedStatus);
        URI url = null;
        try {
            url = new URI(link);
        }
        catch (URISyntaxException e) {
            logger.error("Unable to encode target URI. expect: {}", (Object)link);
        }
        logger.info("Attempting to open default browser with following URL: ", (Object)Objects.requireNonNull(url));
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(url);
        }
        catch (IOException e) {
            logger.error("There was an error while opening browser.", (Throwable)e);
        }
        logger.info("Successfully updated the status to : {}", (Object)status);
        res = true;
        return res;
    }
}

