/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.main;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.ranfa.lib.CheckVersion;
import com.ranfa.lib.Easter;
import com.ranfa.lib.EstimateAlbumTypeCycle;
import com.ranfa.lib.ManualUpdateThreadImpl;
import com.ranfa.lib.Scraping;
import com.ranfa.lib.SettingJSONProperty;
import com.ranfa.lib.Settings;
import com.ranfa.lib.Song;
import com.ranfa.lib.TwitterIntegration;
import com.ranfa.lib.Version;
import com.ranfa.main.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Version(major=3, minor=0, patch=1)
public class DelesteRandomSelector
extends JFrame {
    private static ArrayList<Song> selectedSongsList = new ArrayList();
    private JPanel contentPane;
    private JPanel panelNorth;
    private JPanel panelWest;
    private JLabel labelVersion;
    private JLabel labelTitle;
    private JLabel labelDifficulty;
    private JLabel labelLevel;
    private JSpinner spinnerLevel;
    private JCheckBox checkMoreLv;
    private JCheckBox checkLessLv;
    private JPanel panelEast;
    private JPanel panelCentre;
    private JButton btnImport;
    private JButton btnStart;
    private JButton btnExit;
    private JComboBox comboDifficultySelect;
    private JLabel labelLvCaution;
    private JComboBox comboAttribute;
    private SettingJSONProperty property = new SettingJSONProperty();
    private JButton btnTwitterIntegration;
    private String[] integratorArray;
    private boolean integratorBool = false;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private CompletableFuture<Void> softwareUpdateFuture = null;
    private CompletableFuture<Void> albumTypeEstimateFuture = null;
    private String albumType = Messages.MSGAlbumTypeBeingCalculated.toString();
    private Logger logger = LoggerFactory.getLogger(DelesteRandomSelector.class);
    private ManualUpdateThreadImpl impl;
    private Thread manualUpdateThread;
    private JButton btnManualUpdate;
    private Easter easter;

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            try {
                DelesteRandomSelector frame = new DelesteRandomSelector();
                frame.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public DelesteRandomSelector() {
        boolean isFirst;
        boolean bl = isFirst = !Scraping.databaseExists();
        if (isFirst) {
            JOptionPane.showMessageDialog(this, Messages.MSGDatabaseNotExist.toString());
            if (!Scraping.writeToJson(Scraping.getWholeData())) {
                JOptionPane.showMessageDialog(this, "Exception:NullPointerException\nCannot Keep up! Please re-download this Application!");
                throw new NullPointerException("FATAL: cannot continue!");
            }
        }
        ExecutorService es = Executors.newWorkStealingPool();
        CompletableFuture<ArrayList> getFromJsonFuture = CompletableFuture.supplyAsync(() -> Scraping.getFromJson(), es);
        CompletableFuture<ArrayList> getWholeDataFuture = CompletableFuture.supplyAsync(() -> Scraping.getWholeData(), es);
        if (!Settings.fileExists() && !Settings.writeDownJSON()) {
            JOptionPane.showMessageDialog(this, "Exception:NullPointerException\nCannot Keep up! Please re-download this Application!");
            throw new NullPointerException("FATAL: cannot continue!");
        }
        this.logger.debug("Loading settings...");
        this.property.setCheckLibraryUpdates(Settings.needToCheckLibraryUpdates());
        this.property.setCheckVersion(Settings.needToCheckVersion());
        this.property.setWindowWidth(Settings.getWindowWidth());
        this.property.setWindowHeight(Settings.getWindowHeight());
        this.property.setSongLimit(Settings.getSongsLimit());
        this.property.setSaveScoreLog(Settings.saveScoreLog());
        this.logger.debug("Load settings done.");
        this.logger.debug("Version check: {}", (Object)this.property.isCheckVersion());
        this.logger.debug("Library update check: {}", (Object)this.property.isCheckLibraryUpdates());
        this.logger.debug("Window Width: {}", (Object)this.property.getWindowWidth());
        this.logger.debug("Window Height: {}", (Object)this.property.getWindowHeight());
        this.logger.debug("Song Limit: {}", (Object)this.property.getSongLimit());
        this.logger.debug("SaveScoreLog: {}", (Object)this.property.isSaveScoreLog());
        EstimateAlbumTypeCycle.Initialization();
        if (Files.exists(Paths.get("generated/albumCycle.json", new String[0]), new LinkOption[0])) {
            this.albumType = EstimateAlbumTypeCycle.getCurrentCycle();
        }
        if (this.property.isCheckVersion()) {
            this.softwareUpdateFuture = CompletableFuture.runAsync(() -> CheckVersion.needToBeUpdated(), es);
        }
        BiConsumer<ArrayList, ArrayList> updateConsumer = (list1, list2) -> {
            this.logger.info("Checking database updates...");
            if (list1.size() > list2.size()) {
                long time = System.currentTimeMillis();
                this.logger.info("{} Update detected.", (Object)(list1.size() - list2.size()));
                Scraping.writeToJson(list1);
                this.logger.info("Update completed in {} ms", (Object)(System.currentTimeMillis() - time));
                this.logger.info("Updated database size: {}", (Object)list1.size());
            } else {
                this.logger.info("database is up-to-date.");
            }
        };
        Runnable setEnabled = () -> {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e1) {
                this.logger.error("Thread has been interrupted during waiting cooldown.", (Throwable)e1);
            }
            this.btnImport.setEnabled(true);
            this.btnImport.setText(Messages.MSGNarrowingDownSongs.toString());
        };
        getWholeDataFuture.thenAcceptAsync(list -> this.logger.info("Scraping data size:" + list.size()), (Executor)es);
        getFromJsonFuture.thenAcceptAsync(list -> this.logger.info("Currently database size:" + list.size()), (Executor)es);
        if (this.property.isCheckLibraryUpdates()) {
            CompletionStage updatedFuture = getWholeDataFuture.thenAcceptBothAsync(getFromJsonFuture, updateConsumer, (Executor)es);
            ((CompletableFuture)updatedFuture).thenRunAsync(setEnabled, es);
        }
        this.easter = new Easter();
        this.setTitle(this.easter.getTodaysBirth());
        this.logger.debug("Version: {}", (Object)CheckVersion.getVersion());
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, this.property.getWindowWidth(), this.property.getWindowHeight());
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.panelNorth = new JPanel();
        this.contentPane.add((Component)this.panelNorth, "North");
        this.panelNorth.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"max(302dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"40px")}, new RowSpec[]{RowSpec.decode((String)"20px")}));
        this.labelTitle = new JLabel(Messages.MSGTitle.toString());
        this.labelTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 16));
        this.panelNorth.add((Component)this.labelTitle, "1, 1, center, top");
        this.labelVersion = new JLabel(CheckVersion.getVersion());
        this.labelVersion.setFont(new Font("SansSerif", 1, 12));
        this.panelNorth.add((Component)this.labelVersion, "3, 1, right, top");
        this.panelWest = new JPanel();
        this.contentPane.add((Component)this.panelWest, "West");
        this.panelWest.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"112px:grow")}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"19px"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"12dlu"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(52dlu;default)")}));
        this.labelDifficulty = new JLabel(Messages.MSGSelectDifficulty.toString());
        this.labelDifficulty.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWest.add((Component)this.labelDifficulty, "2, 2, center, default");
        this.comboDifficultySelect = new JComboBox();
        this.comboDifficultySelect.setFont(new Font("Dialog", 1, 12));
        this.comboDifficultySelect.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.MSGNonSelected.toString(), "DEBUT", "REGULAR", "PRO", "MASTER", "MASTER+", "\u24c1MASTER+", "LIGHT", "TRICK", "PIANO", "FORTE", "WITCH"}));
        this.panelWest.add((Component)this.comboDifficultySelect, "2, 4, fill, default");
        this.comboAttribute = new JComboBox();
        this.comboAttribute.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.comboAttribute.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.MSGNonSelected.toString(), "\u5168\u30bf\u30a4\u30d7", "\u30ad\u30e5\u30fc\u30c8", "\u30af\u30fc\u30eb", "\u30d1\u30c3\u30b7\u30e7\u30f3"}));
        this.panelWest.add((Component)this.comboAttribute, "2, 6, fill, default");
        this.labelLevel = new JLabel(Messages.MSGSongLevel.toString());
        this.labelLevel.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWest.add((Component)this.labelLevel, "2, 8, center, default");
        this.spinnerLevel = new JSpinner();
        this.panelWest.add((Component)this.spinnerLevel, "2, 10");
        this.checkLessLv = new JCheckBox(Messages.MSGBelowSpecificLevel.toString());
        this.checkLessLv.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWest.add((Component)this.checkLessLv, "2, 12");
        this.checkMoreLv = new JCheckBox(Messages.MSGOverSpecificLevel.toString());
        this.checkMoreLv.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWest.add((Component)this.checkMoreLv, "2, 14");
        this.labelLvCaution = new JLabel(Messages.MSGLevelCheckboxInfo.toString());
        this.labelLvCaution.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWest.add((Component)this.labelLvCaution, "2, 16, fill, fill");
        this.panelEast = new JPanel();
        this.contentPane.add((Component)this.panelEast, "East");
        this.panelEast.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"98px")}, new RowSpec[]{RowSpec.decode((String)"26px"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(36dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(30dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(15dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(11dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.btnImport = new JButton(Messages.MSGUpdatingDatabase.toString());
        this.btnImport.setEnabled(false);
        this.btnImport.addActionListener(e -> {
            if (this.impl != null && !this.impl.getFlag()) {
                JOptionPane.showMessageDialog(null, Messages.MSGManualUpdateNotCompleteYet.toString());
            }
            ArrayList<Song> fromJson = Scraping.getFromJson();
            ArrayList<Song> specificlevelList = Scraping.getSpecificLevelSongs(fromJson, (Integer)this.spinnerLevel.getValue(), this.checkLessLv.isSelected(), this.checkMoreLv.isSelected());
            ArrayList<Song> specificDifficultyList = Scraping.getSpecificDifficultySongs(specificlevelList, this.comboDifficultySelect.getSelectedItem().toString());
            ArrayList<Song> specificAttributeList = Scraping.getSpecificAttributeSongs(specificDifficultyList, this.comboAttribute.getSelectedItem().toString());
            ArrayList<Song> specificTypeList = Scraping.getSpecificAlbumTypeSongs(specificAttributeList, EstimateAlbumTypeCycle.getCurrentCycle());
            if (!selectedSongsList.isEmpty()) {
                selectedSongsList.clear();
            }
            selectedSongsList.addAll(this.comboDifficultySelect.getSelectedItem().equals("MASTER+") || this.comboDifficultySelect.getSelectedItem().equals("\u24c1MASTER+") ? specificTypeList : specificAttributeList);
            this.logger.info("Songs are selected.We are Ready to go.");
            JOptionPane.showMessageDialog(null, Messages.MSGCompleteNarrowDown.toString());
        });
        this.btnImport.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelEast.add((Component)this.btnImport, "1, 3, fill, fill");
        this.btnStart = new JButton(Messages.MSGCalcStart.toString());
        this.btnStart.addActionListener(e -> {
            Random random = new Random(System.currentTimeMillis());
            String paneString = "";
            this.integratorArray = new String[this.property.getSongLimit()];
            int i = 0;
            while (i < this.property.getSongLimit()) {
                int randomInt = random.nextInt(selectedSongsList.size());
                String typeString = this.comboDifficultySelect.getSelectedItem().equals("MASTER+") || this.comboDifficultySelect.getSelectedItem().equals("\u24c1MASTER+") ? EstimateAlbumTypeCycle.getCurrentCycle() : "";
                paneString = String.valueOf(paneString) + (i + 1) + Messages.MSGNumberOfSongs.toString() + " " + selectedSongsList.get(randomInt).getAttribute() + " [" + selectedSongsList.get(randomInt).getDifficulty() + "]\u300c" + selectedSongsList.get(randomInt).getName() + "\u300d\uff01(Lv:" + selectedSongsList.get(randomInt).getLevel() + " " + typeString + ")\n\n";
                this.integratorArray[i] = String.valueOf(selectedSongsList.get(randomInt).getName()) + "(Lv" + selectedSongsList.get(randomInt).getLevel() + ")\n";
                ++i;
            }
            paneString = String.valueOf(paneString) + Messages.MSGThisPhrase.toString() + this.property.getSongLimit() + Messages.MSGPlayPhrase.toString();
            this.textArea.setText(paneString);
            this.integratorBool = true;
            this.logger.info("show up completed.");
        });
        this.btnStart.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelEast.add((Component)this.btnStart, "1, 7, fill, fill");
        this.btnTwitterIntegration = new JButton(Messages.MSGTwitterIntegration.toString());
        this.btnTwitterIntegration.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 11));
        this.btnTwitterIntegration.addActionListener(e -> {
            boolean authorizationStatus = TwitterIntegration.authorization();
            String updatedStatus = Messages.MSGUsingThisAppPhrase.toString();
            int lengthLimit = updatedStatus.length();
            boolean isBroken = false;
            if (!this.integratorBool) {
                JOptionPane.showMessageDialog(null, Messages.MSGNotPlayYet.toString());
                return;
            }
            String[] stringArray = this.integratorArray;
            int n = this.integratorArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                updatedStatus = String.valueOf(updatedStatus) + element;
                if ((lengthLimit += element.length()) > 69) {
                    isBroken = true;
                    break;
                }
                ++n2;
            }
            updatedStatus = isBroken ? String.valueOf(updatedStatus) + Messages.MSGTwitterPlayOtherwisePhrase.toString() + "\n#DelesteRandomSelector #\u30c7\u30ec\u30b9\u30c6 " : String.valueOf(updatedStatus) + Messages.MSGTwitterPlayOnlyPhrase.toString() + "\n#DelesteRandomSelector #\u30c7\u30ec\u30b9\u30c6 ";
            this.logger.info("status message constructed.");
            lengthLimit = updatedStatus.length();
            if (authorizationStatus) {
                int option = JOptionPane.showConfirmDialog(null, String.valueOf(Messages.MSGTwitterIntegrationConfirm.toString()) + updatedStatus + Messages.MSGStringLength.toString() + lengthLimit);
                this.logger.info("user seletced: " + option);
                switch (option) {
                    case 0: {
                        TwitterIntegration.PostTwitter(updatedStatus);
                        this.logger.info("Success to update the status.");
                        JOptionPane.showMessageDialog(null, Messages.MSGCompletePost.toString());
                        break;
                    }
                    case 1: {
                        this.logger.info("There is no will to post.");
                        break;
                    }
                    case 2: {
                        this.logger.info("The Operation was canceled by user.");
                        break;
                    }
                }
            } else {
                this.logger.info("seems to reject the permission.it should need try again.");
            }
        });
        this.btnManualUpdate = new JButton(Messages.MSGManualUpdate.toString());
        this.btnManualUpdate.addActionListener(e -> {
            this.impl = new ManualUpdateThreadImpl();
            es.submit(this.impl);
        });
        this.panelEast.add((Component)this.btnManualUpdate, "1, 9");
        this.panelEast.add((Component)this.btnTwitterIntegration, "1, 11");
        this.btnExit = new JButton(Messages.MSGTerminate.toString());
        this.btnExit.addActionListener(e -> {
            if (this.softwareUpdateFuture.isDone() || this.albumTypeEstimateFuture.isDone() || !this.impl.getFlag()) {
                this.logger.info("Requested Exit by Button.");
                this.logger.info("Shut down thread pool.");
                es.shutdown();
                System.exit(0);
            } else {
                JOptionPane.showMessageDialog(null, Messages.MSGInternalYpdateNotDoneYet.toString());
            }
        });
        this.btnExit.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelEast.add((Component)this.btnExit, "1, 13");
        this.panelCentre = new JPanel();
        this.contentPane.add((Component)this.panelCentre, "Center");
        this.panelCentre.setLayout(new BorderLayout(0, 0));
        this.textArea = new JTextArea();
        this.textArea.setText(String.valueOf(Messages.MSGNarrowDownProcedure.toString()) + this.property.getSongLimit() + Messages.MSGCurrentAlbumType.toString() + this.albumType);
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.panelCentre.add((Component)this.scrollPane, "Center");
        if (isFirst || !this.property.isCheckLibraryUpdates()) {
            setEnabled.run();
        }
    }
}

