/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ranfa.lib.Version;
import com.ranfa.main.DelesteRandomSelector;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;

public class CheckVersion {
    private static final String URI = "https://raw.githubusercontent.com/hizumiaoba/DelesteRandomSelector/master/version.json";
    private static final String RELEASE_STRING = "https://github.com/hizumiaoba/DelesteRandomSelector/releases";

    public static void needToBeUpdated() {
        int latestMajor = 0;
        int latestMinor = 0;
        int latestPatch = 0;
        try {
            JsonNode node = new ObjectMapper().readTree(new URL(URI));
            latestMajor = node.get("major").asInt();
            latestMinor = node.get("minor").asInt();
            latestPatch = node.get("patch").asInt();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (latestPatch > CheckVersion.getPatchVersion()) {
            JOptionPane.showInputDialog(null, "\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u306e\u30d0\u30b0\u4fee\u6b63\u304c\u516c\u958b\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u3053\u3061\u3089\u304b\u3089\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n", RELEASE_STRING);
        } else if (latestMinor > CheckVersion.getMinorVersion()) {
            JOptionPane.showInputDialog(null, "\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u306e\u8efd\u5fae\u306a\u6a5f\u80fd\u6539\u4fee\u304c\u516c\u958b\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u3053\u3061\u3089\u304b\u3089\u6700\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n", RELEASE_STRING);
        } else if (latestMajor > CheckVersion.getMajorVersion()) {
            JOptionPane.showInputDialog(null, (Object)"\u5927\u898f\u6a21\u306a\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u306e\u66f4\u65b0\u304c\u516c\u958b\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u901f\u3084\u304b\u306b\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u3092\u304a\u9858\u3044\u3057\u307e\u3059\u3002\nhttps://github.com/hizumiaoba/DelesteRandomSelector/releases");
        }
    }

    public static String getVersion() {
        String value = "v" + CheckVersion.getMajorVersion() + "." + CheckVersion.getMinorVersion() + "." + CheckVersion.getPatchVersion();
        return value;
    }

    public static int getMajorVersion() {
        Version version = DelesteRandomSelector.class.getAnnotation(Version.class);
        return version.major();
    }

    public static int getMinorVersion() {
        Version version = DelesteRandomSelector.class.getAnnotation(Version.class);
        return version.minor();
    }

    public static int getPatchVersion() {
        Version version = DelesteRandomSelector.class.getAnnotation(Version.class);
        return version.patch();
    }
}

