/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.main;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.ranfa.lib.LimitedLog;
import com.ranfa.lib.Scraping;
import com.ranfa.lib.SettingJSONProperty;
import com.ranfa.lib.Settings;
import com.ranfa.lib.Song;
import com.ranfa.lib.TwitterIntegration;
import com.ranfa.lib.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

@Version(major=1, minor=2, patch=2)
public class DelesteRandomSelector
extends JFrame {
    private static ArrayList<Song> selectedSongsList = new ArrayList();
    private JPanel contentPane;
    private JPanel panelNorth;
    private JPanel panelWest;
    private JLabel labelVersion;
    private JLabel labelTitle;
    private JLabel labelDifficulty;
    private JLabel labelLevel;
    private JSpinner spinnerLevel;
    private JCheckBox checkMoreLv;
    private JCheckBox checkLessLv;
    private JPanel panelEast;
    private JPanel panelCentre;
    private JButton btnImport;
    private JButton btnStart;
    private JButton btnExit;
    private JComboBox comboDifficultySelect;
    private JLabel labelLvCaution;
    private JComboBox comboAttribute;
    private SettingJSONProperty property = new SettingJSONProperty();
    private JButton btnTwitterIntegration;
    private String[] integratorArray;
    private boolean integratorBool = false;
    private JTextArea textArea;
    private JScrollPane scrollPane;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DelesteRandomSelector frame = new DelesteRandomSelector();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public DelesteRandomSelector() {
        boolean isFirst;
        boolean bl = isFirst = !Scraping.databaseExists();
        if (isFirst) {
            JOptionPane.showMessageDialog(this, "\u697d\u66f2\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u81ea\u52d5\u7684\u306b\u4f5c\u6210\u3055\u308c\u307e\u3059\u2026\n\u6ce8\u610f\uff1a\u521d\u56de\u8d77\u52d5\u3067\u306f\u306a\u304f\u3001\u304b\u3064\u3001Jar\u30d5\u30a1\u30a4\u30eb\u3068\u540c\u3058\u968e\u5c64\u306b\"database.json\"\u3068\u3044\u3046\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3059\u308b\u306b\u3082\u95a2\u308f\u3089\u305a\n\u3053\u306e\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u304c\u51fa\u305f\u5834\u5408\u3001\u958b\u767a\u8005\u307e\u3067\u3054\u4e00\u5831\u304f\u3060\u3055\u3044\u3002\nGithub URL: https://github.com/hizumiaoba/DelesteRandomSelector/issues");
            if (!Scraping.writeToJson(Scraping.getWholeData())) {
                JOptionPane.showMessageDialog(this, "Exception:NullPointerException\\nCannot Keep up! Please re-download this Application!");
                throw new NullPointerException("FATAL: cannot continue!");
            }
        }
        ExecutorService es = Executors.newWorkStealingPool();
        CompletableFuture<ArrayList> getFromJsonFuture = CompletableFuture.supplyAsync(() -> Scraping.getFromJson(), es);
        CompletableFuture<ArrayList> getWholeDataFuture = CompletableFuture.supplyAsync(() -> Scraping.getWholeData(), es);
        if (!Settings.fileExists() && !Settings.writeDownJSON()) {
            JOptionPane.showMessageDialog(this, "Exception:NullPointerException\nCannot Keep up! Please re-download this Application!");
            throw new NullPointerException("FATAL: cannot continue!");
        }
        LimitedLog.println(this.getClass() + ":[DEBUG]: " + "Loading Settings...");
        this.property.setCheckLibraryUpdates(Settings.needToCheckLibraryUpdates());
        this.property.setCheckVersion(Settings.needToCheckVersion());
        this.property.setWindowWidth(Settings.getWindowWidth());
        this.property.setWindowHeight(Settings.getWindowHeight());
        this.property.setSongLimit(Settings.getSongsLimit());
        this.property.setSaveScoreLog(Settings.saveScoreLog());
        this.property.setOutputDebugSentences(Settings.outputDebugSentences());
        LimitedLog.println(this.getClass() + ":[DEBUG]: " + "Loading Settings done." + "\nVersion Check: " + this.property.isCheckVersion() + "\nLibrary Update Check: " + this.property.isCheckLibraryUpdates() + "\nWindow Width: " + this.property.getWindowWidth() + "\nWindow Height: " + this.property.getWindowHeight() + "\nSong Limit: " + this.property.getSongLimit() + "\nSaveScoreLog: " + this.property.isSaveScoreLog() + "\nOutputDebugSentences: " + this.property.isOutputDebugSentences());
        BiConsumer<ArrayList, ArrayList> updateConsumer = (list1, list2) -> {
            LimitedLog.println(this.getClass() + ":[INFO]: " + "Checking database updates...");
            if (list1.size() > list2.size()) {
                long time = System.currentTimeMillis();
                LimitedLog.println(this.getClass() + ":[INFO]: " + "Update detected.");
                Scraping.writeToJson(list1);
                LimitedLog.println(this.getClass() + ":[INFO]: " + "Update completed in " + (System.currentTimeMillis() - time) + "ms");
                LimitedLog.println(this.getClass() + ":[INFO]: " + "Updated database size: " + list1.size());
            } else {
                LimitedLog.println(this.getClass() + ":[INFO]: " + "database is up-to-date.");
            }
        };
        Runnable setEnabled = () -> {
            this.btnImport.setEnabled(true);
            this.btnImport.setText("<html><body>\u697d\u66f2<br>\u7d5e\u308a\u8fbc\u307f</body></html>");
        };
        getWholeDataFuture.thenAcceptAsync(list -> LimitedLog.println(this.getClass() + ":[INFO]: Scraping data size:" + list.size()), (Executor)es);
        getFromJsonFuture.thenAcceptAsync(list -> LimitedLog.println(this.getClass() + ":[INFO]: Currently database size:" + list.size()), (Executor)es);
        CompletionStage updatedFuture = getWholeDataFuture.thenAcceptBothAsync(getFromJsonFuture, updateConsumer, (Executor)es);
        ((CompletableFuture)updatedFuture).thenRunAsync(setEnabled, es);
        LimitedLog.println(this.getClass() + ":[DEBUG]: " + "Version:" + DelesteRandomSelector.getVersion());
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 640, 360);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.panelNorth = new JPanel();
        this.contentPane.add((Component)this.panelNorth, "North");
        this.panelNorth.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"max(302dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"40px")}, new RowSpec[]{RowSpec.decode((String)"20px")}));
        this.labelTitle = new JLabel("\u30c7\u30ec\u30b9\u30c6\u8ab2\u984c\u66f2\u30bb\u30ec\u30af\u30bf\u30fc");
        this.labelTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 16));
        this.panelNorth.add((Component)this.labelTitle, "1, 1, center, top");
        this.labelVersion = new JLabel(DelesteRandomSelector.getVersion());
        this.labelVersion.setFont(new Font("SansSerif", 1, 12));
        this.panelNorth.add((Component)this.labelVersion, "3, 1, right, top");
        this.panelWest = new JPanel();
        this.contentPane.add((Component)this.panelWest, "West");
        this.panelWest.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"112px:grow")}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"19px"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"12dlu"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(52dlu;default)")}));
        this.labelDifficulty = new JLabel("\u96e3\u6613\u5ea6\u9078\u629e");
        this.labelDifficulty.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWest.add((Component)this.labelDifficulty, "2, 2, center, default");
        this.comboDifficultySelect = new JComboBox();
        this.comboDifficultySelect.setFont(new Font("Dialog", 1, 12));
        this.comboDifficultySelect.setModel(new DefaultComboBoxModel<String>(new String[]{"\u6307\u5b9a\u306a\u3057", "DEBUT", "REGULAR", "PRO", "MASTER", "MASTER+", "\u24c1MASTER+", "LIGHT", "TRICK", "PIANO", "FORTE", "WITCH"}));
        this.panelWest.add((Component)this.comboDifficultySelect, "2, 4, fill, default");
        this.comboAttribute = new JComboBox();
        this.comboAttribute.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.comboAttribute.setModel(new DefaultComboBoxModel<String>(new String[]{"\u6307\u5b9a\u306a\u3057", "\u5168\u30bf\u30a4\u30d7", "\u30ad\u30e5\u30fc\u30c8", "\u30af\u30fc\u30eb", "\u30d1\u30c3\u30b7\u30e7\u30f3"}));
        this.panelWest.add((Component)this.comboAttribute, "2, 6, fill, default");
        this.labelLevel = new JLabel("\u697d\u66f2Lv");
        this.labelLevel.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWest.add((Component)this.labelLevel, "2, 8, center, default");
        this.spinnerLevel = new JSpinner();
        this.panelWest.add((Component)this.spinnerLevel, "2, 10");
        this.checkLessLv = new JCheckBox("\u6307\u5b9aLv\u4ee5\u4e0b");
        this.checkLessLv.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWest.add((Component)this.checkLessLv, "2, 12");
        this.checkMoreLv = new JCheckBox("\u6307\u5b9aLv\u4ee5\u4e0a");
        this.checkMoreLv.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWest.add((Component)this.checkMoreLv, "2, 14");
        this.labelLvCaution = new JLabel("<html><body>\u203b\u4ee5\u4e0b\u4ee5\u4e0a\u4e21\u65b9\u306b\u30c1\u30a7\u30c3\u30af\u3092\u3064\u3051\u308b\u3053\u3068\u3067\u6307\u5b9a\u30ec\u30d9\u30eb\u306e\u307f\u7d5e\u308a\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u3059</body></html>");
        this.labelLvCaution.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWest.add((Component)this.labelLvCaution, "2, 16, fill, fill");
        this.panelEast = new JPanel();
        this.contentPane.add((Component)this.panelEast, "East");
        this.panelEast.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"98px")}, new RowSpec[]{RowSpec.decode((String)"26px"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(36dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(30dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(15dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(11dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.btnImport = new JButton("<html><body>\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9<br>\u66f4\u65b0\u4e2d\u2026</body></html>");
        this.btnImport.setEnabled(false);
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Song> fromJson = Scraping.getFromJson();
                ArrayList<Song> specificlevelList = Scraping.getSpecificLevelSongs(fromJson, (Integer)DelesteRandomSelector.this.spinnerLevel.getValue(), DelesteRandomSelector.this.checkLessLv.isSelected(), DelesteRandomSelector.this.checkMoreLv.isSelected());
                ArrayList<Song> specificDifficultyList = Scraping.getSpecificDifficultySongs(specificlevelList, DelesteRandomSelector.this.comboDifficultySelect.getSelectedItem().toString());
                ArrayList<Song> specificAttributeList = Scraping.getSpecificAttributeSongs(specificDifficultyList, DelesteRandomSelector.this.comboAttribute.getSelectedItem().toString());
                if (!selectedSongsList.isEmpty()) {
                    selectedSongsList.clear();
                }
                selectedSongsList.addAll(specificAttributeList);
                LimitedLog.println(this.getClass() + ":[INFO]: " + "Songs are selected.We are Ready to go.");
                JOptionPane.showMessageDialog(null, "\u7d5e\u308a\u8fbc\u307f\u5b8c\u4e86\uff01\u300c\u958b\u59cb\u300d\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u3053\u3068\u3067\u9078\u66f2\u3067\u304d\u307e\u3059\uff01");
            }
        });
        this.btnImport.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelEast.add((Component)this.btnImport, "1, 3, fill, fill");
        this.btnStart = new JButton("\u958b\u59cb\uff01");
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Random random = new Random(System.currentTimeMillis());
                String[] tmp = new String[DelesteRandomSelector.this.property.getSongLimit()];
                DelesteRandomSelector.this.integratorArray = new String[DelesteRandomSelector.this.property.getSongLimit()];
                int i = 0;
                while (i < DelesteRandomSelector.this.property.getSongLimit()) {
                    int randomInt = random.nextInt(selectedSongsList.size());
                    tmp[i] = String.valueOf(i + 1) + "\u66f2\u76ee\uff1a " + ((Song)selectedSongsList.get(randomInt)).getAttribute() + " [" + ((Song)selectedSongsList.get(randomInt)).getDifficulty() + "]\u300c" + ((Song)selectedSongsList.get(randomInt)).getName() + "\u300d\uff01(Lv:" + ((Song)selectedSongsList.get(randomInt)).getLevel() + ")\n\n";
                    ((DelesteRandomSelector)DelesteRandomSelector.this).integratorArray[i] = String.valueOf(((Song)selectedSongsList.get(randomInt)).getName()) + "(Lv" + ((Song)selectedSongsList.get(randomInt)).getLevel() + ")\n";
                    ++i;
                }
                String paneString = "";
                int i2 = 0;
                while (i2 < tmp.length) {
                    paneString = String.valueOf(paneString) + tmp[i2];
                    ++i2;
                }
                paneString = String.valueOf(paneString) + "\u3053\u306e" + tmp.length + "\u66f2\u3092\u30d7\u30ec\u30a4\u3057\u307e\u3057\u3087\u3046\uff01\uff01\uff01";
                DelesteRandomSelector.this.textArea.setText(paneString);
                DelesteRandomSelector.this.integratorBool = true;
                LimitedLog.println(this.getClass() + ":[INFO]: " + "show up completed.");
            }
        });
        this.btnStart.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelEast.add((Component)this.btnStart, "1, 7, fill, fill");
        this.btnTwitterIntegration = new JButton("Twitter\u9023\u643a");
        this.btnTwitterIntegration.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 11));
        this.btnTwitterIntegration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LimitedLog.println(this.getClass() + ":[INFO]: " + "Twitter Integration requested.Verify permission status.");
                boolean authorizationStatus = TwitterIntegration.authorization();
                LimitedLog.println(this.getClass() + ":[INFO]: " + "Permission Verifying completed.\nStatus: " + authorizationStatus);
                LimitedLog.print(this.getClass() + ":[INFO]: " + "Construction status message...");
                String updatedStatus = "\u30c7\u30ec\u30b9\u30c6\u8ab2\u984c\u66f2\u30bb\u30ec\u30af\u30bf\u30fc\u3067\n";
                int lengthLimit = updatedStatus.length();
                boolean isBroken = false;
                if (!DelesteRandomSelector.this.integratorBool) {
                    JOptionPane.showMessageDialog(null, "\u3061\u3072\u308d\u300c\u307e\u3060\u30d7\u30ec\u30a4\u3092\u59cb\u3081\u3066\u3044\u306a\u3044\u307f\u305f\u3044\u3067\u3059\u306d\u300d");
                    LimitedLog.println();
                    return;
                }
                int i = 0;
                while (i < DelesteRandomSelector.this.integratorArray.length) {
                    updatedStatus = String.valueOf(updatedStatus) + DelesteRandomSelector.this.integratorArray[i];
                    if ((lengthLimit += DelesteRandomSelector.this.integratorArray[i].length()) > 69) {
                        isBroken = true;
                        break;
                    }
                    ++i;
                }
                updatedStatus = isBroken ? String.valueOf(updatedStatus) + "\u2026\u305d\u306e\u4ed6\u6570\u66f2\n\u3092\u30d7\u30ec\u30a4\u3057\u307e\u3057\u305f\uff01\n#DelesteRandomSelector #\u30c7\u30ec\u30b9\u30c6 " : String.valueOf(updatedStatus) + "\u3092\u30d7\u30ec\u30a4\u3057\u307e\u3057\u305f\uff01\n#DelesteRandomSelector #\u30c7\u30ec\u30b9\u30c6 ";
                LimitedLog.println("completed.\n" + updatedStatus);
                lengthLimit = updatedStatus.length();
                if (authorizationStatus) {
                    int option = JOptionPane.showConfirmDialog(null, "Twitter\u3078\u4ee5\u4e0b\u306e\u5185\u5bb9\u3092\u6295\u7a3f\u3057\u307e\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f\n\n" + updatedStatus + "\n\n\u6587\u5b57\u6570\uff1a" + lengthLimit);
                    LimitedLog.println(this.getClass() + ":[INFO]: " + "User selected " + option);
                    switch (option) {
                        case 0: {
                            TwitterIntegration.PostTwitter(updatedStatus);
                            LimitedLog.println(this.getClass() + ":[INFO]: " + "Success to update the status.");
                            JOptionPane.showMessageDialog(null, "\u6295\u7a3f\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                            break;
                        }
                        case 1: {
                            LimitedLog.println(this.getClass() + ":[INFO]: " + "There is no will to post.");
                            break;
                        }
                        case 2: {
                            LimitedLog.println(this.getClass() + ":[INFO]: " + "The Operation was canceled by user.");
                            break;
                        }
                    }
                } else {
                    LimitedLog.println(this.getClass() + ":[WARN]: " + "seems to reject the permission.it should need try again.");
                }
            }
        });
        this.panelEast.add((Component)this.btnTwitterIntegration, "1, 11");
        this.btnExit = new JButton("\u7d42\u4e86");
        this.btnExit.addActionListener(new ActionListener((CompletableFuture)updatedFuture){
            private final /* synthetic */ CompletableFuture val$updatedFuture;
            {
                this.val$updatedFuture = completableFuture;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LimitedLog.println(this.getClass() + ":[INFO]: " + "Requested Exit by Button");
                if (this.val$updatedFuture.isDone()) {
                    System.exit(0);
                } else {
                    JOptionPane.showMessageDialog(null, "\u975e\u540c\u671f\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u5c11\u3057\u6642\u9593\u304c\u7d4c\u3063\u3066\u304b\u3089\u3084\u308a\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            }
        });
        this.btnExit.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelEast.add((Component)this.btnExit, "1, 13");
        this.panelCentre = new JPanel();
        this.contentPane.add((Component)this.panelCentre, "Center");
        this.panelCentre.setLayout(new BorderLayout(0, 0));
        this.textArea = new JTextArea();
        this.textArea.setText("\u697d\u66f2\u9078\u629e\u306e\u624b\u9806\r\n\uff11\uff0e\u96e3\u6613\u5ea6\u3001\u5c5e\u6027\u3001\u30ec\u30d9\u30eb\u3092\u9078\u629e\u3059\u308b\r\n\uff12\uff0e\u300c\u697d\u66f2\u53d6\u308a\u8fbc\u307f\u300d\u30dc\u30bf\u30f3\u3092\u62bc\u3059\uff01\r\n\uff13\uff0e\u300c\u958b\u59cb\u300d\u30dc\u30bf\u30f3\u3092\u62bc\u3059\uff01\r\n\uff14\uff0e\u9078\u629e\u3055\u308c\u305f\u697d\u66f2\u304c\u3053\u3053\u306b\u8868\u793a\u3055\u308c\u307e\u3059\uff01\r\n\u73fe\u5728\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u697d\u66f2\u9078\u629e\u306e\u6700\u5927\u6570\uff1a" + this.property.getSongLimit());
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.panelCentre.add((Component)this.scrollPane, "Center");
        if (isFirst) {
            setEnabled.run();
        }
    }

    public static String getVersion() {
        String value = "v" + DelesteRandomSelector.getMajorVersion() + "." + DelesteRandomSelector.getMinorVersion() + "." + DelesteRandomSelector.getPatchVersion();
        return value;
    }

    public static int getMajorVersion() {
        Version version = DelesteRandomSelector.class.getAnnotation(Version.class);
        return version.major();
    }

    public static int getMinorVersion() {
        Version version = DelesteRandomSelector.class.getAnnotation(Version.class);
        return version.minor();
    }

    public static int getPatchVersion() {
        Version version = DelesteRandomSelector.class.getAnnotation(Version.class);
        return version.patch();
    }
}

