#define _XOPEN_SOURCE

#include "global.h"
#include "struct.h"
#include "enum.h"

// 特殊文字置換後の文字数が、PATH_LENの3倍以内に収まる、という暗黙の了解。
#define REPLACE_LEN PATH_LEN * 3

#include "log.h"
#include "snowcp.h"
#include "string_replace.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>
#include <alloca.h>
#include <pthread.h>

struct hash_data
{
	FILE *from_pipe;
	FILE *to_pipe;
	char *from_pipe_buf;
	char *to_pipe_buf;
	char *from_command;
	char *to_command;
	int read_size;
};

// 関数プロトタイプ
void hash_function(char *from, char *to, const char copy_mode, const char check_mode);
static void * from_check(void *tmp);
static void * to_check(void *tmp);

/*******************************************************************************
sha1sumかmd5sumを起動する
*******************************************************************************/
void hash_function(char *from, char *to, const char copy_mode, const char check_mode)
{
	struct hash_data tmp;
	char *from_re = malloc(REPLACE_LEN);
	char *to_re = malloc(REPLACE_LEN);
	tmp.from_pipe = NULL;
	tmp.to_pipe = NULL;
	tmp.from_pipe_buf = alloca(PATH_LEN);
	tmp.to_pipe_buf = alloca(PATH_LEN);

	// ゼロクリア。 VC++で最適化を行うと、こういうコードは除去されるらしい。
	// http://www.ipa.go.jp/security/awareness/vendor/programmingv2/contents/c606.html
	memset(tmp.from_pipe_buf, 0, PATH_LEN);
	memset(tmp.to_pipe_buf, 0, PATH_LEN);

	strcpy(from_re, from);
	strcpy(to_re, to);

	// 特殊文字の置換
	// bashのみ対応、他は未確認。
	// かならず最初に\を置換する。
	string_replace(from_re, "\\", "\\\\", REPLACE_LEN);
	string_replace(from_re, "\"", "\\\"", REPLACE_LEN);
	string_replace(from_re, "`", "\\`", REPLACE_LEN);
	string_replace(from_re, "$", "\\$", REPLACE_LEN);

	string_replace(to_re, "\\", "\\\\", REPLACE_LEN);
	string_replace(to_re, "\"", "\\\"", REPLACE_LEN);
	string_replace(to_re, "`", "\\`", REPLACE_LEN);
	string_replace(to_re, "$", "\\$", REPLACE_LEN);

	tmp.from_command = alloca(REPLACE_LEN);
	tmp.to_command = alloca(REPLACE_LEN);

	// 特殊文字を置換済みの場合、'や"で括ると動作しなくなる
	// 'で括る場合、文字列中に'があると動作しない。
	// なので"でくくる。
	if(check_mode == SHA1SUM)
	{
		sprintf(tmp.from_command, "%s%s%s%s", "sha1sum -- ", "\"", from_re, "\"");
		sprintf(tmp.to_command, "%s%s%s%s", "sha1sum -- ", "\"", to_re, "\"");
	}
	else if(check_mode == MD5SUM)
	{
		sprintf(tmp.from_command, "%s%s%s%s", "md5sum -- ", "\"", from_re, "\"");
		sprintf(tmp.to_command, "%s%s%s%s", "md5sum -- ", "\"", to_re, "\"");
	}

	errno = 0;
	if(copy_mode == DIFFERENT)
	{
		pthread_t t1;
		pthread_t t2;
		pthread_create(&t1, NULL, from_check, (void *)&tmp);
		pthread_create(&t2, NULL, to_check, (void *)&tmp);
		pthread_join(t1, NULL);
		pthread_join(t2, NULL);
	}
	else
	{
		tmp.from_pipe = popen(tmp.from_command, "r");
		tmp.to_pipe = popen(tmp.to_command, "r");
	}

	if((tmp.from_pipe != NULL) && (tmp.to_pipe != NULL))
	{
		char c[PATH_LEN];

		tmp.read_size = fread(tmp.from_pipe_buf, 1, PATH_LEN, tmp.from_pipe);
		// パイプのバッファを空にするためにグルグル回す
		while(fread(c, 1, PATH_LEN, tmp.from_pipe) > 0) {}

		tmp.read_size = fread(tmp.to_pipe_buf, 1, PATH_LEN, tmp.to_pipe);
		while(fread(c, 1, PATH_LEN, tmp.to_pipe) > 0) {}

		// チェックしとかないと (半角スペース)が含まれていない場合SIGSEGVで落ちる
		if(strstr(tmp.from_pipe_buf, " ") && strstr(tmp.to_pipe_buf, " "))
		{
			char *f_rom = strtok(tmp.from_pipe_buf, " ");
			char *t_o = strtok(tmp.to_pipe_buf, " ");

			// Ubuntu 10.10で、ファイル名に\が含まれているファイルをsha1sumやmd5sumに渡すと、
			// 何故かハッシュ値の前に\が挿入されるっぽい。バグか？
			// その所為で文字列の長さが33や41になってハッシュ値が不一致と判定されるので、
			// 文字列の先頭が\だった場合、文字列を一つ前にずらす。
			if(f_rom[0] == '\\')
				memmove(f_rom, f_rom + 1, strlen(f_rom));
			if(t_o[0] == '\\')
				memmove(t_o, t_o + 1, strlen(t_o));

			if((strcmp(f_rom, t_o) == 0) && ((strlen(f_rom) == 32) || (strlen(f_rom) == 40)))
			{
				if(V == VERBOS)
					printf("%sのハッシュ値が一致しました\n", to);

				if(L == LOG)
					log_compare(from, f_rom, to, t_o, true);
			}
			else
			{
				log_errors(__FILE__, __LINE__, errno, to);
				fprintf(stderr, "ハッシュ値が一致しませんでした\n");
				fprintf(stderr, "%sを削除します。\n", to);
				log_compare(from, f_rom, to, t_o, false);
				unlink(to);
			}
		}
		else
		{
			log_errors(__FILE__, __LINE__, errno, to);
			log_compare(from, "NULL", to, "NULL", false);
		}
	}
	else
	{
		log_errors(__FILE__, __LINE__, errno, to);
		log_compare(from, "NULL", to, "NULL", false);
	}

	// 念のため、pipe詰まり対策
	for(;;)
	{
		tmp.read_size = 0;
		tmp.read_size += fread(tmp.from_pipe_buf, 1, PATH_LEN, tmp.from_pipe);
		tmp.read_size += fread(tmp.to_pipe_buf, 1, PATH_LEN, tmp.to_pipe);
		if(tmp.read_size <= 0)
			break;
	}

	pclose(tmp.from_pipe);
	pclose(tmp.to_pipe);

	free(from_re);
	free(to_re);
}

/*******************************************************************************
他のアプリケーションを実行する。
仮引数がvoid *なのはpthreadの為。
*******************************************************************************/
static void * from_check(void *tmp)
{
	struct hash_data *tmp2 = (struct hash_data *)tmp;
	tmp2->from_pipe = popen(tmp2->from_command, "r");

	return NULL;
}

/*******************************************************************************
他のアプリケーションを実行する。
仮引数がvoid *なのはpthreadの為。
*******************************************************************************/
static void * to_check(void *tmp)
{
	struct hash_data *tmp2 = (struct hash_data *)tmp;
	tmp2->to_pipe = popen(tmp2->to_command, "r");

	return NULL;
}
