/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.renderer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.bootchart.common.BootStats;
import org.bootchart.renderer.ImageRenderer;
import org.jibble.epsgraphics.EpsGraphics2D;

public class EPSRenderer
extends ImageRenderer {
    private static final Logger log = Logger.getLogger(EPSRenderer.class.getName());
    public static final boolean COMPRESS_EPS = true;

    @Override
    public void render(Properties properties, BootStats bootStats, OutputStream outputStream) throws IOException {
        this.g = new EpsGraphics2D();
        this.allowAlpha = false;
        super.render(properties, bootStats, null);
        log.fine("Writing image");
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
        gZIPOutputStream.write(this.g.toString().getBytes());
        gZIPOutputStream.close();
    }

    @Override
    public String getFileSuffix() {
        return "eps.gz";
    }
}

