/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.parser.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.bootchart.common.CPUSample;
import org.bootchart.common.Common;
import org.bootchart.common.Process;
import org.bootchart.common.ProcessSample;
import org.bootchart.common.PsStats;
import org.bootchart.common.Sample;
import org.bootchart.parser.linux.PacctParser;

public class PsParser {
    private static final Logger log = Logger.getLogger(PsParser.class.getName());
    private static Map COLUMN_TYPES = new HashMap();

    public static PsStats parseLog(InputStream inputStream, Map map, Map map2) throws IOException {
        Object object;
        Object object22;
        BufferedReader bufferedReader = Common.getReader(inputStream);
        String string = bufferedReader.readLine();
        TreeMap<Integer, Process> treeMap = new TreeMap<Integer, Process>();
        int n = 0;
        Date date = null;
        Date date2 = null;
        while (string != null) {
            while (string != null && string.trim().length() == 0) {
                string = bufferedReader.readLine();
            }
            if (string == null) break;
            if ((string = string.trim()).startsWith("#")) continue;
            if (string.matches("^\\d+$")) {
                date2 = new Date(Long.parseLong(string) * 10L);
                if (date == null) {
                    date = date2;
                }
                ++n;
            } else {
                string = bufferedReader.readLine();
                continue;
            }
            string = bufferedReader.readLine();
            if (string == null) break;
            String[] stringArray = string.trim().split("\\s+");
            string = bufferedReader.readLine();
            if (string == null) break;
            while (string != null && string.trim().length() > 0) {
                int n2;
                Number number;
                Process process;
                int n3;
                string = string.trim();
                object22 = string.split("\\s+");
                Object object3 = new HashMap();
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    if (stringArray[n3].equals("CMD")) {
                        object = new StringBuffer();
                        for (int i = n3; i < ((String[])object22).length; ++i) {
                            if (((StringBuffer)object).length() > 0) {
                                ((StringBuffer)object).append(" ");
                            }
                            ((StringBuffer)object).append(object22[i]);
                        }
                        object22[n3] = ((StringBuffer)object).toString();
                    }
                    try {
                        object = PsParser.getObject(object22[n3], stringArray[n3]);
                        object3.put(stringArray[n3], object);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.fine("Error parsing: " + stringArray[n3] + " (" + object22[n3] + ")");
                        object3.put(stringArray[n3], null);
                    }
                }
                n3 = (Integer)object3.get("PID");
                object = (String)object3.get("CMD");
                if (object == null) {
                    object = (String)object3.get("COMMAND");
                }
                if ((object = Common.formatCommand((String)object)) == null || ((String)object).length() == 0) {
                    object = "(unknown)";
                }
                if (map != null && map.containsKey((Integer)object3.get("PID"))) {
                    object = (String)map.get((Integer)object3.get("PID"));
                }
                if ((process = (Process)treeMap.get(new Integer(n3))) == null) {
                    List list;
                    number = (Integer)object3.get("PPID");
                    process = new Process(n3, (String)object);
                    if (number != null) {
                        process.ppid = (Integer)number;
                    }
                    if (map2 != null && (list = PacctParser.getPPIDs(n3, map2)) != null) {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            n2 = (Integer)iterator.next();
                            if (!treeMap.containsKey(new Integer(n2))) continue;
                            process.ppid = n2;
                            break;
                        }
                    }
                    treeMap.put(new Integer(n3), process);
                } else {
                    process.cmd = object;
                }
                number = (Double)object3.get("%CPU");
                double d = number != null ? (Double)number / 100.0 : 0.0;
                d = Math.max(0.0, Math.min(1.0, d));
                n2 = PsParser.getState((Map)object3);
                if (d > 0.0) {
                    n2 = 1;
                }
                if (n2 != 2) {
                    process.active = true;
                }
                CPUSample cPUSample = new CPUSample(null, d, 0.0, 0.0);
                ProcessSample processSample = new ProcessSample(date2, n2, cPUSample, null, null);
                process.samples.add(processSample);
                string = bufferedReader.readLine();
            }
            if (n <= 4500) continue;
            break;
        }
        log.fine("Parsed " + n + " ps samples " + "(" + treeMap.values().size() + " processes)");
        for (Object object22 : treeMap.values()) {
            if (object22.ppid == -1) continue;
            object22.parent = (Process)treeMap.get(new Integer(object22.ppid));
            if (object22.parent != null) continue;
            log.fine("No parent for: " + object22);
        }
        int n4 = (int)(date2.getTime() - date.getTime()) / n;
        log.fine("Sample period: " + n4);
        for (Object object3 : treeMap.values()) {
            Sample sample = (Sample)((Process)object3).samples.get(0);
            object = (Sample)((Process)object3).samples.get(((Process)object3).samples.size() - 1);
            ((Process)object3).startTime = sample.time;
            ((Process)object3).duration = ((Sample)object).time.getTime() - sample.time.getTime() + (long)n4;
        }
        object22 = new PsStats();
        object22.processList = new ArrayList(treeMap.values());
        object22.startTime = date;
        object22.endTime = date2;
        object22.samplePeriod = n4;
        return object22;
    }

    private static Object getObject(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = (String)COLUMN_TYPES.get(string2);
        if (string3 == null) {
            string3 = String.class.getName();
        }
        if (string3.equals(Integer.class.getName())) {
            return new Integer(string);
        }
        if (string3.equals(Double.class.getName())) {
            return new Double(string);
        }
        if (string3.equals(String.class.getName())) {
            if (string.equals("-")) {
                return null;
            }
            return string;
        }
        return string;
    }

    public static int getState(Map map) {
        String string = (String)map.get("S");
        if (string == null) {
            string = (String)map.get("STAT");
        }
        if ("D".equals(string)) {
            return 3;
        }
        if ("R".equals(string)) {
            return 1;
        }
        if ("S".equals(string)) {
            return 2;
        }
        if ("T".equals(string)) {
            return 4;
        }
        if ("Z".equals(string)) {
            return 5;
        }
        return 0;
    }

    static {
        COLUMN_TYPES.put("PID", Integer.class.getName());
        COLUMN_TYPES.put("PPID", Integer.class.getName());
        COLUMN_TYPES.put("S", String.class.getName());
        COLUMN_TYPES.put("STAT", String.class.getName());
        COLUMN_TYPES.put("%CPU", Double.class.getName());
        COLUMN_TYPES.put("COMMAND", String.class.getName());
        COLUMN_TYPES.put("CMD", String.class.getName());
    }
}

