/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.parser.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bootchart.common.Common;
import org.bootchart.common.DiskTPutSample;
import org.bootchart.common.DiskUtilSample;
import org.bootchart.common.Sample;
import org.bootchart.common.Stats;

public class ProcDiskStatParser {
    private static final Logger log = Logger.getLogger(ProcDiskStatParser.class.getName());
    private static final String DISK_REGEX = "hd.|sd.";

    public static Stats parseLog(InputStream inputStream, int n) throws IOException {
        BufferedReader bufferedReader = Common.getReader(inputStream);
        String string = bufferedReader.readLine();
        int n2 = 0;
        Stats stats = new Stats();
        Date date = null;
        HashMap<String, DiskStatSample> hashMap = new HashMap<String, DiskStatSample>();
        while (string != null) {
            while (string != null && string.trim().length() == 0) {
                string = bufferedReader.readLine();
            }
            if (string == null) break;
            if ((string = string.trim()).startsWith("#")) continue;
            Date date2 = null;
            if (string.matches("^\\d+$")) {
                date2 = new Date(Long.parseLong(string) * 10L);
                ++n2;
            } else {
                string = bufferedReader.readLine();
                continue;
            }
            string = bufferedReader.readLine();
            while (string != null && string.trim().length() > 0) {
                String[] stringArray = (string = string.trim()).split("\\s+");
                if (stringArray.length != 14 || !stringArray[2].matches(DISK_REGEX)) {
                    string = bufferedReader.readLine();
                    continue;
                }
                String string2 = stringArray[2];
                long l = Long.parseLong(stringArray[5]);
                long l2 = Long.parseLong(stringArray[9]);
                long l3 = Long.parseLong(stringArray[12]);
                DiskStatSample diskStatSample = (DiskStatSample)hashMap.get(string2);
                if (diskStatSample == null) {
                    diskStatSample = new DiskStatSample();
                    hashMap.put(string2, diskStatSample);
                }
                if (date != null) {
                    diskStatSample.changes[0] = l - diskStatSample.values[0];
                    diskStatSample.changes[1] = l2 - diskStatSample.values[1];
                    diskStatSample.changes[2] = l3 - diskStatSample.values[2];
                }
                diskStatSample.values = new long[]{l, l2, l3};
                string = bufferedReader.readLine();
            }
            if (date != null) {
                long l = date2.getTime() - date.getTime();
                l = Math.max(l, 1L);
                long[] lArray = new long[3];
                for (Map.Entry entry : hashMap.entrySet()) {
                    DiskStatSample diskStatSample = (DiskStatSample)entry.getValue();
                    for (int i = 0; i < 3; ++i) {
                        int n3 = i;
                        lArray[n3] = lArray[n3] + diskStatSample.changes[i];
                    }
                }
                double d = (double)lArray[0] / 2.0 * 1000.0 / (double)l;
                double d2 = (double)lArray[1] / 2.0 * 1000.0 / (double)l;
                double d3 = (double)lArray[2] / (double)l / (double)n;
                d3 = Math.max(0.0, Math.min(1.0, d3));
                DiskTPutSample diskTPutSample = new DiskTPutSample(date2, d, d2);
                DiskUtilSample diskUtilSample = new DiskUtilSample(date2, d3);
                stats.addSample(diskTPutSample);
                stats.addSample(diskUtilSample);
            }
            date = date2;
            if (n2 <= 4500) continue;
            break;
        }
        log.fine("Parsed " + stats.getSamples().size() + " /proc/diskstats samples");
        return stats;
    }

    public static double getMaxDiskTPut(List list) {
        double d = 0.0;
        for (Sample sample : list) {
            if (!(sample instanceof DiskTPutSample)) continue;
            DiskTPutSample diskTPutSample = (DiskTPutSample)sample;
            double d2 = diskTPutSample.read + diskTPutSample.write;
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private static class DiskStatSample {
        long[] values = new long[3];
        long[] changes = new long[3];

        private DiskStatSample() {
        }
    }
}

