/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.parser.linux;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class PacctParser {
    private static final Logger log = Logger.getLogger(PacctParser.class.getName());

    public static Map parseLog(InputStream inputStream) throws IOException {
        HashMap<Integer, ArrayList<Integer>> hashMap = new HashMap<Integer, ArrayList<Integer>>();
        while (inputStream.available() > 0) {
            inputStream.read();
            byte by = (byte)inputStream.read();
            if (by < 3) {
                log.warning("Invalid accounting version: " + by);
                return null;
            }
            for (int i = 0; i < 14; ++i) {
                inputStream.read();
            }
            Integer n = new Integer((int)PacctParser.readUInt32(inputStream));
            Integer n2 = new Integer((int)PacctParser.readUInt32(inputStream));
            ArrayList<Integer> arrayList = (ArrayList<Integer>)hashMap.get(n2);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
            }
            arrayList.add(n);
            hashMap.put(n2, arrayList);
            for (int i = 0; i < 24; ++i) {
                inputStream.read();
            }
            byte[] byArray = new byte[16];
            inputStream.read(byArray);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length && byArray[i] != 0; ++i) {
                stringBuffer.append((char)byArray[i]);
            }
        }
        return hashMap;
    }

    private static long readUInt32(InputStream inputStream) throws IOException {
        return inputStream.read() & 0xFF | (inputStream.read() & 0xFF) << 8 | (inputStream.read() & 0xFF) << 16 | (inputStream.read() & 0xFF) << 24;
    }

    public static List getPPIDs(int n, Map map) {
        if (map == null) {
            return null;
        }
        Integer n2 = null;
        Integer n3 = new Integer(n);
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            if (!list.contains(n3)) continue;
            n2 = (Integer)entry.getKey();
            break;
        }
        if (n2 == null) {
            return null;
        }
        if (n2 != n) {
            Map.Entry entry;
            List list = PacctParser.getPPIDs(n2, map);
            entry = new ArrayList();
            entry.add(n2);
            if (list != null) {
                entry.addAll(list);
            }
            return entry;
        }
        return null;
    }
}

