/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HeaderParser {
    public static Properties parseLog(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    public static Properties oldParseLog(BufferedReader bufferedReader) throws IOException {
        Properties properties = new Properties();
        String string = bufferedReader.readLine();
        ArrayList<String> arrayList = new ArrayList<String>();
        bufferedReader.mark(8096);
        while (string != null && string.trim().length() > 0) {
            if (string.startsWith("#")) {
                arrayList.add(string.replaceFirst("#", "").trim());
            }
            bufferedReader.mark(8096);
            string = bufferedReader.readLine();
        }
        bufferedReader.reset();
        if (arrayList.size() > 4) {
            properties.put("title", arrayList.get(0));
            properties.put("system.uname", arrayList.get(1));
            properties.put("system.release", arrayList.get(2));
            properties.put("system.cpu", arrayList.get(3));
            properties.put("system.kernel.options", arrayList.get(4));
        }
        return properties;
    }

    public static int getNumCPUs(Properties properties) {
        if (properties == null) {
            return 1;
        }
        String string = (String)properties.get("system.cpu");
        if (string == null) {
            return 1;
        }
        Pattern pattern = Pattern.compile(".*\\((\\d+)\\)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 1;
    }
}

