/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.bootchart.common.Process;

public class Common {
    public static final String VERSION = "bootchart 0.9";
    public static final Locale LOCALE = Locale.US;
    public static final List PROC_PARAM = Arrays.asList("init", "udev", "initlog", "modprobe", "rc", "ifup", "ifconfig", "cat", "sed", "awk", "grep", "hotplug", "default.hotplug", "05-wait_for_sysfs.hotplug", "20-hal.hotplug");
    public static final int MAX_PARSE_SAMPLES = 4500;
    private static final DateFormat DESC_TIME_FORMAT = new SimpleDateFormat("mm:ss.SSS", LOCALE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFile(File file) throws IOException {
        InputStream inputStream = null;
        String string = file.getPath();
        if (file.exists()) {
            inputStream = new FileInputStream(string);
        } else {
            string = "/" + string.replaceFirst("\\./", "");
            inputStream = Common.class.getResourceAsStream(string);
        }
        if (inputStream == null) {
            throw new FileNotFoundException("File or resource " + string + " not found");
        }
        try {
            int n;
            byte[] byArray = new byte[8096];
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStream.read(byArray)) >= 0) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        finally {
            inputStream.close();
        }
    }

    public static BufferedReader getReader(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
        return bufferedReader;
    }

    public static double parseDouble(String string) {
        return Double.parseDouble(string.replaceAll(",", "."));
    }

    public static String formatCommand(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.replaceFirst(" <defunct>", "")).matches("\\[.+\\]")) {
            string = string.substring(1, string.length() - 1);
        }
        String[] stringArray = string.trim().split("\\s+");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0 && stringArray.length > 1 && (stringArray[i].matches(".*/?sh") || stringArray[i].matches(".*/?bash") || stringArray[i].matches(".*/?python") || stringArray[i].matches(".*/?perl")) || stringArray[i].startsWith("-") && stringArray.length > 1) continue;
            String string2 = stringArray[i];
            if (string2.startsWith("/") || string2.startsWith("./") || string2.startsWith("../")) {
                string2 = string2.substring(string2.lastIndexOf(47) + 1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (PROC_PARAM.contains(string2)) {
                for (int j = i + 1; j < stringArray.length; ++j) {
                    if (stringArray[j].startsWith("-")) continue;
                    stringBuffer.append(" " + Common.formatCommand(stringArray[j]));
                    break;
                }
            }
            string2 = string2 + stringBuffer.toString();
            return string2;
        }
        return null;
    }

    public static String getProcessDesc(Process process, Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(process.pid + " " + process.cmd + "\n");
        Date date2 = new Date(process.startTime.getTime() - date.getTime());
        stringBuffer.append("Start time: " + DESC_TIME_FORMAT.format(date2) + "\n");
        stringBuffer.append("Duration: " + DESC_TIME_FORMAT.format(new Date(process.duration)));
        if (process.desc != null && process.desc.length() > 0) {
            stringBuffer.append("\n\n" + process.desc);
        }
        return stringBuffer.toString();
    }

    public static boolean isPNGSupported() {
        String string = System.getProperty("java.vm.info");
        return string != null && string.indexOf("gcj") == -1;
    }

    public static class LogFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File file, String string) {
            return string.startsWith("bootchart") && string.endsWith(".tgz");
        }
    }
}

