/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.compress.tar.TarEntry;
import org.apache.commons.compress.tar.TarInputStream;
import org.bootchart.common.BootStats;
import org.bootchart.common.Common;
import org.bootchart.common.ProcessTree;
import org.bootchart.common.PsStats;
import org.bootchart.common.Stats;
import org.bootchart.parser.HeaderParser;
import org.bootchart.parser.linux.PacctParser;
import org.bootchart.parser.linux.PidNameParser;
import org.bootchart.parser.linux.ProcDiskStatParser;
import org.bootchart.parser.linux.ProcPsParser;
import org.bootchart.parser.linux.ProcStatParser;
import org.bootchart.parser.linux.PsParser;
import org.bootchart.renderer.EPSRenderer;
import org.bootchart.renderer.PNGRenderer;
import org.bootchart.renderer.Renderer;
import org.bootchart.renderer.SVGRenderer;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class.getName());
    private static final String DEFAULT_FORMAT = Common.isPNGSupported() ? "png" : "svg";

    public static void main(String[] stringArray) throws Exception {
        Object object;
        File file4;
        long l = System.currentTimeMillis();
        Options options = Main.getOptions();
        GnuParser gnuParser = new GnuParser();
        CommandLine commandLine = null;
        try {
            commandLine = gnuParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            Main.printUsage(options);
            System.exit(1);
        }
        if (commandLine.hasOption("h")) {
            Main.printUsage(options);
            System.exit(0);
        }
        if (commandLine.hasOption("v")) {
            System.out.println("bootchart 0.9");
            System.exit(0);
        }
        boolean bl = true;
        File file2 = new File(".");
        String string = DEFAULT_FORMAT;
        if (commandLine.hasOption("o")) {
            file2 = new File(commandLine.getOptionValue("o"));
        }
        if (commandLine.hasOption("f")) {
            string = commandLine.getOptionValue("f");
        }
        if (commandLine.hasOption("n")) {
            bl = false;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray2 = commandLine.getArgs();
        for (int i = 0; i < stringArray2.length; ++i) {
            file4 = new File(stringArray2[i]);
            if (!file4.exists()) {
                System.err.println(file4 + " not found");
                System.exit(1);
            }
            if (file4.isDirectory()) {
                object = file4.listFiles(new Common.LogFileFilter());
                arrayList.addAll(Arrays.asList(object));
                continue;
            }
            arrayList.add(file4);
        }
        if (stringArray2.length == 0) {
            File file3 = new File("/var/log/bootchart.tgz");
            file4 = new File("/var/log/bootchart");
            if (file3.exists()) {
                arrayList.add(file3);
            } else if (file4.exists()) {
                arrayList.add(file4);
            } else {
                System.err.println(file3 + " not found");
                System.exit(1);
            }
        }
        for (File file4 : arrayList) {
            System.out.println("Parsing " + file4.getPath());
            object = file4.getName();
            object = ((String)object).replaceFirst("\\.?tgz$", "");
            object = ((String)object).replaceFirst("\\.?gz$", "");
            object = ((String)object).replaceFirst("\\.?tar$", "");
            String string2 = file2 + "/" + (String)object;
            Main.render(file4, string, bl, string2);
        }
        l = System.currentTimeMillis() - l;
        log.fine("Bootchart took " + l + "ms");
    }

    public static String render(File file, String string, boolean bl, String string2) throws IOException {
        Object object;
        Object object2;
        boolean bl2;
        if (!file.exists()) {
            return null;
        }
        TarInputStream tarInputStream = null;
        Object[] objectArray = null;
        if (file.isFile()) {
            bl2 = true;
            object2 = new FileInputStream(file);
            if (file.getName().endsWith("gz")) {
                object2 = new GZIPInputStream((InputStream)object2);
            }
            tarInputStream = new TarInputStream((InputStream)object2);
        } else {
            bl2 = false;
            objectArray = file.listFiles();
            Arrays.sort(objectArray);
        }
        object2 = new Properties();
        Map map = null;
        Map map2 = null;
        Stats stats = null;
        Stats stats2 = null;
        PsStats psStats = null;
        BootStats bootStats = null;
        int n = 1;
        String string3 = null;
        boolean bl3 = true;
        int n2 = 0;
        while (bl3) {
            String string4 = null;
            InputStream inputStream = null;
            object = null;
            if (bl2) {
                object = tarInputStream.getNextEntry();
                if (object == null) {
                    bl3 = false;
                    break;
                }
                string4 = ((TarEntry)object).getName();
                inputStream = tarInputStream;
            } else {
                string4 = ((File)objectArray[n2]).getName();
                inputStream = new FileInputStream((File)objectArray[n2]);
                if (++n2 >= objectArray.length) {
                    bl3 = false;
                }
            }
            log.fine("Parsing log file: " + string4);
            if (string4.equals("header")) {
                object2 = HeaderParser.parseLog(inputStream);
                if (object2 != null) {
                    string3 = ((Properties)object2).getProperty("profile.process");
                }
                n = HeaderParser.getNumCPUs((Properties)object2);
                continue;
            }
            if (string4.equals("ps.log")) {
                psStats = PsParser.parseLog(inputStream, map, map2);
                continue;
            }
            if (string4.equals("proc_ps.log")) {
                psStats = ProcPsParser.parseLog(inputStream, map, map2);
                continue;
            }
            if (string4.equals("proc_stat.log")) {
                stats = ProcStatParser.parseLog(inputStream);
                continue;
            }
            if (string4.equals("proc_diskstats.log")) {
                stats2 = ProcDiskStatParser.parseLog(inputStream, n);
                continue;
            }
            if (string4.equals("kernel_pacct")) {
                map2 = PacctParser.parseLog(inputStream);
                continue;
            }
            if (string4.equals("init_pidname.log")) {
                map = PidNameParser.parseLog(inputStream);
                continue;
            }
            log.warning("Unknown log file: " + string4);
            if (string4.length() <= 32) continue;
            bl3 = false;
            break;
        }
        long l = 0L;
        if (bootStats == null) {
            object = new ProcessTree(null, string3, bl);
            if (psStats == null || psStats.processList.size() == 0) {
                log.warning("No process samples");
            } else {
                l = System.currentTimeMillis();
                object = new ProcessTree(psStats, string3, bl);
                l = System.currentTimeMillis() - l;
                log.fine("Tree generation and pruning took " + l + " ms");
                if (((ProcessTree)object).processTree.size() == 0 || ((ProcessTree)object).duration == 0L) {
                    log.warning("No processes found");
                }
            }
            bootStats = new BootStats(stats, stats2, (ProcessTree)object);
        }
        object = null;
        l = System.currentTimeMillis();
        if ("png".equals(string)) {
            object = new PNGRenderer();
        } else if ("svg".equals(string)) {
            object = new SVGRenderer();
        } else if ("eps".equals(string)) {
            object = new EPSRenderer();
        } else {
            throw new IllegalArgumentException("Invalid format: " + string);
        }
        string2 = string2 + "." + ((Renderer)object).getFileSuffix();
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        ((Renderer)object).render((Properties)object2, bootStats, fileOutputStream);
        fileOutputStream.close();
        log.fine("Wrote image: " + string2);
        System.out.println("Wrote image: " + string2);
        l = System.currentTimeMillis() - l;
        log.fine("Render time: " + l + " ms)");
        return string2;
    }

    private static Options getOptions() {
        Options options = new Options();
        Option option = null;
        options.addOption("h", "help", false, "print this message");
        options.addOption("v", "version", false, "print version and exit");
        option = new Option("f", "format", true, "image format (png | eps | svg; default: " + DEFAULT_FORMAT + ")");
        option.setArgName("format");
        options.addOption(option);
        option = new Option("o", "output-dir", true, "output directory where images are stored (default: .)");
        option.setArgName("dir");
        options.addOption(option);
        options.addOption("n", "no-prune", false, "do not prune the process tree");
        return options;
    }

    private static void printUsage(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("bootchart [OPTION]... [FILE]...", options);
    }
}

