/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.tar;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.tar.TarBuffer;
import org.apache.commons.compress.tar.TarEntry;

public class TarOutputStream
extends FilterOutputStream {
    public static final int LONGFILE_ERROR = 0;
    public static final int LONGFILE_TRUNCATE = 1;
    public static final int LONGFILE_GNU = 2;
    private int m_longFileMode = 0;
    private byte[] m_assemBuf;
    private int m_assemLen;
    private TarBuffer m_buffer;
    private int m_currBytes;
    private int m_currSize;
    private byte[] m_oneBuf;
    private byte[] m_recordBuf;

    public TarOutputStream(OutputStream outputStream) {
        this(outputStream, 10240, 512);
    }

    public TarOutputStream(OutputStream outputStream, int n) {
        this(outputStream, n, 512);
    }

    public TarOutputStream(OutputStream outputStream, int n, int n2) {
        super(outputStream);
        this.m_buffer = new TarBuffer(outputStream, n, n2);
        this.m_assemLen = 0;
        this.m_assemBuf = new byte[n2];
        this.m_recordBuf = new byte[n2];
        this.m_oneBuf = new byte[1];
    }

    public void setBufferDebug(boolean bl) {
        this.m_buffer.setDebug(bl);
    }

    public void setLongFileMode(int n) {
        if (0 != n && 2 != n && 1 != n) {
            throw new IllegalArgumentException("longFileMode");
        }
        this.m_longFileMode = n;
    }

    public int getRecordSize() {
        return this.m_buffer.getRecordSize();
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.m_buffer.close();
    }

    public void closeEntry() throws IOException {
        if (this.m_assemLen > 0) {
            for (int i = this.m_assemLen; i < this.m_assemBuf.length; ++i) {
                this.m_assemBuf[i] = 0;
            }
            this.m_buffer.writeRecord(this.m_assemBuf);
            this.m_currBytes += this.m_assemLen;
            this.m_assemLen = 0;
        }
        if (this.m_currBytes < this.m_currSize) {
            String string = "entry closed at '" + this.m_currBytes + "' before the '" + this.m_currSize + "' bytes specified in the header were written";
            throw new IOException(string);
        }
    }

    public void finish() throws IOException {
        this.writeEOFRecord();
    }

    public void putNextEntry(TarEntry tarEntry) throws IOException {
        if (tarEntry.getName().length() >= 100) {
            if (this.m_longFileMode == 2) {
                TarEntry tarEntry2 = new TarEntry("././@LongLink", 76);
                tarEntry2.setSize(tarEntry.getName().length());
                this.putNextEntry(tarEntry2);
                this.write(tarEntry.getName().getBytes());
                this.closeEntry();
            } else if (this.m_longFileMode != 1) {
                String string = "file name '" + tarEntry.getName() + "' is too long ( > " + 100 + " bytes)";
                throw new IOException(string);
            }
        }
        tarEntry.writeEntryHeader(this.m_recordBuf);
        this.m_buffer.writeRecord(this.m_recordBuf);
        this.m_currBytes = 0;
        this.m_currSize = tarEntry.isDirectory() ? 0 : (int)tarEntry.getSize();
    }

    public void copyEntryContents(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[32768];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            this.write(byArray, 0, n);
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.m_oneBuf[0] = (byte)n;
        this.write(this.m_oneBuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        int n5 = n2;
        if (this.m_currBytes + n5 > this.m_currSize) {
            String string = "request to write '" + n5 + "' bytes exceeds size in header of '" + this.m_currSize + "' bytes";
            throw new IOException(string);
        }
        if (this.m_assemLen > 0) {
            if (this.m_assemLen + n5 >= this.m_recordBuf.length) {
                n3 = this.m_recordBuf.length - this.m_assemLen;
                System.arraycopy(this.m_assemBuf, 0, this.m_recordBuf, 0, this.m_assemLen);
                System.arraycopy(byArray, n4, this.m_recordBuf, this.m_assemLen, n3);
                this.m_buffer.writeRecord(this.m_recordBuf);
                this.m_currBytes += this.m_recordBuf.length;
                n4 += n3;
                n5 -= n3;
                this.m_assemLen = 0;
            } else {
                System.arraycopy(byArray, n4, this.m_assemBuf, this.m_assemLen, n5);
                n4 += n5;
                this.m_assemLen += n5;
                n5 -= n5;
            }
        }
        while (n5 > 0) {
            if (n5 < this.m_recordBuf.length) {
                System.arraycopy(byArray, n4, this.m_assemBuf, this.m_assemLen, n5);
                this.m_assemLen += n5;
                break;
            }
            this.m_buffer.writeRecord(byArray, n4);
            n3 = this.m_recordBuf.length;
            this.m_currBytes += n3;
            n5 -= n3;
            n4 += n3;
        }
    }

    private void writeEOFRecord() throws IOException {
        for (int i = 0; i < this.m_recordBuf.length; ++i) {
            this.m_recordBuf[i] = 0;
        }
        this.m_buffer.writeRecord(this.m_recordBuf);
    }
}

