/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.tar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.tar.TarBuffer;
import org.apache.commons.compress.tar.TarEntry;

public class TarInputStream
extends FilterInputStream {
    private TarBuffer m_buffer;
    private TarEntry m_currEntry;
    private boolean m_debug;
    private int m_entryOffset;
    private int m_entrySize;
    private boolean m_hasHitEOF;
    private byte[] m_oneBuf;
    private byte[] m_readBuf;

    public TarInputStream(InputStream inputStream) {
        this(inputStream, 10240, 512);
    }

    public TarInputStream(InputStream inputStream, int n) {
        this(inputStream, n, 512);
    }

    public TarInputStream(InputStream inputStream, int n, int n2) {
        super(inputStream);
        this.m_buffer = new TarBuffer(inputStream, n, n2);
        this.m_oneBuf = new byte[1];
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
        this.m_buffer.setDebug(bl);
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] byArray;
        CharSequence charSequence;
        if (this.m_hasHitEOF) {
            return null;
        }
        if (this.m_currEntry != null) {
            int n = this.m_entrySize - this.m_entryOffset;
            if (this.m_debug) {
                charSequence = "TarInputStream: SKIP currENTRY '" + this.m_currEntry.getName() + "' SZ " + this.m_entrySize + " OFF " + this.m_entryOffset + "  skipping " + n + " bytes";
                this.debug((String)charSequence);
            }
            if (n > 0) {
                this.skip(n);
            }
            this.m_readBuf = null;
        }
        if ((byArray = this.m_buffer.readRecord()) == null) {
            if (this.m_debug) {
                this.debug("READ NULL RECORD");
            }
            this.m_hasHitEOF = true;
        } else if (this.m_buffer.isEOFRecord(byArray)) {
            if (this.m_debug) {
                this.debug("READ EOF RECORD");
            }
            this.m_hasHitEOF = true;
        }
        if (this.m_hasHitEOF) {
            this.m_currEntry = null;
        } else {
            this.m_currEntry = new TarEntry(byArray);
            if (byArray[257] != 117 || byArray[258] != 115 || byArray[259] != 116 || byArray[260] != 97 || byArray[261] != 114) {
                // empty if block
            }
            if (this.m_debug) {
                charSequence = "TarInputStream: SET CURRENTRY '" + this.m_currEntry.getName() + "' size = " + this.m_currEntry.getSize();
                this.debug((String)charSequence);
            }
            this.m_entryOffset = 0;
            this.m_entrySize = (int)this.m_currEntry.getSize();
        }
        if (null != this.m_currEntry && this.m_currEntry.isGNULongNameEntry()) {
            charSequence = new StringBuffer();
            byte[] byArray2 = new byte[256];
            int n = 0;
            while ((n = this.read(byArray2)) >= 0) {
                String string = new String(byArray2, 0, n);
                ((StringBuffer)charSequence).append(string);
            }
            this.getNextEntry();
            if (((StringBuffer)charSequence).length() > 0 && ((StringBuffer)charSequence).charAt(((StringBuffer)charSequence).length() - 1) == '\u0000') {
                ((StringBuffer)charSequence).deleteCharAt(((StringBuffer)charSequence).length() - 1);
            }
            this.m_currEntry.setName(((StringBuffer)charSequence).toString());
        }
        return this.m_currEntry;
    }

    public int getRecordSize() {
        return this.m_buffer.getRecordSize();
    }

    @Override
    public int available() throws IOException {
        return this.m_entrySize - this.m_entryOffset;
    }

    @Override
    public void close() throws IOException {
        this.m_buffer.close();
    }

    public void copyEntryContents(OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[32768];
        while ((n = this.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.m_oneBuf, 0, 1);
        if (n == -1) {
            return n;
        }
        return this.m_oneBuf[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        if (this.m_entryOffset >= this.m_entrySize) {
            return -1;
        }
        if (n5 + this.m_entryOffset > this.m_entrySize) {
            n5 = this.m_entrySize - this.m_entryOffset;
        }
        if (null != this.m_readBuf) {
            int n7 = n5 > this.m_readBuf.length ? this.m_readBuf.length : n5;
            System.arraycopy(this.m_readBuf, 0, byArray, n4, n7);
            if (n7 >= this.m_readBuf.length) {
                this.m_readBuf = null;
            } else {
                n3 = this.m_readBuf.length - n7;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(this.m_readBuf, n7, byArray2, 0, n3);
                this.m_readBuf = byArray2;
            }
            n6 += n7;
            n5 -= n7;
            n4 += n7;
        }
        while (n5 > 0) {
            byte[] byArray3 = this.m_buffer.readRecord();
            if (null == byArray3) {
                String string = "unexpected EOF with " + n5 + " bytes unread";
                throw new IOException(string);
            }
            int n8 = byArray3.length;
            n3 = n5;
            if (n8 > n3) {
                System.arraycopy(byArray3, 0, byArray, n4, n3);
                this.m_readBuf = new byte[n8 - n3];
                System.arraycopy(byArray3, n3, this.m_readBuf, 0, n8 - n3);
            } else {
                n3 = n8;
                System.arraycopy(byArray3, 0, byArray, n4, n8);
            }
            n6 += n3;
            n5 -= n3;
            n4 += n3;
        }
        this.m_entryOffset += n6;
        return n6;
    }

    @Override
    public void reset() {
    }

    public void skip(int n) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[8192];
        for (int i = n; i > 0 && (n3 = this.read(byArray, 0, n2 = i > byArray.length ? byArray.length : i)) != -1; i -= n3) {
        }
    }

    protected void debug(String string) {
        if (this.m_debug) {
            System.err.println(string);
        }
    }
}

