/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;

public class Options {
    private Map shortOpts = new HashMap();
    private Map longOpts = new HashMap();
    private List requiredOpts = new ArrayList();
    private Map optionGroups = new HashMap();

    public Options addOptionGroup(OptionGroup optionGroup) {
        Iterator iterator = optionGroup.getOptions().iterator();
        if (optionGroup.isRequired()) {
            this.requiredOpts.add(optionGroup);
        }
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            option.setRequired(false);
            this.addOption(option);
            this.optionGroups.put(option.getOpt(), optionGroup);
        }
        return this;
    }

    public Options addOption(String string, boolean bl, String string2) {
        this.addOption(string, null, bl, string2);
        return this;
    }

    public Options addOption(String string, String string2, boolean bl, String string3) {
        this.addOption(new Option(string, string2, bl, string3));
        return this;
    }

    public Options addOption(Option option) {
        String string = "-" + option.getOpt();
        if (option.hasLongOpt()) {
            this.longOpts.put("--" + option.getLongOpt(), option);
        }
        if (option.isRequired()) {
            this.requiredOpts.add(string);
        }
        this.shortOpts.put(string, option);
        return this;
    }

    public Collection getOptions() {
        ArrayList arrayList = new ArrayList(this.shortOpts.values());
        for (Object v : this.longOpts.values()) {
            if (arrayList.contains(v)) continue;
            arrayList.add(v);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    List helpOptions() {
        return new ArrayList(this.shortOpts.values());
    }

    public List getRequiredOptions() {
        return this.requiredOpts;
    }

    public Option getOption(String string) {
        Option option = null;
        option = string.length() == 1 ? (Option)this.shortOpts.get("-" + string) : (string.startsWith("--") ? (Option)this.longOpts.get(string) : (Option)this.shortOpts.get(string));
        return option == null ? null : (Option)option.clone();
    }

    public boolean hasOption(String string) {
        if (string.length() == 1) {
            return this.shortOpts.containsKey("-" + string);
        }
        if (string.startsWith("--")) {
            return this.longOpts.containsKey(string);
        }
        return this.shortOpts.containsKey(string);
    }

    public OptionGroup getOptionGroup(Option option) {
        return (OptionGroup)this.optionGroups.get(option.getOpt());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ Options: [ short ");
        stringBuffer.append(this.shortOpts.toString());
        stringBuffer.append(" ] [ long ");
        stringBuffer.append(this.longOpts);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

