/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.Option;

public class OptionBuilder {
    private static String longopt;
    private static String description;
    private static String argName;
    private static boolean required;
    private static int numberOfArgs;
    private static Object type;
    private static boolean optionalArg;
    private static char valuesep;
    private static OptionBuilder instance;

    private OptionBuilder() {
    }

    private static void reset() {
        description = null;
        argName = null;
        longopt = null;
        type = null;
        required = false;
        numberOfArgs = -1;
        optionalArg = false;
        valuesep = '\u0000';
    }

    public static OptionBuilder withLongOpt(String string) {
        longopt = string;
        return instance;
    }

    public static OptionBuilder hasArg() {
        numberOfArgs = 1;
        return instance;
    }

    public static OptionBuilder hasArg(boolean bl) {
        numberOfArgs = bl ? 1 : -1;
        return instance;
    }

    public static OptionBuilder withArgName(String string) {
        argName = string;
        return instance;
    }

    public static OptionBuilder isRequired() {
        required = true;
        return instance;
    }

    public static OptionBuilder withValueSeparator(char c) {
        valuesep = c;
        return instance;
    }

    public static OptionBuilder withValueSeparator() {
        valuesep = (char)61;
        return instance;
    }

    public static OptionBuilder isRequired(boolean bl) {
        required = bl;
        return instance;
    }

    public static OptionBuilder hasArgs() {
        numberOfArgs = -2;
        return instance;
    }

    public static OptionBuilder hasArgs(int n) {
        numberOfArgs = n;
        return instance;
    }

    public static OptionBuilder hasOptionalArg() {
        numberOfArgs = 1;
        optionalArg = true;
        return instance;
    }

    public static OptionBuilder hasOptionalArgs() {
        numberOfArgs = -2;
        optionalArg = true;
        return instance;
    }

    public static OptionBuilder hasOptionalArgs(int n) {
        numberOfArgs = n;
        optionalArg = true;
        return instance;
    }

    public static OptionBuilder withType(Object object) {
        type = object;
        return instance;
    }

    public static OptionBuilder withDescription(String string) {
        description = string;
        return instance;
    }

    public static Option create(char c) throws IllegalArgumentException {
        return OptionBuilder.create(String.valueOf(c));
    }

    public static Option create() throws IllegalArgumentException {
        if (longopt == null) {
            throw new IllegalArgumentException("must specify longopt");
        }
        return OptionBuilder.create(" ");
    }

    public static Option create(String string) throws IllegalArgumentException {
        Option option = new Option(string, description);
        option.setLongOpt(longopt);
        option.setRequired(required);
        option.setOptionalArg(optionalArg);
        option.setArgs(numberOfArgs);
        option.setType(type);
        option.setValueSeparator(valuesep);
        option.setArgName(argName);
        instance.reset();
        return option;
    }

    static {
        numberOfArgs = -1;
        instance = new OptionBuilder();
    }
}

