<?php
/**
 * A simple description for this script
 *
 * PHP Version 5.2.4 or Upper version
 *
 * @package    Hangul Parser
 * @author     Hidehito NOZAWA aka Suin <xoops.suinyeze.com>
 * @copyright  2008 Hidehito NOZAWA
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU GPL v2.0
 *
 */

// 必要なファイルをいくつか読み込む
if ( !class_exists('HangulParser', false) ) require('HangulParser.php');
if ( !class_exists('HangulChar', false) ) require('HangulChar.php');
// if ( !class_exists('HangulConvertTable', false) ) require('HangulConvertTable.php');
if ( !class_exists('HangulRealConvertTable', false) ) require('HangulRealConvertTable.php');
if ( !class_exists('HangulYaleConvertTable', false) ) require('HangulYaleConvertTable.php');

// パースする文字列を定義
$target = '한글을 PHP로 풀어쓰기 해 보자.';

echo '「'. $target. '」をHanguleParserで分解してみよう。<br />';

echo '普通にばらし書きしてみる。<br />';

// インスタンスを取得する
$hangul =& HangulParser::getInstance();

// 変換につかうテーブルクラスを指定
$hangul->setTableClassName('HangulRealConvertTable');
// パース実行
$word = $hangul->parseWord($target);

foreach ( $word as $char )
{
	if ( is_object($char) )
	{
		foreach ( $char->parts as $part )
		{
			echo $part;
		}
	}
	else
	{
		echo $char;
	}
}

echo '<br />';

echo 'Yale式ローマ字転写をしてみる。<br />';

$hangul->setTableClassName('HangulYaleConvertTable');
$word = $hangul->parseWord($target);

foreach ( $word as $char )
{
	if ( is_object($char) )
	{
		foreach ( $char->parts as $part )
		{
			echo $part;
		}
	}
	else
	{
		echo $char;
	}
}

echo '<br />';
?>
