<?php
/**
 * A simple description for this script
 *
 * PHP Version 5.2.4 or Upper version
 *
 * @package    Hangul Parser
 * @author     Hidehito NOZAWA aka Suin <xoops.suinyeze.com>
 * @copyright  2008 Hidehito NOZAWA
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU GPL v2.0
 *
 */

class HangulYaleConvertTable
{
	static public function getInitialTable()
	{
		return array(
			'k',  'kk', 'n',  't',  'tt',
			'l',  'm',  'p',  'pp', 's',
			'ss', '',   'c',  'cc', 'ch',
			'kh', 'th', 'ph', 'h',
		);
	}

	static public function getMiddleTable()
	{
		return array(
			'a',   'ay',  'ya',
			'yay', 'e',   'ey',
			'ye',  'yey', 'o',
			'wa',  'oy',  'way',
			'yo',  'wu',  'we',
			'wey', 'wi',  'yu',
			'u',   'uy',  'i',
		);
	}

	static public function getFinalTalbe()
	{
		$table = array(
			'',    'k',    'kk',   'k.s',
			'n',   'n.c',  'n.h',  't',
			'l',   'l.k',  'l.m',  'l.p',
			'l.s', 'l.th', 'l.ph', 'l.h',
			'm',   'p',    'p.s',  's',
			'ss',  'ng',   'c',    'ch',
			'kh',  'th',   'ph',   'h',
		);

		foreach ( $table as $k => $v )
		{
			$table[$k] = explode('.', $v);
		}

		return $table;
	}
}

?>
