<?php
/**
 * A simple description for this script
 *
 * PHP Version 5.2.4 or Upper version
 *
 * @package    Hangul Parser
 * @author     Hidehito NOZAWA aka Suin <xoops.suinyeze.com>
 * @copyright  2008 Hidehito NOZAWA
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU GPL v2.0
 *
 */

class HangulConvertTable
{
	static public function getInitialTable()
	{
		return array(
			'g', 'G', 'n', 'd', 'D',
			'l', 'm', 'b', 'B', 's',
			'S', '_', 'j', 'J', 'c',
			'k', 't', 'p', 'h',
		);
	}

	static public function getMiddleTable()
	{
		return array(
			'a',   'ai',  'ya',
			'yai', 'e',   'ei',
			'ye',  'yei', 'o',
			'oa',  'oi',  'oai',
			'yo',  'u',   'ue',
			'uei', 'ui',  'yu',
			'w',   'wi',  'i',
		);
	}

	static public function getFinalTalbe()
	{
		$table = array(
			'_',  'g',  'G',  'gs',
			'n',  'nj', 'nh', 'd',
			'l',  'lg', 'lm', 'lb',
			'ls', 'lt', 'lp', 'lh',
			'm',  'b',  'bs', 's',
			'S',  'N',  'j',  'c',
			'k',  't',  'p',  'h',
		);

		foreach ( $table as $k => $v )
		{
			$table[$k] = str_split($v);
		}

		return $table;
	}
}

?>
