<?php
if( !function_exists( 'dbListProducts' ) ){
  /**
  * Pobieranie z bazy produktow
  * @return array
  * @param int  $iStatus
  */
  function dbListProducts( $iStatus ){

    $aFile =      file( DIR_DB.DB_PRODUCTS );
    $iCount =     count( $aFile );
    $iFindPage =  0;
    $iFindAll =   0;
    sort( $aFile );

    for( $i = 1; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i] );
      if( $aExp[7] >= $iStatus ){
        $iFindPage++;
        $iFindAll++;
        
        if( $iFindPage == 1 )
          $aPageStart[] = $i;

        if( isset( $aPageStart[$_GET['page'] - 1] ) && !isset( $aPageEnd[$_GET['page'] - 1] ) ){
          $aData[] = $aExp;
        }

        if( $iFindPage == PRODUCTS_LIST ){
          $aPageEnd[] = $i;
          $iFindPage =  0;
        }
      }
    } // end for

    if( isset( $aData ) ){
      $aData[0]['iFindAll'] = $iFindAll;
      return $aData;
    }
    else
      return null;
  } // end function dbListProducts
}

if( !function_exists( 'dbListProductsSearch' ) ){
  /**
  * Pobieranie z bazy produktow z wyszukiwanym slowem
  * @return array
  * @param int    $iStatus
  * @param string $sWord
  */
  function dbListProductsSearch( $iStatus, $sWord ){

    $aFile =      file( DIR_DB.DB_PRODUCTS );
    $iCount =     count( $aFile );
    $iFindPage =  0;
    $iFindAll =   0;
    sort( $aFile );

    for( $i = 1; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i] );
      if( $aExp[7] >= $iStatus && eregi( $sWord, $aFile[$i] ) ){
        $iFindPage++;
        $iFindAll++;
        
        if( $iFindPage == 1 )
          $aPageStart[] = $i;

        if( isset( $aPageStart[$_GET['page'] - 1] ) && !isset( $aPageEnd[$_GET['page'] - 1] ) ){
          $aData[] = $aExp;
        }

        if( $iFindPage == PRODUCTS_LIST ){
          $aPageEnd[] = $i;
          $iFindPage =  0;
        }
      }
    } // end for

    if( isset( $aData ) ){
      $aData[0]['iFindAll'] = $iFindAll;
      return $aData;
    }
    else
      return null;
  } // end function dbListProductsSearch
}

if( !function_exists( 'dbListProductsCategory' ) ){
  /**
  * Pobieranie z bazy produktow danej kategorii
  * @return array
  * @param int  $iStatus
  * @param int  $iCategory
  */
  function dbListProductsCategory( $iStatus, $iCategory ){

    $aFile =      file( DIR_DB.DB_PRODUCTS );
    $iCount =     count( $aFile );
    $iFindPage =  0;
    $iFindAll =   0;
    $aCategories= throwCategoriesTree( $iCategory );
    sort( $aFile );   

    for( $i = 1; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i] );

      if( $aExp[7] >= $iStatus && in_array( $aExp[3], $aCategories ) === true ){
        $iFindPage++;
        $iFindAll++;
        
        if( $iFindPage == 1 )
          $aPageStart[] = $i;

        if( isset( $aPageStart[$_GET['page'] - 1] ) && !isset( $aPageEnd[$_GET['page'] - 1] ) ){
          $aData[] = $aExp;
        }

        if( $iFindPage == PRODUCTS_LIST ){
          $aPageEnd[] = $i;
          $iFindPage =  0;
        }
      }
    } // end for

    if( isset( $aData ) ){
      $aData[0]['iFindAll'] = $iFindAll;
      return $aData;
    }
    else
      return null;
  } // end function dbListProductsCategory
}

if( !function_exists( 'dbThrowProduct' ) ){
  /**
  * Zwracanie danych produktu
  * @return array
  * @param int  $iProduct
  * @param int  $iStatus
  */
  function dbThrowProduct( $iProduct, $iStatus ){
    $aFile  = file( DIR_DB.DB_PRODUCTS );
    $iCount = count( $aFile );

    for( $i = 1; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i] );
      if( $aExp[2] == $iProduct && $aExp[7] >= $iStatus ){
        return $aExp;
      }
    } // end for

    return null;
  } // end function dbThrowProduct
}

if( !function_exists( 'dbThrowProducts' ) ){
  /**
  * Zwracanie produktow w tablicy
  * @return array
  */
  function dbThrowProducts( ){
    return $GLOBALS['oFF']->throwFileArraySmall( DIR_DB.DB_PRODUCTS, null, 2, 1 );
  } // end function dbThrowProducts
}

if( !function_exists( 'dbAddProduct' ) ){
  /**
  * Dodawanie danych do pliku
  * @return void
  * @param array  $aForm
  */
  function dbAddProduct( $aForm ){
    global $oFF;
    extract( $aForm );
    $oFF->setRow( Array( sprintf( '%02.0f', $iPosition ), $sName, $iProduct, $iCategory, $fPrice, $sShortDescription, $sFullDescription, $iStatus ) );
    $oFF->addToFile( DIR_DB.DB_PRODUCTS );
  } // end function dbAddProduct
}

if( !function_exists( 'dbChangeProduct' ) ){
  /**
  * Zmienianie danych produktu
  * @return void
  * @param array  $aForm
  */
  function dbChangeProduct( $aForm ){
    global $oFF;
    extract( $aForm );
    $oFF->setRow( Array( sprintf( '%02.0f', $iPosition ), $sName, $iProduct, $iCategory, $fPrice, $sShortDescription, $sFullDescription, $iStatus ) );
    $oFF->changeInFile( DIR_DB.DB_PRODUCTS, $iProduct, 2 );
  } // end function dbChangeProduct
}

if( !function_exists( 'dbDelProduct' ) ){
  /**
  * Usuwanie danych produktu
  * @return void
  * @param int  $iProduct
  */
  function dbDelProduct( $iProduct ){
    $GLOBALS['oFF']->deleteInFile( DIR_DB.DB_PRODUCTS, $iProduct, 2 );
  } // end function dbDelProduct
}
?>