<?php 
if( !function_exists( 'addProduct' ) ){
  /**
  * Dodawanie produktu
  * @return void
  * @param array  $aForm
  */
  function addProduct( $aForm ){
    $aForm['iProduct'] = throwLastId( ) + 1;
    
    if( checkLength( $aForm['sShortDescription'], 1 ) )
      $aForm['sShortDescription'] = JcodeConvert(changeTxt( $aForm['sShortDescription'], 'Br' ),0,1);		//for japanese
    if( checkLength( $aForm['sFullDescription'], 1 ) )
      $aForm['sFullDescription'] = JcodeConvert(changeTxt( $aForm['sFullDescription'], 'Br' ),0,1);		//for japanese
    if( empty( $aForm['iPosition'] ) || !is_numeric( $aForm['iPosition'] ) )
      $aForm['iPosition'] = 9;

    $aForm['sName']  = JcodeConvert(changeTxt( $aForm['sName'] ),0,1);		//for japanese
    $aForm['fPrice'] = ereg_replace( ',', '.', $aForm['fPrice'] );
    $aForm['fPrice'] = tPrice( $aForm['fPrice'] );

    addFiles( $aForm, $aForm['iProduct'], PRODUCTS_FOTO_SIZE, 1 );
    dbAddProduct( $aForm );

  } // end function addProduct
}

if( !function_exists( 'changeProduct' ) ){
  /**
  * Zmiana danych produktu
  * @return void
  * @param array  $aForm
  */
  function changeProduct( $aForm ){

    if( isset( $aForm['aFileDescriptionChange'] ) && is_array( $aForm['aFileDescriptionChange'] ) ){
      foreach( $aForm['aFileDescriptionChange'] as $iKey => $sValue ){
        dbChangeFileDescription( Array( $iKey, $aForm['iProduct'], $aForm['aFileNameChange'][$iKey], changeTxt( ereg_replace( '\'', '', $sValue ) ), $aForm['aFileType'][$iKey] ), 1 );
      }
    }

    if( isset( $aForm['aDelFile'] ) && is_array( $aForm['aDelFile'] ) ){
      $iCount = count( $aForm['aDelFile'] );
      for( $i = 0; $i < $iCount; $i++ )
        delFile( $aForm['aDelFile'][$i], 1 );
    }

    if( checkLength( $aForm['sShortDescription'], 1 ) )
      $aForm['sShortDescription'] = JcodeConvert(changeTxt( $aForm['sShortDescription'], 'Br' ),0,1);	//for japanese
    if( checkLength( $aForm['sFullDescription'], 1 ) )
      $aForm['sFullDescription'] = JcodeConvert(changeTxt( $aForm['sFullDescription'], 'Br' ),0,1);	//for japanese
    if( empty( $aForm['iPosition'] ) || !is_numeric( $aForm['iPosition'] ) )
      $aForm['iPosition'] = 9;

    $aForm['sName']  = JcodeConvert(changeTxt( $aForm['sName'] ),0,1);		//for japanese
    $aForm['fPrice'] = ereg_replace( ',', '.', $aForm['fPrice'] );
    $aForm['fPrice'] = tPrice( $aForm['fPrice'] );
    
    addFiles( $aForm, $aForm['iProduct'], PRODUCTS_FOTO_SIZE, 1 );
    dbChangeProduct( $aForm );
  } // end function changeProduct
}

if( !function_exists( 'delProduct' ) ){
  /**
  * Usuwanie produktu
  * @return void
  * @param int  $iProduct
  */
  function delProduct( $iProduct ){
    delFiles( $iProduct, 1 );
    dbDelProduct( $iProduct );
  } // end function delProduct
}
?>