<?php
if( !function_exists( 'throwFilesDir' ) ){
  /**
  * Zwracanie katalogu plikow
  * @return string
  * @param int  $iType
  */
  function throwFilesDir( $iType = 1 ){
    if( $iType == 1 ){
      return DIR_PRODUCTS_FILES;
    }
    else{
      return DIR_CATEGORIES_FILES;
    }
  } // end function throwFilesDir
}

if( !function_exists( 'listFiles' ) ){
  /**
  * Wyswietlanie spisu plikow
  * @return array
  * @param int    $iLink
  * @param string $sFile
  * @param int    $iType
  */
  function listFiles( $iLink, $sFile = null, $iType = 1 ){
    global $aList, $oFoto, $tpl;

    $sDir             = throwFilesDir( $iType );
    $aData            = dbListFiles( $iLink, $iType );
    $aReturn['list']  = null;
    $iExist           = 0;
    
    if( isset( $aData[1] ) && is_array( $aData[1] ) ){

      $iCount = count( $aData[1] );

      for( $i = 0; $i < $iCount; $i++ ){
        list( $aList['id'], $aList['iPosition'], $aList['file'], $aList['description'], $aList['type'] ) = $aData[1][$i];
        
        if( is_file( $sDir.$aList['file'] ) ){

          $aName = $oFoto->throwNameExtOfFile( $aList['file'] );
          $aList['fotoSmall'] = $sDir.$aName[0].'_m.'.$aName[1];
          $aList['fotoBig']   = $sDir.$aList['file'];

          if( $iExist == 0 )
            $aReturn['default_photo'] = $tpl->tbHtml( $sFile, 'FOTO_DEFAULT' );
          else{
            if( $iExist == 1 )
              $aReturn['photos'] = $tpl->tbHtml( $sFile, 'FOTO_HEAD' );

            $aReturn['photos'] .= $tpl->tbHtml( $sFile, 'FOTO_LIST' );
          }
          
          $iExist++;
        }
      } // end for
            
      if( $iExist > 1 )
        $aReturn['photos'] .= $tpl->tbHtml( $sFile, 'FOTO_FOOTER' );
    }
    
    $iExist = 0;
    
    if( isset( $aData[0] ) && is_array( $aData[0] ) ){
      $aExt   = throwIconsFromExt( );
      $iCount = count( $aData[0] );

      for( $i = 0; $i < $iCount; $i++ ){
        list( $aList['id'], $aList['iPosition'], $aList['file'], $aList['description'], $aList['type'] ) = $aData[0][$i];
        
        if( is_file( $sDir.$aList['file'] ) ){
         
          $aName = $oFoto->throwNameExtOfFile( $aList['file'] );
          
          if( !isset( $aExt[$aName[1]] ) )
            $aExt[$aName[1]] = 'nn';
          
          $aList['sIcon'] = 'ico_'.$aExt[$aName[1]];

          if( $iExist == 0 )
            $aReturn['files'] = $tpl->tbHtml( $sFile, 'FILES_HEAD' );

          $aReturn['files'] .= $tpl->tbHtml( $sFile, 'FILES_LIST' );
          
          $iExist++;
        }
      } // end for

      if( $iExist > 0 )
        $aReturn['files'] .= $tpl->tbHtml( $sFile, 'FILES_FOOTER' );
    }    
    return $aReturn;
  } // end function listFiles
}

if( !function_exists( 'throwFirstPhoto' ) ){
  /**
  * Pobieranie pierwszych zdjec
  * @return array
  * @param int  $iType
  */
  function throwFirstPhoto( $iType ){
    $aData  = dbThrowFirstPhoto( $iType );
    $iCount = count( $aData );
    $aFoto  = null;

    for( $i = 0; $i < $iCount; $i++ ){
      list( $aFoto[$aData[$i][1]]['id'], $aFoto[$aData[$i][1]]['iLink'], $aFoto[$aData[$i][1]]['foto'], $aFoto[$aData[$i][1]]['description'] ) = $aData[$i];
    } // end for
    return $aFoto;
  } // end function throwFirstPhoto
}
?>