<?php

class Categories {

  var $aData;
  var $aOnlyNames;
  var $aByParent;
  var $aMain;
  var $aParent;
  var $aMainByTypes;
  var $sFile =        null;
  var $iSelected =    null;
  var $iType =        null;
  var $sOption =      null;
  var $aTypes;
  var $aFirstFoto;
  
  /**
  * Konstruktor
  */
  function Categories( ){
    global $lang;
    $this->aTypes = Array( 1 => $lang['products'], 2 => $lang['content'] );
  } // end function

  /**
  * Wpisuje pobrane z pliku dane do tablic
  * @return void
  * @param array  $aData
  */
  function listCategoriesToArray( $aData ){

    $iCount =   count( $aData );
    for( $i = 0; $i < $iCount; $i++ ){
      list( $aList['iPosition'], $aList['sName'], $aList['iCategory'], $aList['iParent'], $aList['iType'], $aList['sShortDescription'], $aList['sFullDescription'] ) = $aData[$i];

      $this->aData[$aList['iCategory']] =       $aList;
      $this->aOnlyNames[$aList['iCategory']] =  $aList['sName'];
      if( is_numeric( $aList['iParent'] ) ){
        $this->aByParent[$aList['iParent']][] = $aList['iCategory'];
        $this->aParent[$aList['iCategory']] =   $aList['iParent'];
      }
      else{
        $this->aMain[] =                          $aList['iCategory'];
        $this->aMainByTypes[$aList['iType']][] =  $aList['iCategory'];
        $this->aParent[$aList['iCategory']] =     $aList['iCategory'];
      }
    } // end for
  } // end function listCategoriesToArray

} // end class Categories

$oCategory = new Categories;

dbListCategories( );

if( !function_exists( 'throwCategory' ) ){
  /**
  * Zwraca tablice dla danej kategorii
  * @return array
  * @param int $iCategory
  */
  function throwCategory( $iCategory = null ){
    global $oCategory;

    if( isset( $oCategory->aData[$iCategory] ) ){
      $aReturn = $oCategory->aData[$iCategory];
      if( !isset( $aReturn['sFullDescription'] ) || empty( $aReturn['sFullDescription'] ) ){
        if( isset( $aReturn['sShortDescription'] ) && !empty( $aReturn['sShortDescription'] ) )
          $aReturn['sFullDescription'] = $aReturn['sShortDescription'];
        else
          $aReturn['sFullDescription'] = '';
      }
      return $aReturn;
    }
    else
      return null;

  } // end function throwCategory
}

if( !function_exists( 'throwCategories' ) ){
  /**
  * Zwraca tablice z nazwami kategorii jako wartosciami i id kategorii jak indexem
  * @return array
  */
  function throwCategories( ){
    return $GLOBALS['oCategory']->aOnlyNames;
  } // end function throwCategories
}

if( !function_exists( 'throwCategoryName' ) ){
  /**
  * Zwraca nazwe dla danej kategorii
  * @return string
  * @param int $iCategory
  */
  function throwCategoryName( $iCategory = null ){
    global $oCategory;

    if( isset( $iCategory ) && isset( $oCategory->aOnlyNames[$iCategory] ) )
      return $oCategory->aOnlyNames[$iCategory];
    else
      return null;
  } // end function throwCategoryName
}

if( !function_exists( 'throwCategoryContent' ) ){
  /**
  * Zwraca tresc pelna dla danej kategorii
  * @return string
  * @param int $iCategory
  */
  function throwCategoryContent( $iCategory = null ){

    $aCategory = throwCategory( $iCategory );

    if( isset( $aCategory ) ){
      if( empty( $aCategory['sFullDescription'] ) )
        return $aCategory['sShortDescription'];
      else
        return $aCategory['sFullDescription'];
    }
    else
      return null;
  } // end function throwCategoryContent
}

if( !function_exists( 'listCategories' ) ){
  /**
  * Zwraca spis stron
  * @return string
  * @param string $sFile
  * @param int    $iType
  * @param bool   $bParentOnly
  * @param int    $iSelected
  * @param string $sOption
  * @param bool   $bExt
  */
  function listCategories( $sFile, $iType = null, $bParentOnly = null, $iSelected = null, $sOption = null, $bExt = null ){
    global $tpl, $oCategory;

    if( !is_numeric( $iSelected ) )
      $iSelected = null;
    $oCategory->sFile =       $sFile;
    $oCategory->iType =       $iType;
    $oCategory->iSelected =   $iSelected;
    $oCategory->sOption =     $sOption;
    if( isset( $bExt ) && !isset( $oCategory->aFirstFoto ) )
      $oCategory->aFirstFoto =  throwFirstPhoto( 2 );

    if( is_numeric( $iType ) ){
      if( isset( $oCategory->aMainByTypes[$iType] ) )
        $aCategories = $oCategory->aMainByTypes[$iType];
      else
        $aCategories = null;
    }
    else
      $aCategories = $oCategory->aMain;

    if( isset( $aCategories ) && is_array( $aCategories ) ){
      $content =  null;
      $iCount =   count( $aCategories );
      for( $i = 0; $i < $iCount; $i++ ){
    
        $iCategory = $aCategories[$i];
        $content .= throwListContent( $iCategory );
        if( isset( $oCategory->aByParent[$iCategory] ) && ( !isset( $bParentOnly ) || ( is_numeric( $iSelected ) && isset( $oCategory->aParent[$iSelected] ) && $oCategory->aParent[$iSelected] == $iCategory ) ) )
          // jesli dana kategoria posiada dzieci i ( mozna wyswietlac podkategorie lub dana kategoria jest rodzicem wybranej )
          $content .= listCategoriesChildren( $iCategory );

      } // end for

      if( isset( $content ) )
        return $tpl->tbHtml( $sFile, 'LIST_HEAD' ) . $content . $tpl->tbHtml( $sFile, 'LIST_FOOTER' );
      else
        return null;
    }
    else
      return null;
  } // end function listCategories
}

if( !function_exists( 'listCategoriesChildren' ) ){
  /**
  * Zwraca spis podkategorii
  * @return string
  * @param int    $iParent
  * @param string $sFile
  * @param bool   $bExt
  */
  function listCategoriesChildren( $iParent, $sFile = null, $bExt = null ){
    global $oCategory;
    
    if( isset( $bExt ) && !isset( $oCategory->aFirstFoto ) )
      $oCategory->aFirstFoto =  throwFirstPhoto( 2 );

    if( isset( $sFile ) )
      $oCategory->sFile = $sFile;

    if( isset( $oCategory->aByParent[$iParent] ) )
      $aCategories = $oCategory->aByParent[$iParent];

    $content =  null;
    if( isset( $aCategories ) && is_array( $aCategories ) ){
      $iCount =   count( $aCategories );
      for( $i = 0; $i < $iCount; $i++ ){

        $iCategory = $aCategories[$i];
        $content .= throwListContent( $iCategory, '_SUB' );

      } // end for

    }

    if( isset( $sFile ) && isset( $content ) )
      $content = $GLOBALS['tpl']->tbHtml( $sFile, 'LIST_HEAD' ) . $content . $GLOBALS['tpl']->tbHtml( $sFile, 'LIST_FOOTER' );

    return $content;
  } // end function listCategoriesChildren
}

if( !function_exists( 'throwListContent' ) ){
  /**
  * Zwraca zwraca content podczas wyswietlania listy kategorii
  * @return string
  * @param int    $iCategory
  * @param string $sSub
  */
  function throwListContent( $iCategory, $sSub = null ){
    global $tpl, $aList, $oCategory;

    $aList = $oCategory->aData[$iCategory];

    if( $oCategory->sOption == 'admin' ){
      if( $aList['iCategory'] != $GLOBALS['config']['contact_page'] )
        $aList['sDelLink'] = $tpl->tbHtml( $oCategory->sFile, 'DELETE_SITE' );
      else
        $aList['sDelLink'] = null;
    }
    
    if( isset( $oCategory->iSelected ) && $oCategory->iSelected == $aList['iCategory'] )
      $aList['sSelected'] = $tpl->tbHtml( $oCategory->sFile, 'SELECTED' );
    else
      $aList['sSelected'] = null;

    if( isset( $oCategory->aFirstFoto[$aList['iCategory']] ) && is_file( DIR_CATEGORIES_FILES.$oCategory->aFirstFoto[$aList['iCategory']]['foto'] ) ){
      global $oFoto;
      $aName = $oFoto->throwNameExtOfFile( $oCategory->aFirstFoto[$aList['iCategory']]['foto'] );
      $aList['file'] =      $oCategory->aFirstFoto[$aList['iCategory']]['foto'];
      $aList['fotoSmall'] = DIR_CATEGORIES_FILES.$aName[0].'_m.'.$aName[1];
      $aList['fotoBig'] =   DIR_CATEGORIES_FILES.$oCategory->aFirstFoto[$aList['iCategory']]['foto'];
      $aList['foto'] =      $tpl->tbHtml( $oCategory->sFile, 'FOTO' );
    }
    else
      $aList['foto'] =      $tpl->tbHtml( $oCategory->sFile, 'NO_FOTO' );

    if( empty( $aList['sShortDescription'] ) )
      $aList['sShortDescription'] = '&nbsp;';

    return $tpl->tbHtml( $oCategory->sFile, 'LIST_LIST'.$sSub );
  } // end function throwListContent
}

if( !function_exists( 'throwTypesSelect' ) ){
  /**
  * Zwraca selecta z typow
  * @return string
  * @param int    $iSelected
  */
  function throwTypesSelect( $iSelected = null ){
    $sOption =  null;
    $aData =    $GLOBALS['oCategory']->aTypes;

    foreach( $aData as $iType => $sType ){
      if( isset( $iSelected ) && $iSelected == $iType )
        $sSelected = 'selected="selected"';
      else
        $sSelected = null;
    
      $sOption .= '<option value="'.$iType.'" '.$sSelected.'>'.$sType.'</option>';
    } // end for
    
    return $sOption;
  } // end function throwTypesSelect
}

if( !function_exists( 'throwCategoriesTree' ) ){
  /**
  * Zwraca tablice podkategorii
  * @return string
  * @param int    $iParent
  */
  function throwCategoriesTree( $iParent ){
    if( isset( $GLOBALS['oCategory']->aByParent[$iParent] ) )
      $aReturn = $GLOBALS['oCategory']->aByParent[$iParent];
    $aReturn[] =  $iParent;
    return $aReturn;
  } // end function throwCategoriesTree
}

if( !function_exists( 'throwCategoriesParentId' ) ){
  /**
  * Zwracanie id kategorii nadrzednej
  * @return int
  * @param int  $iCategory
  */  
  function throwCategoriesParentId( $iCategory ){
    return $GLOBALS['oCategory']->aParent[$iCategory];
  } // end function throwCategoriesParentId
}

?>