<?php
if( !function_exists( 'listProducts' ) ){
  /**
  * Wyswietlanie spisu produktow
  * @return string
  * @param string $sFile
  * @param string $sOption
  */
  function listProducts( $sFile = 'products_list.tpl', $sOption = 'list' ){

    if( !isset( $_GET['page'] ) || !is_numeric( $_GET['page'] ) || $_GET['page'] < 1 ) 
      $_GET['page'] = 1;

    if( isset( $_SESSION['iUserQC'] ) )
      $iStatus = 0;
    else
      $iStatus = 1;

    if( $sOption == 'category' ){
      $aData = dbListProductsCategory( $iStatus, $_GET['iCategory'] );
      $sPage = $_GET['p'].'&amp;iCategory='.$_GET['iCategory'];
    }
    elseif( $sOption == 'search' ){
      $aData = dbListProductsSearch( $iStatus, trim( $_GET['sWord'] ) );
      $sPage = $_GET['p'].'&amp;sWord='.$_GET['sWord'];
    }
    else{
      $aData = dbListProducts( $iStatus );
      $sPage = $_GET['p'];
    }

    if( isset( $aData ) && is_array( $aData ) )
      $content = throwProductsData( $sFile, $aData, $sPage );
    else
      $content = $GLOBALS['tpl']->tbHtml( $sFile, 'NOT_FOUND' );

    return $content;
  } // end function listProducts
}

if( !function_exists( 'throwProductsData' ) ){
  /**
  * Wyswietlanie produktow z podanej juz tablicy
  * @return string
  * @param string $sFile
  * @param array  $aData
  * @param string $sPage
  */
  function throwProductsData( $sFile, $aData, $sPage ){
    global $tpl, $aProducts, $oFoto;
    
    $aFoto        = throwFirstPhoto( 1 );
    $iCount       = count( $aData );
    $content      = null;
    $aCategories  = throwCategories( );

    for( $i = 0; $i < $iCount; $i++ ){  
      list( $aProducts['position'], $aProducts['name'], $aProducts['id'], $aProducts['category'], $aProducts['price'], $aProducts['shortDescription'], $aProducts['fullDescription'], $aProducts['status'] ) = $aData[$i];

      if( isset( $aFoto[$aProducts['id']] ) && is_file( DIR_PRODUCTS_FILES.$aFoto[$aProducts['id']]['foto'] ) ){
        $aName = $oFoto->throwNameExtOfFile( $aFoto[$aProducts['id']]['foto'] );
        $aProducts['file'] =      $aFoto[$aProducts['id']]['foto'];
        $aProducts['fotoSmall'] = DIR_PRODUCTS_FILES.$aName[0].'_m.'.$aName[1];
        $aProducts['fotoBig'] =   DIR_PRODUCTS_FILES.$aFoto[$aProducts['id']]['foto'];
        $aProducts['foto'] =      $tpl->tbHtml( $sFile, 'FOTO' );    
      }
      else
        $aProducts['foto'] = '&nbsp;';

      if( empty( $aProducts['shortDescription'] ) )
        $aProducts['shortDescription'] = '&nbsp;';
      if( empty( $aProducts['fullDescription'] ) )
        $aProducts['fullDescription'] = '&nbsp;';

      if( isset(  $aCategories[$aProducts['category']] ) )
        $aProducts['sCategory'] = $aCategories[$aProducts['category']];

      $content .= $tpl->tbHtml( $sFile, 'LIST_LIST' );

    } // end for

    $aProducts['pages'] = countPages( $aData[0]['iFindAll'], PRODUCTS_LIST, $_GET['page'], $sPage );
    return $tpl->tbHtml( $sFile, 'LIST_HEAD' ).$content.$tpl->tbHtml( $sFile, 'LIST_FOOTER' );
  } // end function throwProductsData
}

if( !function_exists( 'throwProduct' ) ){
  /**
  * Zwracanie danych
  * @return array
  * @param int  $iProduct
  */
  function throwProduct( $iProduct ){
    global $oFoto;

    if( isset( $_SESSION['iUserQC'] ) )
      $iStatus = 0;
    else
      $iStatus = 1;

    $aData  = dbThrowProduct( $iProduct, $iStatus );

    if( isset( $aData ) ){
      $aCategories = throwCategories( );
      
      list( $aProduct['position'], $aProduct['name'], $aProduct['id'], $aProduct['category'], $aProduct['price'], $aProduct['shortDescription'], $aProduct['fullDescription'], $aProduct['status'] ) = $aData ;

      if( isset( $aCategories[$aProduct['category']] ) ){
        $iParentCategory        = throwCategoriesParentId( $aProduct['category'] );
        $aProduct['sCategory']  = $aCategories[$aProduct['category']];

        if( $iParentCategory != $aProduct['category'] ){
          $aProduct['sCategory'] = $aCategories[$iParentCategory].' - '.$aProduct['sCategory'];
        }
      }
      else{
        $aProduct['sCategory'] = '&nbsp;';
      }
      
      return $aProduct;
    }
    else
      return null;
  } // end function throwProduct
}

if( !function_exists( 'throwProducts' ) ){
  /**
  * Zwracanie produktow w tablicy
  * @return array
  */
  function throwProducts( ){
    return dbThrowProducts( );
  } // end function throwProducts
}
?>