<?php
if( !function_exists( 'throwStartPageSelect' ) ){
  /**
  * Zwracanie startowej strony w postaci select'a
  * @return string
  * @param string $sStartPage
  */
  function throwStartPageSelect( $sStartPage = null ){
    $aStartPage[] = 'productsList';

    $iCount =   count( $aStartPage );
    $sOption =  null;

    for( $i = 0; $i < $iCount; $i++ ){
      if( isset( $sStartPage ) && $sStartPage == $aStartPage[$i] )
        $sSelected = 'selected="selected"';
      else
        $sSelected = null;
      $sOption .= '<option value="'.$aStartPage[$i].'" '.$sSelected.' >'.$aStartPage[$i].'</option>'."\n";
    } // end for
    return $sOption.listCategories( 'categories_content_select.tpl', 2, null, substr( $sStartPage, 2 ) );
  } // end function throwStartPageSelect
}

if( !function_exists( 'throwTemplatesSelect' ) ){
  /**
  * Zwracanie selekta szablonow
  * @return string
  * @param string $sDirName
  */
  function throwTemplatesSelect( $sDirName = null ){

    $sOption =  null;
    $oDir =     dir( TPL );
    $lp =       0;

    while( false !== ( $sDir = $oDir->read( ) ) ){
      if( $lp >1 ){
        if( is_dir( TPL.$sDir ) && $sDir != 'admin' ){
          if( isset( $sDirName ) && $sDirName == $sDir.'/' )
            $sSelected = 'selected="selected"';
          else
            $sSelected = null;
            
          $sOption .= '<option value="'.$sDir.'/" '.$sSelected.'>'.$sDir.'</option>';
        }
      }
      $lp++;
    } // end while

    $oDir->close( );

    return $sOption;
  } // end function throwTemplatesSelect
}

if( !function_exists( 'loginActions' ) ){
  /**
  * Weryfikacja czy dana osoba jest zalogowana lub sie wylogowuje
  * @return void
  * @param string $p
  * @param string $sKey
  * @date 2004-10-28 10:30:22
  */
  function loginActions( $p, $sKey = 'iUser' ){
    global $tpl, $sLoginInfo, $sLoginPage, $sLoginPageNext;
    
    if( !isset( $_SESSION[$sKey] ) || $_SESSION[$sKey] !== TRUE ){
      $sLoginPage = '?p=login';
      if( $p == 'login' ){
        $iCheckLogin = checkLogin( $_POST['sLogin'], $_POST['sPass'] );
        if( $iCheckLogin == 1 ){
          if( !isset( $_COOKIE['sLogin'] ) || $_COOKIE['sLogin'] != $_POST['sLogin'] )
            @setCookie( 'sLogin', $_POST['sLogin'], time( ) + 2592000 );
          $sLoginInfo = $tpl->tbHtml( 'login.tpl', 'LOGIN_CORRECT' );
        }
        elseif( $iCheckLogin == 2 ){
          $sLoginPage = $_SERVER['PHP_SELF'];
          $sLoginInfo = $tpl->tbHtml( 'login.tpl', 'LOGIN_NOT_ACTIVE' );
        }
        else{
          $sLoginPage = $_SERVER['PHP_SELF'];
          $sLoginInfo = $tpl->tbHtml( 'login.tpl', 'LOGIN_ERROR' );
        }
      }
      else{
        $sLoginInfo = $tpl->tbHtml( 'login.tpl', 'LOGIN_FORM' );
      }

      $tpl->dbHtml( 'login.tpl', 'LOGIN_TABLE' );
      exit;
    }
    else{
      if( $p == 'logout' ){
        unset( $_SESSION[$sKey] );
        $sLoginPage = $_SERVER['PHP_SELF'];
        $sLoginInfo = $tpl->tbHtml( 'login.tpl', 'LOGOUT' );
        $tpl->dbHtml( 'login.tpl', 'LOGIN_TABLE' );
        exit;
      }
    }
  } // end function loginActions
}

if( !function_exists( 'savePreferences' ) ){
  /**
  * Zapisywanie ustawien
  * @return void
  * @param array $aForm
  */
  function savePreferences( $aForm ){
    global $oFoto;

    $aForm['description'] = JcodeConvert(ereg_replace( "\n", " ", $aForm['description'] ),0,1);       //for japanese
    $aForm['title']= JcodeConvert($aForm['title'],0,1);						      //for japanese
    $aForm['keywords']=JcodeConvert($aForm['keywords'],0,1);                                          //for japanese
    $aForm['currency_symbol']=JcodeConvert($aForm['currency_symbol'],0,1);                            //for japanese

    $aForm = changeMassTxt( $aForm, '' );

    if( is_uploaded_file( $_FILES['logo']['tmp_name'] ) && is_file( $_FILES['logo']['tmp_name'] ) && filesize( $_FILES['logo']['tmp_name'] ) > 0 && $oFoto->checkCorrectFile( $_FILES['logo']['name'], 'jpg|jpeg|gif|png' ) == true ){
      $sNewImg      = $oFoto->uploadFile( $_FILES['logo'], DIR_FILES.'img/', $_FILES['logo']['name'] );
      $aNewImgSize  = $oFoto->throwImgSize( DIR_FILES.'img/'.$sNewImg );
      if( $aNewImgSize['width'] <= 760 && $aNewImgSize['height'] <= 500 ){
        unlink( DIR_FILES.'img/'.$GLOBALS['config']['logo_img'] );
        $aForm['logo_img'] = $sNewImg;
      }
      else
        unlink( DIR_FILES.'img/'.$sNewImg );
    }

    $aFile = file( DB_PREFERENCES );

    $iCount = count( $aFile );

    $rFile = fopen( DB_PREFERENCES, 'w' );

    for( $i = 0; $i < $iCount; $i++ ){
      foreach( $aForm as $sKey => $sValue ){
        if( ereg( "config\['".$sKey."'\]", $aFile[$i] ) && ereg( '=', $aFile[$i] ) ){
          if( is_numeric( $sValue ) || checkCorrect( $sValue, 'true|false' ) == true )
            fwrite( $rFile, "\$config['".$sKey."']\t\t= ".$sValue.";\n" );
          else
            fwrite( $rFile, "\$config['".$sKey."']\t\t= \"".$sValue."\";\n" );
          $bWas = true;
          break;
        }
        else
          $bWas = false;
      }
      if( !$bWas )
        fwrite( $rFile, $aFile[$i] );
    } // end for
    fclose( $rFile );

  } // end function savePreferences
}

if( !function_exists( 'throwTrueFalseSelect' ) ){
  /**
  * Zwracanie wartosci w postaci true/false
  * @return string
  * @param bool $bTrueFalse
  */
  function throwTrueFalseSelect( $bTrueFalse = false ){
    
    $aSelect = Array( null, null );
    
    if( $bTrueFalse == true )
      $aSelect[1] = 'selected="selected"';
    else
      $aSelect[0] = 'selected="selected"';
    
    $sOption =  '<option value="true" '.$aSelect[1].'>'.LANG_YES_SHORT.'</option>';
    $sOption .= '<option value="false" '.$aSelect[0].'>'.LANG_NO_SHORT.'</option>';
    return $sOption;
  } // end function throwTrueFalseSelect
}

if( !function_exists( 'throwLangSelect' ) ){
  /**
  * Zwracanie spisu jezykow na podstawie plikow w katalogu lang
  * @return string
  * @param string $sLang
  */
  function throwLangSelect( $sLang = null ){
    global $oFF;
    $oDir = dir( DIR_LANG );
    
    $i =        0;
    $sOption =  null;

    while( false !== ( $sFile = $oDir->read( ) ) ) {
      if( $i > 1 ){
        if( is_file( DIR_LANG.$sFile ) )
          $sFileName = $oFF->throwNameOfFile( $sFile );
        else
          $sFileName = null;

        if( isset( $sFileName ) && strlen( $sFileName ) == 2 ){
          if( isset( $sLang ) && $sLang == $sFileName )
            $sSelected = 'selected="selected"';
          else
            $sSelected = null;

          $sOption .= '<option value="'.$sFileName.'" '.$sSelected.'>'.$sFileName.'</option>';
        }

      }
      $i++;
    } // end while

    $oDir->close( );
    return $sOption;
  } // end function throwLangSelect
}

if( !function_exists( 'checkLogin' ) ){
  /**
  * Sprawdzanie logowania uzytkownika
  * @return int
  * @param string $sLogin
  * @param string $sPass
  */
  function checkLogin( $sLogin, $sPass ){
    global $config;
    if( $config['login'] == $sLogin && $config['pass'] == $sPass ){
      $_SESSION['iUserQC'] = true;
      return 1;
    }
    else
      return 0;
  } // end function checkLogin
}
?>