<?php
if( !function_exists( 'dbThrowOrdersIdTemp' ) ){
  /**
  * Zwracanie id zamowienia
  * @return int
  * @param int    $iClient
  * @param string $sOption
  */
  function dbThrowOrdersIdTemp( $iClient, $sOption = null ){
    global $oFF;
    
    $iOrder = null;

    $aFile =  file( DIR_DB.DB_ORDERS );
    $iCount = count( $aFile );
    for( $i = 1; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i] );
      if( $iClient == $aExp[1] && $aExp[2] == 0 )
        $iOrder = $aExp[0];
    }

    if( !isset( $iOrder ) && $sOption == 'add' ){
      $iOrder = throwLastId( DB_ORDERS, 0 ) + 1;
      $oFF->setRow( Array( $iOrder, $iClient, 0, '', '', '', '', '', '', '', '', '', '', '' ) );
      $oFF->addToFile( DIR_DB.DB_ORDERS ); 
    }

    return $iOrder;
  } // end function dbThrowOrdersIdTemp
}

if( !function_exists( 'dbThrowOrder' ) ){
  /**
  * Zwracanie danych zamowienia
  * @return array
  * @param int  $iOrder
  */
  function dbThrowOrder( $iOrder ){
    return $GLOBALS['oFF']->throwData( DIR_DB.DB_ORDERS, $iOrder, 0 );
  } // end function dbThrowOrder
}

if( !function_exists( 'dbCheckBasketProducts' ) ){
  /**
  * Sprawdzanie produktow w koszyku
  * @return bool
  * @param int  $iOrder
  */
  function dbCheckBasketProducts( $iOrder ){
    $aFile =  file( DIR_DB.DB_ORDERS_PRODUCTS );
    $iCount = count( $aFile );
    for( $i = 1; $i < $iCount; $i++ ){
      $aExp =  explode( '$', $aFile[$i] );
      if( $aExp[1] == $iOrder ){
        return true;
      }
    }
    return false;
  } // end function dbCheckBasketProducts
}

if( !function_exists( 'dbAddBasketProduct' ) ){
  /**
  * Dodawanie produktu do koszyka
  * @return void
  * @param array  $aProduct
  * @param int    $iQuantity
  * @param int    $iOrder
  */
  function dbAddBasketProduct( $aProduct, $iQuantity, $iOrder ){
    $aFile =  file( DIR_DB.DB_ORDERS_PRODUCTS );
    $rFile =  fopen( DIR_DB.DB_ORDERS_PRODUCTS, 'w' );
    $iCount = count( $aFile );

    for( $i = 0; $i < $iCount; $i++ ){
      if( $i > 0 ){
        $aFile[$i] = ereg_replace( "\r", "", $aFile[$i] );
        $aExp =      explode( '$', $aFile[$i] );
        if( $aExp[1] == $iOrder && $aExp[2] == $aProduct['id'] ){
          $aFile[$i] = $aExp[0].'$'.$aExp[1].'$'.$aExp[2].'$'.sprintf( '%01.0f', $aExp[3] + $iQuantity ).'$'.$aExp[4]."$\n";
          $bExist = true;
        }
      }

      fwrite( $rFile, $aFile[$i] );
    } // end for

    if( !isset( $bExist ) ){
      $iElement = throwLastId( DB_ORDERS_PRODUCTS, 0 ) + 1;
      fwrite( $rFile, $iElement.'$'.$iOrder.'$'.$aProduct['id'].'$'.$iQuantity.'$'.$aProduct['price']."$\n" );
    }

    fclose( $rFile );
  } // end function dbAddBasketProduct
}

if( !function_exists( 'dbDelBasketElement' ) ){
  /**
  * Usuwanie elementow koszyka
  * @return void
  * @param int  $iOrder
  * @param int  $iElement
  */
  function dbDelBasketElement( $iOrder, $iElement ){
    $aFile =  file( DIR_DB.DB_ORDERS_PRODUCTS );
    $rFile =  fopen( DIR_DB.DB_ORDERS_PRODUCTS, 'w' );
    $iCount = count( $aFile );

    for( $i = 0; $i < $iCount; $i++ ){
      if( $i > 0 ){
        $aFile[$i] = ereg_replace( "\r", "", $aFile[$i] );
        $aExp =      explode( '$', $aFile[$i] );
        if( isset( $iElement ) ){
          if( $aExp[0] == $iElement && $aExp[1] == $iOrder )
            $aFile[$i] = '';
        }
        else{
          if( $aExp[1] == $iOrder )
            $aFile[$i] = '';
        }
      }

      fwrite( $rFile, $aFile[$i] );
    } // end for
    fclose( $rFile );
  } // end function dbDelBasketElement
}

if( !function_exists( 'dbDelOrderMass' ) ){
  /**
  * Usuwanie masowo i zwracanie zamowien, ktore byly nie dokonczone
  * dawniej niz 24h
  * @return array
  */
  function dbDelOrderMass( ){

    $aFile  = file( DIR_DB.DB_ORDERS );
    $iCount = count( $aFile );
    $rFile  = fopen( DIR_DB.DB_ORDERS, 'w' );
    $iTime  = time( );

    for( $i = 0; $i < $iCount; $i++ ){
      if( $i > 0 ){
        $aExp = explode( '$', $aFile[$i] );
        $iDiff = $iTime - substr( $aExp[1], 0, 10 );
        if( $aExp[2] == 0 && $iDiff >= 86400 ){
          $aFile[$i]      = null;
          $aId[$aExp[0]]  = true;
        }
      }
      fwrite( $rFile, $aFile[$i] );
    } // end for
    
    fclose( $rFile );
    
    if( isset( $aId ) && is_array( $aId ) ){
      $aFile  = file( DIR_DB.DB_ORDERS_PRODUCTS );
      $iCount = count( $aFile );
      $rFile  = fopen( DIR_DB.DB_ORDERS_PRODUCTS, 'w' );

      for( $i = 0; $i < $iCount; $i++ ){
        if( $i > 0 ){
          $aExp = explode( '$', $aFile[$i] );
          if( isset( $aId[$aExp[1]] ) ){
            $aFile[$i]  = null;
          }
        }
        fwrite( $rFile, $aFile[$i] );
      } // end for
      
      fclose( $rFile );
    }
    else
      $aId = null;

    return $aId;
  } // end function dbDelOrderMass
}

if( !function_exists( 'dbDelOrder' ) ){
  /**
  * Usuwanie zamowienia
  * @return void
  * @param int  $iOrder
  */
  function dbDelOrder( $iOrder ){
    $GLOBALS['oFF']->deleteInFile( DIR_DB.DB_ORDERS, $iOrder, 0 );
  } // end function dbDelOrder
}

if( !function_exists( 'dbListBasket' ) ){
  /**
  * Wyswietlanie koszyka
  * @return array
  * @param int  $iOrder
  */
  function dbListBasket( $iOrder ){
    return $GLOBALS['oFF']->throwFileArrayClause( DIR_DB.DB_ORDERS_PRODUCTS, null, 1, $iOrder );
  } // end function dbListBasket
}

if( !function_exists( 'dbListOrders' ) ){
  /**
  * Pobieranie z bazy zamowien
  * @return array
  */
  function dbListOrders( ){

    $aFile =      file( DIR_DB.DB_ORDERS );
    $iCount =     count( $aFile );
    $iFindPage =  0;
    $iFindAll =   0;
    rsort( $aFile, SORT_NUMERIC );

    for( $i = 1; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i] );
      if( $aExp[2] > 0 ){
        $iFindPage++;
        $iFindAll++;
        
        if( $iFindPage == 1 )
          $aPageStart[] = $i;

        if( isset( $aPageStart[$_GET['page'] - 1] ) && !isset( $aPageEnd[$_GET['page'] - 1] ) ){
          $aData[] = $aExp;
        }

        if( $iFindPage == ORDERS_LIST ){
          $aPageEnd[] = $i;
          $iFindPage =  0;
        }
      }
    } // end for

    if( isset( $aData ) ){
      $aData[0]['iFindAll'] = $iFindAll;
      return $aData;
    }
    else
      return null;
  } // end function dbListOrders
}

if( !function_exists( 'dbListOrdersStatus' ) ){
  /**
  * Pobieranie z bazy zamowien z wybranym statusem
  * @return array
  * @param int  $iStatus
  */
  function dbListOrdersStatus( $iStatus ){

    $aFile =      file( DIR_DB.DB_ORDERS );
    $iCount =     count( $aFile );
    $iFindPage =  0;
    $iFindAll =   0;
    rsort( $aFile, SORT_NUMERIC );

    for( $i = 1; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i] );
      if( $aExp[2] == $iStatus ){
        $iFindPage++;
        $iFindAll++;
        
        if( $iFindPage == 1 )
          $aPageStart[] = $i;

        if( isset( $aPageStart[$_GET['page'] - 1] ) && !isset( $aPageEnd[$_GET['page'] - 1] ) ){
          $aData[] = $aExp;
        }

        if( $iFindPage == ORDERS_LIST ){
          $aPageEnd[] = $i;
          $iFindPage =  0;
        }
      }
    } // end for

    if( isset( $aData ) ){
      $aData[0]['iFindAll'] = $iFindAll;
      return $aData;
    }
    else
      return null;
  } // end function dbListOrdersStatus
}

if( !function_exists( 'dbListOrdersSearch' ) ){
  /**
  * Pobieranie z bazy zamowien z wyszukiwanym slowem
  * @return array
  * @param string $sWord
  */
  function dbListOrdersSearch( $sWord ){

    $aFile =      file( DIR_DB.DB_ORDERS );
    $iCount =     count( $aFile );
    $iFindPage =  0;
    $iFindAll =   0;
    rsort( $aFile, SORT_NUMERIC );

    for( $i = 1; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i] );
      if( $aExp[2] > 0 && eregi( $sWord, $aFile[$i] ) ){
        $iFindPage++;
        $iFindAll++;
        
        if( $iFindPage == 1 )
          $aPageStart[] = $i;

        if( isset( $aPageStart[$_GET['page'] - 1] ) && !isset( $aPageEnd[$_GET['page'] - 1] ) ){
          $aData[] = $aExp;
        }

        if( $iFindPage == ORDERS_LIST ){
          $aPageEnd[] = $i;
          $iFindPage =  0;
        }
      }
    } // end for

    if( isset( $aData ) ){
      $aData[0]['iFindAll'] = $iFindAll;
      return $aData;
    }
    else
      return null;
  } // end function dbListOrdersSearch
}

if( !function_exists( 'dbSaveOrder' ) ){
  /**
  * Zapisywanie zamowienia
  * @return void
  * @param array  $aForm
  */
  function dbSaveOrder( $aForm ){
    global $oFF;
    $oFF->setRow( Array( $aForm['iOrder'], $_SESSION['iCustomer'], 1, $aForm['iCourier'], $aForm['sFirstName'], $aForm['sLastName'], $aForm['sCompanyName'], $aForm['sStreet'], $aForm['sZipCode'], $aForm['sCity'], $aForm['sTelephone'], $aForm['sEmail'], time( ), $_SERVER['REMOTE_ADDR'], $aForm['sComment'] ) );
    $oFF->changeInFile( DIR_DB.DB_ORDERS , $aForm['iOrder'], 0 );
  } // end function dbSaveOrder
}

if( !function_exists( 'dbSaveOrderStatus' ) ){
  /**
  * Zapisywanie statusu zamowienia
  * @return void
  * @param array  $aForm
  */
  function dbSaveOrderStatus( $aForm ){
    $aFile =  file( DIR_DB.DB_ORDERS );
    $rFile =  fopen( DIR_DB.DB_ORDERS, 'w' );
    $iCount = count( $aFile );

    for( $i = 0; $i < $iCount; $i++ ){
      if( $i > 0 ){
        $aFile[$i] = ereg_replace( "\r", "", $aFile[$i] );
        $aExp =      explode( '$', $aFile[$i] );
        if( $aExp[0] == $aForm['iOrder'] )
          $aFile[$i] = $aExp[0].'$'.$aExp[1].'$'.$aForm['iStatus'].'$'.$aExp[3].'$'.$aExp[4].'$'.$aExp[5].'$'.$aExp[6].'$'.$aExp[7].'$'.$aExp[8].'$'.$aExp[9].'$'.$aExp[10].'$'.$aExp[11].'$'.$aExp[12].'$'.$aExp[13].'$'.$aExp[14]."$\n";
      }

      fwrite( $rFile, $aFile[$i] );
    } // end for
    fclose( $rFile );
  } // end function dbSaveOrderStatus
}
?>