/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.xmlrules;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoadingException;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.commons.digester.xmlrules.XmlLoadException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DigesterLoader {
    public static Digester createDigester(InputSource inputSource) {
        FromXmlRuleSet fromXmlRuleSet = new FromXmlRuleSet(inputSource);
        Digester digester = new Digester();
        digester.addRuleSet(fromXmlRuleSet);
        return digester;
    }

    public static Digester createDigester(InputSource inputSource, Digester digester) {
        FromXmlRuleSet fromXmlRuleSet = new FromXmlRuleSet(inputSource, digester);
        Digester digester2 = new Digester();
        digester2.addRuleSet(fromXmlRuleSet);
        return digester2;
    }

    public static Digester createDigester(URL uRL) {
        FromXmlRuleSet fromXmlRuleSet = new FromXmlRuleSet(uRL);
        Digester digester = new Digester();
        digester.addRuleSet(fromXmlRuleSet);
        return digester;
    }

    public static Digester createDigester(URL uRL, Digester digester) {
        FromXmlRuleSet fromXmlRuleSet = new FromXmlRuleSet(uRL, digester);
        Digester digester2 = new Digester();
        digester2.addRuleSet(fromXmlRuleSet);
        return digester2;
    }

    public static Object load(URL uRL, ClassLoader classLoader, URL uRL2) throws IOException, SAXException, DigesterLoadingException {
        return DigesterLoader.load(uRL, classLoader, uRL2.openStream());
    }

    public static Object load(URL uRL, ClassLoader classLoader, InputStream inputStream) throws IOException, SAXException, DigesterLoadingException {
        Digester digester = DigesterLoader.createDigester(uRL);
        digester.setClassLoader(classLoader);
        try {
            return digester.parse(inputStream);
        }
        catch (XmlLoadException xmlLoadException) {
            throw new DigesterLoadingException(xmlLoadException.getMessage(), xmlLoadException);
        }
    }

    public static Object load(URL uRL, ClassLoader classLoader, Reader reader) throws IOException, SAXException, DigesterLoadingException {
        Digester digester = DigesterLoader.createDigester(uRL);
        digester.setClassLoader(classLoader);
        try {
            return digester.parse(reader);
        }
        catch (XmlLoadException xmlLoadException) {
            throw new DigesterLoadingException(xmlLoadException.getMessage(), xmlLoadException);
        }
    }

    public static Object load(URL uRL, ClassLoader classLoader, URL uRL2, Object object) throws IOException, SAXException, DigesterLoadingException {
        return DigesterLoader.load(uRL, classLoader, uRL2.openStream(), object);
    }

    public static Object load(URL uRL, ClassLoader classLoader, InputStream inputStream, Object object) throws IOException, SAXException, DigesterLoadingException {
        Digester digester = DigesterLoader.createDigester(uRL);
        digester.setClassLoader(classLoader);
        digester.push(object);
        try {
            return digester.parse(inputStream);
        }
        catch (XmlLoadException xmlLoadException) {
            throw new DigesterLoadingException(xmlLoadException.getMessage(), xmlLoadException);
        }
    }

    public static Object load(URL uRL, ClassLoader classLoader, Reader reader, Object object) throws IOException, SAXException, DigesterLoadingException {
        Digester digester = DigesterLoader.createDigester(uRL);
        digester.setClassLoader(classLoader);
        digester.push(object);
        try {
            return digester.parse(reader);
        }
        catch (XmlLoadException xmlLoadException) {
            throw new DigesterLoadingException(xmlLoadException.getMessage(), xmlLoadException);
        }
    }
}

